// ScriptSelect.cpp : implementation file
//

#include "stdafx.h"
#include "monitor.h"
#include "ScriptSelect.h"
#include "engine.h"
#include "checksum.h"
#include "core/crc.h"
#include "ignore.h"

#include <gel/net/net.h>
#include <gel/net/server/netserv.h>
#include <gel/net/client/netclnt.h>
#include "sk/gamenet/scriptdebugger.h"
#include "gel/scripting/debugger.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CScriptSelect dialog


CScriptSelect::CScriptSelect(CWnd* pParent /*=NULL*/)
	: CDialog(CScriptSelect::IDD, pParent)
{
	//{{AFX_DATA_INIT(CScriptSelect)
	m_script_name = _T("");
	//}}AFX_DATA_INIT
}


void CScriptSelect::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CScriptSelect)
	DDX_Text(pDX, IDC_SCRIPT_NAME, m_script_name);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CScriptSelect, CDialog)
	//{{AFX_MSG_MAP(CScriptSelect)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScriptSelect message handlers

void CScriptSelect::OnOK() 
{
	CDialog::OnOK();

	// The ignored list contains a list of the id's of recently closed script windows.
	// These are scripts that have not necessarily died, they've just had their window 
	// closed by the user. Late script info messages for scripts in this list will 
	// be ignored.
	// However, when adding a script name to watch, the list needs to be cleared to ensure
	// new script info messages are not ignored.
	gIgnoredScriptsIdList.Clear();


	uint32 p_data[3];

	p_data[0]=IsDlgButtonChecked(IDC_STOP_SCRIPT);
	p_data[1]=Dbg::CHECKSUM_IS_SCRIPT_NAME;

	char p_script_name[100];
	GetDlgItemText(IDC_SCRIPT_NAME,p_script_name,100);
	p_data[2]=Crc::GenerateCRCFromString(p_script_name);

	Net::MsgDesc msg;
	msg.m_Id = GameNet::vMSG_ID_DBG_WATCH_SCRIPT;
	msg.m_Length=sizeof(p_data);
	msg.m_Data=p_data;
	gClient->EnqueueMessageToServer(&msg);
}

BOOL CScriptSelect::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	// Make the script name entry control have focus initially.
	CDialog::GetDlgItem(IDC_SCRIPT_NAME)->SetFocus();

	return FALSE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
