// ObjectSelect.cpp : implementation file
//

#include "stdafx.h"
#include "Monitor.h"
#include "ObjectSelect.h"
#include "engine.h"
#include "checksum.h"
#include "core/crc.h"

#include <gel/net/net.h>
#include <gel/net/server/netserv.h>
#include <gel/net/client/netclnt.h>
#include "sk/gamenet/scriptdebugger.h"
#include <gel/scripting/checksum.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CObjectSelect dialog


CObjectSelect::CObjectSelect(CWnd* pParent /*=NULL*/)
	: CDialog(CObjectSelect::IDD, pParent)
{
	//{{AFX_DATA_INIT(CObjectSelect)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CObjectSelect::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CObjectSelect)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CObjectSelect, CDialog)
	//{{AFX_MSG_MAP(CObjectSelect)
	ON_CBN_EDITCHANGE(IDC_COMBO1, OnEditchangeCombo1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CObjectSelect message handlers


void CObjectSelect::OnEditchangeCombo1() 
{
	// TODO: Add your control notification handler code here
	
}

void CObjectSelect::OnOK() 
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();

	char p_text[100];
	GetDlgItemText(IDC_COMBO2,p_text,100);

	// Skip leading white space
	char *p_start=p_text;
	while (*p_start==' ' || *p_start=='\t')
	{
		++p_start;
	}

	// Remove any trailing white space
	char *p_end=p_start;
	while (*p_end)
	{
		if (*p_end==' ' || *p_end=='\t')
		{
			*p_end=0;
			break;
		}
		++p_end;
	}

	uint32 checksum=0;
	if (*p_start)
	{
		checksum=Crc::GenerateCRCFromString(p_start);
		Script::AddChecksumName(checksum,p_start);
	}

	Net::MsgDesc msg;
	msg.m_Id = GameNet::vMSG_ID_DBG_WATCH_THIS;
	msg.m_Length=4;
	msg.m_Data=&checksum;
	gClient->EnqueueMessageToServer(&msg);
}
