// MyListView.cpp : implementation file
//

#include "stdafx.h"
#include "Monitor.h"
#include "MyListView.h"
#include "MyTreeCtrl.h"
#include "utils.h"
#include "debuggerbutton.h"
#include "MyCode.h"
#include "debuggerbutton.h"

int WM_SORT_TREE_BY_CPU_TIME = RegisterWindowMessage ("SORT_TREE_BY_CPU_TIME");
int WM_EXPAND_ALL = RegisterWindowMessage ("EXPAND_ALL");
int WM_COLLAPSE_ALL = RegisterWindowMessage ("COLLAPSE_ALL");

// CMyListView

IMPLEMENT_DYNCREATE(CMyListView, CView)

CMyListView::CMyListView()
{
	mp_tree=NULL;

	m_width=300;
	m_height=400;

	m_button_height=20;
	m_button_width=100;

	m_num_buttons=0;
	for (int i=0; i<MAX_BUTTONS; ++i)
	{
		mp_buttons[i]=NULL;
	}
	mp_button_font=NULL;

	m_got_top_text=false;
	m_top_text_height=0;
	mp_text_font=NULL;
	m_top_text="";
}

CMyListView::~CMyListView()
{
	if (mp_tree)
	{
		delete mp_tree;
	}
	
	remove_buttons();

	if (mp_button_font)
	{
		delete mp_button_font;
	}
	if (mp_text_font)
	{
		delete mp_text_font;
	}
}

BEGIN_MESSAGE_MAP(CMyListView, CView)
	ON_WM_CREATE()
	ON_WM_KEYDOWN()
	ON_WM_SIZE()
	ON_WM_ERASEBKGND()
END_MESSAGE_MAP()


// CMyListView drawing

void CMyListView::OnDraw(CDC* pDC)
{
	if (m_got_top_text)
	{
		pDC->SetBkColor((COLORREF)0xc0c0c0);
		pDC->SelectObject(mp_text_font);
		
		RECT rect;
		rect.left=3;
		rect.top=3;
		rect.right=m_width;
		rect.bottom=m_top_text_height;
		pDC->DrawText(m_top_text,&rect,0);
	}
}

void CMyListView::indicate_waiting_for_reply()
{
	CDocument *p_doc=GetDocument();
	p_doc->SetTitle("Waiting for reply ...");
}

void CMyListView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();

	// Change the width and height so that all the controls I'm adding are visible.
	// The SWP_NOMOVE means keep the x,y coord of the top left corner the same as it
	// is currently, so that the passed x,y of 0,0 is ignored.
	GetParent()->SetWindowPos(NULL, 0,0, m_width,m_height, SWP_NOMOVE);

	mp_tree=new CMyTreeCtrl;
	mp_tree->Create(TVS_HASLINES | 
					TVS_LINESATROOT |
					TVS_HASBUTTONS |
					TVS_NOTOOLTIPS |
					TVS_EDITLABELS |
					WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_VSCROLL | WS_HSCROLL,
					CRect(0, 0, m_width-12, m_height-31), this, 111);

	mp_tree->SetBkColor((COLORREF)0xc0c0c0);
	
	indicate_waiting_for_reply();
}

// CMyListView diagnostics

#ifdef _DEBUG
void CMyListView::AssertValid() const
{
	CView::AssertValid();
}

void CMyListView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG

enum 
{
	BUTTON_TOP_MARGIN=3,
	BUTTON_BOTTOM_MARGIN=3,
	BUTTON_LEFT_MARGIN=3,
	BUTTON_X_SEP=3,
};

void CMyListView::remove_buttons()
{
	for (int i=0; i<MAX_BUTTONS; ++i)
	{
		if (mp_buttons[i])
		{
			delete mp_buttons[i];
			mp_buttons[i]=NULL;
		}
	}
	m_num_buttons=0;
}

// Returns the index of the new button, or -1 if no button was added.
int CMyListView::add_button(const char *p_text, int messageToSendToParent)
{
	if (m_num_buttons >= MAX_BUTTONS)
	{
		return -1;
	}

	CDebuggerButton *p_button=new CDebuggerButton(messageToSendToParent);

	int x=BUTTON_LEFT_MARGIN+(m_button_width+BUTTON_X_SEP)*m_num_buttons;
	p_button->Create(	p_text,
						WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_BORDER,
						CRect(x, BUTTON_TOP_MARGIN, x+m_button_width, BUTTON_TOP_MARGIN+m_button_height), this, 112+m_num_buttons);

	if (!mp_button_font)
	{
		mp_button_font=new CFont;
		mp_button_font->CreateFont(
		15,                        // nHeight
		0,                         // nWidth
		0,                         // nEscapement
		0,                         // nOrientation
		FW_NORMAL,                 // nWeight
		FALSE,                     // bItalic
		FALSE,                     // bUnderline
		0,                         // cStrikeOut
		ANSI_CHARSET,              // nCharSet
		OUT_DEFAULT_PRECIS,        // nOutPrecision
		CLIP_DEFAULT_PRECIS,       // nClipPrecision
		DEFAULT_QUALITY,           // nQuality
		DEFAULT_PITCH | FF_SWISS,  // nPitchAndFamily
		_T("Times New Roman"));                 // lpszFacename
	}

	p_button->SetFont(mp_button_font);

	mp_buttons[m_num_buttons++]=p_button;

	// Adjust the position of the top of the tree control to make way for the buttons.
	int margin=BUTTON_TOP_MARGIN+m_button_height+BUTTON_BOTTOM_MARGIN;
	mp_tree->SetWindowPos(NULL, 0,margin, m_width-12, m_height-31-margin, 0);

	return m_num_buttons-1;
}

void CMyListView::move_buttons_and_tree_down(int dy)
{
	for (int i=0; i<m_num_buttons; ++i)
	{
		int x=BUTTON_LEFT_MARGIN+(m_button_width+BUTTON_X_SEP)*i;
		mp_buttons[i]->SetWindowPos(NULL, x, BUTTON_TOP_MARGIN+dy, m_button_width, m_button_height, 0);
	}

	int margin=dy;
	if (m_num_buttons)
	{
		margin+=BUTTON_TOP_MARGIN+m_button_height+BUTTON_BOTTOM_MARGIN;
	}
	mp_tree->SetWindowPos(NULL, 0,margin, m_width-12, m_height-31-margin, 0);
}

void CMyListView::enable_top_text(int height, const char *p_fontName)
{
	move_buttons_and_tree_down(height);

	m_top_text_height=height;
	m_got_top_text=true;

	if (!mp_text_font)
	{
		mp_text_font=new CFont;
		mp_text_font->CreateFont(
		15,                        // nHeight
		0,                         // nWidth
		0,                         // nEscapement
		0,                         // nOrientation
		FW_NORMAL,                 // nWeight
		FALSE,                     // bItalic
		FALSE,                     // bUnderline
		0,                         // cStrikeOut
		ANSI_CHARSET,              // nCharSet
		OUT_DEFAULT_PRECIS,        // nOutPrecision
		CLIP_DEFAULT_PRECIS,       // nClipPrecision
		DEFAULT_QUALITY,           // nQuality
		DEFAULT_PITCH | FF_SWISS,  // nPitchAndFamily
		_T(p_fontName));                 // lpszFacename
	}
}

void CMyListView::support_profiling_info()
{
	int index=add_button("Sort by CPU time",WM_SORT_TREE_BY_CPU_TIME);
	if (index<0) return;

	mp_buttons[index]->SetToggleable();
	// TODO Disabled until it is functional ...
	mp_buttons[index]->EnableWindow(FALSE);

	enable_top_text(20);
}

void CMyListView::show_total_cpu_time()
{
	m_top_text="Total CPU time = ...";
}

void CMyListView::add_expand_collapse_buttons()
{
	add_button("Expand All",WM_EXPAND_ALL);
	add_button("Collapse All",WM_COLLAPSE_ALL);
	enable_top_text(20);
}

// CMyListView message handlers

afx_msg LRESULT CMyListView::OnSortTreeByCPUTime(WPARAM wParam, LPARAM lParam)
{
	if (mp_buttons[0]->GetToggleState())
	{
		Printf("Sort by CPU time");
	}
	else
	{
		Printf("Don't sort by CPU time");
	}
	return (LRESULT)0;
}

afx_msg LRESULT CMyListView::OnExpandAll(WPARAM wParam, LPARAM lParam)
{
	mp_tree->ExpandAll();
	return (LRESULT)0;
}

afx_msg LRESULT CMyListView::OnCollapseAll(WPARAM wParam, LPARAM lParam)
{
	mp_tree->ExpandAll(TVE_COLLAPSE);
	// but still make the parent expanded for convenience.
	mp_tree->Expand(mp_tree->GetRootItem(),TVE_EXPAND);
	return (LRESULT)0;
}

int CMyListView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;

	return 0;
}

void CMyListView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	ConvertKeyPressToMessage(nChar,this);	

	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CMyListView::OnSize(UINT nType, int cx, int cy)
{
	CView::OnSize(nType, cx, cy);

	if (mp_tree)
	{
		if (m_num_buttons)
		{
			// If there be buttons, leave room for them at the top.
			int margin=BUTTON_TOP_MARGIN+m_button_height+BUTTON_BOTTOM_MARGIN+m_top_text_height;
			mp_tree->SetWindowPos(NULL, 0,margin, cx, cy-margin, 0);
		}
		else
		{
			mp_tree->SetWindowPos(NULL, 0,m_top_text_height, cx, cy-m_top_text_height, SWP_NOMOVE);
		}
	}
}

// Make the background be the same color as the tree control, otherwise the buttons
// will be on the default white background.
BOOL CMyListView::OnEraseBkgnd(CDC* pDC)
{
	// Set brush to desired background color
	CBrush backBrush(RGB(0xc0, 0xc0, 0xc0));
	// Save old brush
	CBrush* pOldBrush = pDC->SelectObject(&backBrush);
	CRect rect;
	pDC->GetClipBox(&rect); // Erase the area needed
	pDC->PatBlt(rect.left, rect.top, rect.Width(), 	rect.Height(), PATCOPY);
	pDC->SelectObject(pOldBrush);
	return TRUE;
	//return CView::OnEraseBkgnd(pDC);
}
