// Monitor.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "Monitor.h"

#include "MainFrm.h"
#include "ChildFrm.h"
#include "MonitorDoc.h"
#include "MonitorView.h"
#include "scriptlistview.h"
#include "watchlistview.h"
#include "printfview.h"

#include "mycode.h"
#include "engine.h"
#include "checksum.h"
#include "ChecksumDownloadProgress.h"
#include "ChecksumEntryDialog.h"
#include "objectselect.h"
#include "scriptselect.h"
#include "objectview.h"
#include "objectlistview.h"
#include "scriptglobalview.h"
#include "utils.h"

#include <gel/net/net.h>
#include <gel/net/server/netserv.h>
#include <gel/net/client/netclnt.h>
#include <sk/gamenet/scriptdebugger.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

HWND gHWnd;

/////////////////////////////////////////////////////////////////////////////
// CMonitorApp

BEGIN_MESSAGE_MAP(CMonitorApp, CWinApp)
	//{{AFX_MSG_MAP(CMonitorApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_HELP_SCRIPTDEBUGGERHELP, OnHelp)
	ON_COMMAND(ID_FILE_REFRESH, OnRefresh)
	ON_COMMAND(ID_FILE_CONNECTTOSERVER, OnConnectToServer)
	ON_COMMAND(ID_FILE_CLEARSCRIPTWATCHES, OnClearScriptWatches)
	ON_COMMAND(ID_MOUSEEDGE_LEFT, OnMouseEdgeLeft)
	ON_COMMAND(ID_MOUSEEDGE_RIGHT, OnMouseEdgeRight)
	ON_COMMAND(ID_PLATFORM_PS2, OnPlatformPS2)
	ON_COMMAND(ID_PLATFORM_XBOX, OnPlatformXBox)
	// Comment in once network stuff is supported on GameCube ...
	//ON_COMMAND(ID_PLATFORM_GAMECUBE, OnPlatformGameCube)
	ON_COMMAND(IDM_LOAD_CHECKSUM_NAMES, OnLoadChecksumNames)
	ON_COMMAND(IDM_LOOKUP_CHECKSUM, OnLookupChecksum)
	ON_COMMAND(IDM_OBJECT_SELECT, OnObjectSelect)
	ON_COMMAND(IDM_SCRIPT_SELECT, OnScriptSelect)
	ON_COMMAND(ID_WINDOW_CLOSEALL, OnClear)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMonitorApp construction

CMonitorApp::CMonitorApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CMonitorApp object

CMonitorApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CMonitorApp initialization

BOOL CMonitorApp::InitInstance()
{
	/*if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}*/

	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	mpMultiDocTemplate = new CMultiDocTemplate(
		IDR_MONITOTYPE,
		RUNTIME_CLASS(CMonitorDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CMonitorView));
	AddDocTemplate(mpMultiDocTemplate );


	mpScriptListDocTemplate=new CMultiDocTemplate(
		IDR_MONITOTYPE,
		RUNTIME_CLASS(CMonitorDoc),
		RUNTIME_CLASS(CChildFrame),
		RUNTIME_CLASS(CScriptListView));
	AddDocTemplate(mpScriptListDocTemplate);
	
	mpWatchListDocTemplate=new CMultiDocTemplate(
		IDR_MONITOTYPE,
		RUNTIME_CLASS(CMonitorDoc),
		RUNTIME_CLASS(CChildFrame),
		RUNTIME_CLASS(CWatchListView));
	AddDocTemplate(mpWatchListDocTemplate);

	mpPrintfDocTemplate=new CMultiDocTemplate(
		IDR_MONITOTYPE,
		RUNTIME_CLASS(CMonitorDoc),
		RUNTIME_CLASS(CChildFrame),
		RUNTIME_CLASS(CPrintfView));
	AddDocTemplate(mpPrintfDocTemplate);

	mpObjectDocTemplate=new CMultiDocTemplate(
		IDR_MONITOTYPE,
		RUNTIME_CLASS(CMonitorDoc),
		RUNTIME_CLASS(CChildFrame),
		RUNTIME_CLASS(CObjectView));
	AddDocTemplate(mpObjectDocTemplate);

	mpObjectListDocTemplate=new CMultiDocTemplate(
		IDR_MONITOTYPE,
		RUNTIME_CLASS(CMonitorDoc),
		RUNTIME_CLASS(CChildFrame),
		RUNTIME_CLASS(CObjectListView));
	AddDocTemplate(mpObjectListDocTemplate);

	mpScriptGlobalDocTemplate=new CMultiDocTemplate(
		IDR_MONITOTYPE,
		RUNTIME_CLASS(CMonitorDoc),
		RUNTIME_CLASS(CChildFrame),
		RUNTIME_CLASS(CScriptGlobalView));
	AddDocTemplate(mpScriptGlobalDocTemplate);

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;
	gHWnd = m_pMainWnd->m_hWnd;


	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;

	// Change m_nShellCommand value to FileNothing
	cmdInfo.m_nShellCommand = CCommandLineInfo::FileNothing ;

	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	mpPrintfDocTemplate->OpenDocumentFile(NULL);

	MyCodeInit();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CMonitorApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CMonitorApp message handlers

void CMonitorApp::OnHelp()
{
	BringUpHelpFile("The_Script_Debugger");
}

int CMonitorApp::ExitInstance() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	CleanUp();
	
	return CWinApp::ExitInstance();
}

void CMonitorApp::OnConnectToServer()
{
	ConnectToServer();
}

void CMonitorApp::OnRefresh()
{
	mpMultiDocTemplate->CloseAllDocuments(FALSE);
	mpPrintfDocTemplate->CloseAllDocuments(FALSE);
	mpPrintfDocTemplate->OpenDocumentFile(NULL);

	Net::MsgDesc msg;
	msg.m_Id = GameNet::vMSG_ID_DBG_REFRESH;
	gClient->EnqueueMessageToServer(&msg);
}

void CMonitorApp::OnClearScriptWatches()
{
	Net::MsgDesc msg;
	msg.m_Id = GameNet::vMSG_ID_DBG_CLEAR_SCRIPT_WATCHES;
	gClient->EnqueueMessageToServer(&msg);
}

void CMonitorApp::OnLoadChecksumNames() 
{
	Printf("Extracting checksum names from all qb files ...");
	const char *p_path=getenv("PROJ_ROOT");
	if (p_path)
	{
		char p_buf[1000];
		sprintf(p_buf,"%s\\data",p_path);
		Script::LoadChecksumNamesFromPath(p_buf);
		Printf("Finished");
	}
	else
	{
		Printf("Error! The env var PROJ_ROOT needs to be set");
	}
}

void CMonitorApp::OnLookupChecksum() 
{
	// TODO: Add your command handler code here
	CChecksumEntryDialog dlg;
	dlg.DoModal();
}

void CMonitorApp::OnObjectSelect() 
{
	// TODO: Add your command handler code here
	CObjectSelect dlg;
	dlg.DoModal();
}

void CMonitorApp::OnScriptSelect() 
{
	CScriptSelect dlg;
	dlg.DoModal();
}

void CMonitorApp::OnMouseEdgeLeft()
{
	SetMouseEdgeLeft();
}

void CMonitorApp::OnMouseEdgeRight()
{
	SetMouseEdgeRight();
}

void CMonitorApp::OnPlatformPS2()
{
	SetPlatformPS2();
}

void CMonitorApp::OnPlatformXBox()
{
	SetPlatformXBox();
}

void CMonitorApp::OnPlatformGameCube()
{
}

void CMonitorApp::OnClear()
{
	mpObjectDocTemplate->CloseAllDocuments(FALSE);
}

HWND CMonitorApp::GetOrCreateWatchWindow(unsigned long id)
{
	CWindowInfo *p_window_info=gpWindowHashTable->GetItem(id);
	if (!p_window_info)
	{
		// The window does not exist yet! So create it ...
		
		// This global is used to pass info to and from the CMonitorView OnCreate function,
		// which gets called somewhere within the MFC function OpenDocumentFile
		gNewWindowParams.mId=id;

		CDocument *p_new_document=mpMultiDocTemplate->OpenDocumentFile(NULL);
	
		// The CMonitorView OnCreate will have added itself to the hash table,
		// and filled in gNewWindowParams.mInfo
		return gNewWindowParams.mInfo.mViewHWND;
	}
	else
	{
		return p_window_info->mViewHWND;
	}
}

HWND CMonitorApp::GetOrCreateObjectWindow(unsigned long id)
{
	CWindowInfo *p_window_info=gpObjectWindowHashTable->GetItem(id);
	if (!p_window_info)
	{
		// The window does not exist yet! So create it ...
		
		// This global is used to pass info to and from the CObjectView OnCreate function,
		// which gets called somewhere within the MFC function OpenDocumentFile
		gNewWindowParams.mId=id;

		CDocument *p_new_document=mpObjectDocTemplate->OpenDocumentFile(NULL);
	
		// The CObjectView OnCreate will have added itself to the hash table,
		// and filled in gNewWindowParams.mInfo
		return gNewWindowParams.mInfo.mViewHWND;
	}
	else
	{
		return p_window_info->mViewHWND;
	}
}

HWND CMonitorApp::GetOrCreateScriptGlobalWindow(unsigned long id)
{
	CWindowInfo *p_window_info=gpScriptGlobalWindowHashTable->GetItem(id);
	if (!p_window_info)
	{
		// The window does not exist yet! So create it ...
		
		// This global is used to pass info to and from the CObjectView OnCreate function,
		// which gets called somewhere within the MFC function OpenDocumentFile
		gNewWindowParams.mId=id;

		CDocument *p_new_document=mpScriptGlobalDocTemplate->OpenDocumentFile(NULL);
	
		// The CObjectView OnCreate will have added itself to the hash table,
		// and filled in gNewWindowParams.mInfo
		return gNewWindowParams.mInfo.mViewHWND;
	}
	else
	{
		return p_window_info->mViewHWND;
	}
}
