/*
	FaceFlagger.h
	A utility plugin for automatically applying face flags
	aml
*/

#ifndef __FACEFLAGGER__
#define __FACEFLAGGER__

#include "max.h"
#include "utilapi.h"
#include "iparamb2.h"
#include "../FaceFlags/FaceFlags.h"
#include "meshadj.h"

#define vFACE_FLAGGER_CLASS_ID  Class_ID(0x6b6c7c1f, 0x4d494331)
#define  UNITS_TO_FEET   0.083333333333f
#define  UNITS_TO_INCH   1.0f 
#define  FEET_TO_UNITS   (1.0f / UNITS_TO_FEET)
#define  INCHES_TO_FEET  (1.0f / 12.0f)

class FaceFlagger: public UtilityObj
{
	Interface*       ip;
	HWND             hwndRollup;
	ICustEdit        *minEdgeWR,        *minEdgeCC;
	ISpinnerControl  *minEdgeSpinWR,    *minEdgeSpinCC;
	ICustEdit        *minPreventEdgeWR, *minPreventEdgeCC;
	ISpinnerControl  *minPreventEdgeSpinWR, *minPreventEdgeSpinCC;
	ICustEdit        *vertTolWR;
	ISpinnerControl  *vertTolSpinWR;

	static BOOL CALLBACK DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	void AutoAssignFaceFlagsOld();
	void AutoAssignFaceFlags();
	void AutoAssignFaceFlagsSel();
	void AutoAssignFaceFlags(INode* node);

	void GetEdgeSizes(Mesh& mesh, Face face, 
					  float& sAB, float& sBC, float& sAC);

	void GetEdgeMinMax(float s1, float s2, float s3,
					   float& min, float& max);

	inline float GetMinEdgeWR()
	{
		return minEdgeSpinWR->GetFVal() * INCHES_TO_FEET * FEET_TO_UNITS;
	}

	inline float GetMinEdgeCC()
	{
		return minEdgeSpinCC->GetFVal() * INCHES_TO_FEET * FEET_TO_UNITS;
	}

	inline float GetMinPreventEdgeWR()
	{
		return minPreventEdgeSpinWR->GetFVal() * INCHES_TO_FEET * FEET_TO_UNITS;
	}

	inline float GetMinPreventEdgeCC()
	{
		return minPreventEdgeSpinCC->GetFVal() * INCHES_TO_FEET * FEET_TO_UNITS;
	}

	inline float GetVertTolWR()
	{
		return vertTolSpinWR->GetFVal();
	}

	bool CheckFaceWallRideable(Matrix3 TM, Mesh& mesh, FaceFlagsData* fdc, AdjEdgeList* elist, int face);
	bool CheckFaceCameraCollidable(Matrix3 TM, Mesh& mesh, FaceFlagsData* fdc, AdjEdgeList* elist, int face);
	float GetMaxAltEdgeLength(Mesh& mesh, FaceFlagsData* fdc, AdjEdgeList* elist, int face, int edge);
	void  ScanFaces(Matrix3 TM, Mesh& mesh, FaceFlagsData* fdc, AdjEdgeList* elist);

public:
	FaceFlagger();
	~FaceFlagger();

	virtual void BeginEditParams(Interface *ip,IUtil *iu);
	virtual void EndEditParams(Interface *ip,IUtil *iu);
	virtual void SelectionSetChanged(Interface *ip,IUtil *iu);
	virtual void DeleteThis() { delete this; }
};

class FaceFlaggerClassDesc: public ClassDesc2 {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading) { return new FaceFlagger(); }
	const TCHAR *	ClassName() {return _T("NeverSoft Face Flagger Tool"); }
	SClass_ID		SuperClassID() {return UTILITY_CLASS_ID;}
	Class_ID 		ClassID() {return vFACE_FLAGGER_CLASS_ID;}
	const TCHAR* 	Category() {return _T("FaceFlagger");}
	const TCHAR*	InternalName() { return _T("FaceFlagger"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }				// returns owning module handle	
};

#endif
