/*
	WibbleWatcher.h
	Provides functionality to verify wibble data integrity
	aml - 11-7-02
*/

#ifndef WIBBLEWATCHER_H
#define WIBBLEWATCHER_H

#include "max.h"
#define VERIFYWIBBLE(mesh) VerifyWibbleIntegrity(mesh,"Explicit","<Unknown>",__LINE__,__FILE__)

void ResetWibbleWatcher();
bool VerifyWibbleIntegrity(Mesh& mesh, char* strMode="Explicit", char* strNode="<unknown>", int line=0, char* strFile="<unknown>");
void InstallPeriodicWibbleWatcher();
void UnInstallPeriodicWibbleWatcher();

#endif
