/*
	ViewportUI.h
	Functionality for overriding MAX's viewport windows and 
	hooking into their message loops so we can intercept mouse 
	and other actions normally not possible through SDK calls alone
	aml - 4/1/03
*/

#ifndef __VIEWPORTUI__
#define __VIEWPORTUI__

#include "max.h"
#include "notify.h"

class ViewportUI
{
	HWND      *hwndViewports;	// List of viewport windows
	HWND       hwndViewpanel;
	WNDPROC   *wndProcOrig;		// Original wndprocs for each subclassed viewport window
	int        numViewports;	// Number of MAX Viewport windows
	int        curStoreIdx;
	Interface *ip;

	static BOOL CALLBACK findViewpanel(HWND hwnd, LPARAM lParam);
	static BOOL CALLBACK countViewports(HWND hwnd, LPARAM lParam);
	static BOOL CALLBACK storeViewports(HWND hwnd, LPARAM lParam);
	
	// Called by MAX whenever the user changes the viewports (so we can rehook the new viewports)
	static void viewport_change_handler(void *param, NotifyInfo *info);

	static LRESULT CALLBACK HookWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

public:
	ViewportUI(Interface* ip);
	~ViewportUI();

	void GetViewports();
	void HookViewports();
	void UnHookViewports();

	WNDPROC GetOrigWndProc(int  viewportIdx);
	WNDPROC GetOrigWndProc(HWND hwndViewport);
};

ViewportUI* GetViewportManager();

#endif
