#include "FuncEnter.h"

/*
	UserConfig.cpp
	aml - 6-11-03
 */

#include "UserConfig.h"
#include "path.h"

extern Interface* gInterface;

CStr GetQNOptimizePath()
{ FUNC_ENTER("GetQNOptimizePath"); 
	CStr appDir = CStr(gInterface->GetDir(APP_PLUGCFG_DIR)) + "\\Next.ini";
	char* envbuf = getenv(APP_ENV);

	if (!envbuf)
	{
		char strErr[256];
		sprintf(strErr, "The environment variable '%s' is not defined.  Cannot continue.", APP_ENV);
		MessageBox(gInterface->GetMAXHWnd(), strErr, "GetTemplatePath", MB_ICONSTOP|MB_OK);
		return CStr("");
	}

	CStr path = envbuf;

	char buf[256];
	GetPrivateProfileString("Directories", "QNOptimizePath", "data\\scripts\\engine\\", buf, 255, appDir);

	return path + CStr("\\") + CStr(buf);	
}

CStr GetQNOptimizeName()
{ FUNC_ENTER("GetQNOptimizeName"); 
	CStr appDir = CStr(gInterface->GetDir(APP_PLUGCFG_DIR)) + "\\Next.ini";

	char buf[256];
	GetPrivateProfileString("Directories", "QNOptimizeFile", "node_compress.q", buf, 255, appDir);

	return CStr(buf);	
}

CStr GetTemplatePath()
{ FUNC_ENTER("GetTemplatePath"); 
	CStr appDir = CStr(gInterface->GetDir(APP_PLUGCFG_DIR)) + "\\Next.ini";
	char* envbuf = getenv(APP_ENV);

	if (!envbuf)
	{
		char strErr[256];
		sprintf(strErr, "The environment variable '%s' is not defined.  Cannot continue.", APP_ENV);
		MessageBox(gInterface->GetMAXHWnd(), strErr, "GetTemplatePath", MB_ICONSTOP|MB_OK);
		return CStr("");
	}

	CStr path = envbuf;

	char buf[256];
	GetPrivateProfileString("Directories", "TemplatePath", "data\\scripts\\templates\\", buf, 255, appDir);

	return path + CStr("\\") + CStr(buf);
}

CStr GetScriptsIniPath()
{ FUNC_ENTER("GetScriptsIniPath"); 
	CStr appDir = CStr(gInterface->GetDir(APP_PLUGCFG_DIR)) + "\\Next.ini";
	char* envbuf = getenv(APP_ENV);

	if (!envbuf)
	{
		char strErr[256];
		sprintf(strErr, "The environment variable '%s' is not defined. Cannot continue.", APP_ENV);
		MessageBox(gInterface->GetMAXHWnd(), strErr, "GetScriptsIniPath", MB_ICONSTOP|MB_OK);
		return CStr("");
	}

	CStr path = envbuf;

	char buf[256];
	GetPrivateProfileString("Directories", "ScriptIniPath", "data\\scripts\\scripts.ini", buf, 255, appDir);

	return path + CStr("\\") + CStr(buf);
}
