/*
	ThumbnailList.h
	UI Control for displaying parameters in a list with a
	thumbnail image to the right of each entry
*/

#ifndef __THUMBNAILLIST__
#define __THUMBNAILLIST__

#include "UIControl.h"

#define THUMBNAILLIST_CLASSNAME "ThumbnailList"

class ThumbNailList: public UIControl
{
	HWND hwndList;			// The actual owner-drawn list box, we're creating

	LRESULT WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	void    BuildControlUI();

	HWND    BuildDropdown(HWND hwndParent, RECT rect, int entryID);

	CRITICAL_SECTION cs;	// Critical section object for syncronization when Load threads respond

	// Thread func to do asynchronous loading of images
	static DWORD WINAPI LoadImageThread(void* pData);

public:
	CLASSNAME(THUMBNAILLIST_CLASSNAME)

	ThumbNailList(HINSTANCE hInstance);
	ThumbNailList(HINSTANCE hInstance, HWND hwnd);
	~ThumbNailList();

	int  AddItem(char* name, char* filename, void* pData = NULL);
	void RemoveItem(int index);
	void Clear();
};

#endif
