#include "FuncEnter.h"

/*
	Static.cpp
	Static control custom UI
	This is simply so they text is retained even if the window is unavailable
*/

#include "Static.h"

StaticCtl::StaticCtl(HINSTANCE hInstance) :
	UIControl(hInstance, CLASS)
{ FUNC_ENTER("StaticCtl::StaticCtl"); 
	
}

StaticCtl::StaticCtl(HINSTANCE hInstance, HWND hwnd) :
	UIControl(hInstance, CLASS)
{ FUNC_ENTER("StaticCtl::StaticCtl"); 
	Attach(hwnd);
}

StaticCtl::~StaticCtl()
{ FUNC_ENTER("StaticCtl::~StaticCtl"); 
	if (hwndStatic)
		DestroyWindow(hwndStatic);
}

LRESULT StaticCtl::WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{ FUNC_ENTER("StaticCtl::WndProc"); 
	switch(msg)
	{
	case WM_CREATE:

		return TRUE;
	};

	return DefWindowProc(hwnd,msg,wParam,lParam);
}

void StaticCtl::BuildControlUI()
{ FUNC_ENTER("StaticCtl::BuildControlUI"); 
	RECT wndRect;
	GetClientRect(hwnd,&wndRect);

	int width  = wndRect.right - wndRect.left;
	int height = wndRect.bottom - wndRect.top;

	hwndStatic = CreateWindow("static",
		                      (char*)val,
							  WS_CHILD|WS_VISIBLE,
							  0,
							  0,
							  width,
							  height,
							  hwnd,
							  (HMENU)0,
							  hInstance,
							  NULL);
}

CStr StaticCtl::GetValue()
{ FUNC_ENTER("StaticCtl::GetValue"); 
	return val;
}

void StaticCtl::SetValue(CStr value)
{ FUNC_ENTER("StaticCtl::SetValue"); 
	val = value;
	SetWindowText(hwndStatic,val);
}
