#include "FuncEnter.h"

/*
	ProgressBar.cpp
	A window that displays a progress bar

	Adam Lippmann
	12-13-01
*/

#include "ProgressBar.h"
#include <assert.h>

ProgressBar::ProgressBar(HINSTANCE hInstance,HWND hwndOwner,char* Caption,int min,int max,int val)
{ FUNC_ENTER("ProgressBar::ProgressBar"); 
	this->hInstance=hInstance;
	this->min=min;
	this->max=max;
	this->val=val;

	bCancel=false;
	fpCancel = NULL;

	hwnd=CreateDialog(hInstance,MAKEINTRESOURCE(IDD_PROGRESS),hwndOwner,RedirectDlgProc);
	SetWindowLong(hwnd,GWL_USERDATA,(LONG)this);
	ShowWindow(hwnd,SW_SHOW);
	SetWindowPos(hwnd,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);

	hwndBar=GetDlgItem(hwnd,IDC_PROGRESS1);
	hwndText=GetDlgItem(hwnd,IDC_PROGTEXT);

	SetDlgItemText(hwnd,IDC_PROGTEXT,Caption);
	SendMessage(hwndBar,PBM_SETRANGE,0,MAKELPARAM(0,100));
	SendMessage(hwndBar,PBM_SETPOS,val,0);

	/* Thread ran slower than forced update
	hThread = CreateThread(NULL,
		                   0,
						   ThreadProc,
						   this,
						   0,
						   &dwThreadID);

	assert(hThread);
	*/
}

ProgressBar::~ProgressBar()
{ FUNC_ENTER("ProgressBar::~ProgressBar"); 
	// Kill off the thread
	// Lock until the thread successfully dies
	//while( !CloseHandle(hThread) ) {}

	DestroyWindow(hwnd);
}

DWORD __stdcall ProgressBar::ThreadProc(LPVOID lpParameter)
{ FUNC_ENTER("ProgressBar::ThreadProc"); 
	for(;;)
	{
		ProgressBar* pthis = (ProgressBar*)lpParameter;

		MSG msg;
		//InvalidateRect(GetDlgItem(hwnd, IDC_CANCELBUTTON), NULL, TRUE);

		if (PeekMessage(&msg,pthis->hwnd,0,0,PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
}

void ProgressBar::SetRange(int min, int max)
{ FUNC_ENTER("ProgressBar::SetRange"); 
	this->min = min;
	this->max = max;
}

void ProgressBar::SetCaption(char* Caption)
{ FUNC_ENTER("ProgressBar::SetCaption"); 
	SetDlgItemText(hwnd,IDC_PROGTEXT,Caption);
}

void ProgressBar::SetVal(int val)
{ FUNC_ENTER("ProgressBar::SetVal"); 
	this->val=val;
	int pval=val*100/(max-min);

	if (hwndBar)
	{
		SendMessage(hwndBar,PBM_SETPOS,pval,0);
		//InvalidateRect(hwndBar,NULL,TRUE);
	}
}

BOOL CALLBACK ProgressBar::RedirectDlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{ FUNC_ENTER("ProgressBar::RedirectDlgProc"); 
	ProgressBar* thisclass=(ProgressBar*)GetWindowLong(hwnd,GWL_USERDATA);
	return thisclass->DlgProc(hwnd,msg,wParam,lParam);
}

BOOL ProgressBar::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{ FUNC_ENTER("ProgressBar::DlgProc"); 
	switch(msg)
	{
	case WM_INITDIALOG:
		return TRUE;

	case WM_CLOSE:
		ShowWindow(hwnd,SW_HIDE);
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_CANCELBUTTON:
			bCancel=true;
			if (fpCancel)
				fpCancel(pCancelData);
		}
	};

	// for future expansion

	return FALSE;
}

BOOL ProgressBar::Update()
{ FUNC_ENTER("ProgressBar::Update"); 
	MSG msg;
	//InvalidateRect(GetDlgItem(hwnd, IDC_CANCELBUTTON), NULL, TRUE);

	if (PeekMessage(&msg,hwnd,WM_LBUTTONDOWN,WM_LBUTTONUP,PM_REMOVE))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	if (PeekMessage(&msg,hwnd,WM_PAINT,WM_PAINT,PM_REMOVE))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	/*
	MSG msg;

	if (PeekMessage(&msg,hwnd,0,0,PM_REMOVE))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	*/

	return FALSE;
}

void ProgressBar::SetCancelCB(void(*Func)(void*),void* pData)
{ FUNC_ENTER("ProgressBar::SetCancelCB"); 
	fpCancel=Func;
	pCancelData=pData;
	ShowWindow(GetDlgItem(hwnd,IDC_CANCELBUTTON),SW_SHOW);
}

void ProgressBar::AllowCancel(BOOL bVal)
{ FUNC_ENTER("ProgressBar::AllowCancel"); 
	if (bVal)
		ShowWindow(GetDlgItem(hwnd,IDC_CANCELBUTTON),SW_SHOW);
	else
		ShowWindow(GetDlgItem(hwnd,IDC_CANCELBUTTON),SW_HIDE);
}

bool ProgressBar::WasCanceled()
{ FUNC_ENTER("ProgressBar::WasCanceled"); 
	//ShowWindow(GetDlgItem(hwnd,IDC_CANCELBUTTON),SW_SHOW);
	//InvalidateRect(GetDlgItem(hwnd, IDC_CANCELBUTTON), NULL, TRUE);
	Update();

	return bCancel;
}
