#include "FuncEnter.h"

/*
	TriggerUI.cpp
	This file contains the UI and assignment system
	for Trigger Objects
	2-13-01
*/

#include "Trigger.h"
#include "Next.h"
#include "TriggerUI.h"
#include "../AppData.h"
#include "../PropEdit/PropEdit.h"
#include "../PropEdit/ConfigData.h"
#include "Resource.h"
#include "../PropEdit/ParseFuncs.h"
#include "../Link/LinkUI.h"
#include "../Link/LinkMan.h"
#include "../AppData.h"

#define DEFAULT_TRIGGER_CLASS "RailNode"
extern  PropEditor* pPropEdit;
extern  char gTrgDefType[255];
extern  char gTrgDefClass[255];

#define NONPLACEABLE_METACMD  "[NonPlaceable]"

HWND gLastUIhwnd=NULL;
CStr gPropBuf;

TriggerUI::TriggerUI(Interface* ip)
{ FUNC_ENTER("TriggerUI::TriggerUI"); 
	this->ip=ip;
	propList=NULL;
	contNode=NULL;
	hwndUI=NULL;
	IColor=NULL;
	IEdit =NULL;

	bLockChangeCB = false;

	if (ip->GetSelNodeCount()>0)
		lastNode = ip->GetSelNode(0);
	else
		lastNode = NULL;

	// If a new trigger object is created it should contain
	// the defaults of the last created trigger automatically
	AppDataChunk* appdata;
	ReferenceTarget* scene=ip->GetScenePointer();
	appdata=scene->GetAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_TRIGGERSETTINGS_ID);

	if (appdata)
	{
		TriggerUIData* pUIData=(TriggerUIData*)appdata->data;

		bLinkLast    = pUIData->bLinkLast;
		//bAssignProps = pUIData->bAssignProps;
		bAssignProps = TRUE;						// Forcing assign props true (will probably remove completely later)
		bShowNames   = pUIData->bShowNames;
	}
	else
	{
		bLinkLast    = false;
		//bAssignProps = false;
		bAssignProps = true;
		bShowNames   = false;
	}

	// Acquire the last property buffer
	//appdata=scene->GetAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_TRIGGERPROP_ID);
	//
	//if (appdata)
	//	propBuf=(char*)appdata->data;

	// Acquire the default property buffer from scripts.ini for the default object
	// defined in TriggerUI.ini
	strcpy(bufDefClass, gTrgDefClass);
	strcpy(bufDefType, gTrgDefType);

	//propBuf  = CStr("Class = ") + CStr(bufDefClass) + CStr("\r\n");
	//propBuf += CStr("Type = ") + CStr(bufDefType) + CStr("\r\n");
	//propBuf += pPropEdit->GetClassTypeRecord(bufDefClass, bufDefType);
	propBuf += pPropEdit->GetUniqueClassTypeRecord(bufDefClass, bufDefType);

	SetRenderVPCheck();
}

TriggerUI::~TriggerUI()
{ FUNC_ENTER("TriggerUI::~TriggerUI"); 
	if (IColor)
		ReleaseIColorSwatch(IColor);

	if (IEdit)
		ReleaseICustEdit(IEdit);
}

BOOL TriggerUI::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{ FUNC_ENTER("TriggerUI::DlgProc"); 
	TriggerUI* pthis=(TriggerUI*)GetWindowLong(hwnd,GWL_USERDATA);

	if (!pthis)
		return TRUE;

	switch(msg)
	{
	case CC_COLOR_CHANGE:
		pthis->UpdateExtData();
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_EDITNAME:
			switch(HIWORD(wParam))
			{
			case EN_CHANGE:
				pthis->UpdateExtData();
				return TRUE;
			}

			return FALSE;

		case IDC_CLASSLIST:
			switch(HIWORD(wParam))
			{
			case LBN_SELCHANGE:
				pthis->UpdateClassSel();
				return TRUE;
			}

			return FALSE;

		case IDC_TYPELIST:
			switch(HIWORD(wParam))
			{
			case LBN_SELCHANGE:
				pthis->UpdateTypeSel();
				return TRUE;
			}

//		case IDC_CREATEDATSTART:
//		case IDC_ABSENTINNETGAMES:
//			pthis->UpdateChunk();
//			return TRUE;

		case IDC_CLUSTER:
			switch(HIWORD(wParam))
			{
			case EN_CHANGE:
				pthis->UpdateChunk();
				return TRUE;
			}

			return FALSE;

		case IDC_LINKLAST:
			if (IsDlgButtonChecked(hwnd,IDC_LINKLAST)==BST_CHECKED)
				pthis->bLinkLast=true;
			else
				pthis->bLinkLast=false;

			pthis->UpdateChunk();
			return TRUE;

		case IDC_SHOWNAMES:
			if (IsDlgButtonChecked(hwnd,IDC_SHOWNAMES)==BST_CHECKED)
				pthis->bShowNames=true;
			else
				pthis->bShowNames=false;

			pthis->UpdateChunk();
			pthis->ip->ForceCompleteRedraw();
			return TRUE;

		case IDC_OUTPUTPROPS:
			/*
			if (IsDlgButtonChecked(hwnd,IDC_OUTPUTPROPS)==BST_CHECKED)
				pthis->bAssignProps=true;
			else
				pthis->bAssignProps=false;
			*/
			pthis->bAssignProps = true;

			pthis->UpdateChunk();
			return TRUE;

		case IDC_RENDERVPDATA:
			pthis->RenderVPData();
			gInterface->ForceCompleteRedraw();
			return TRUE;
		}
	};

	return FALSE;
}

void TriggerUI::UpdateClassSel(bool bUpdateChunk)
{ FUNC_ENTER("TriggerUI::UpdateClassSel"); 
	char buf[256];

	int index=SendDlgItemMessage(hwndUI,IDC_CLASSLIST,CB_GETCURSEL,0,0);
	SendDlgItemMessage(hwndUI,IDC_CLASSLIST,CB_GETLBTEXT,(WPARAM)index,(LPARAM)buf);

	ConfigClass* cclass=pPropEdit->GetConfigClass(buf);

	if (cclass)
	{
		Link<ConfigType>* curNode=cclass->types.GetHead();

		SendDlgItemMessage(hwndUI,IDC_TYPELIST,CB_RESETCONTENT,0,0);

		while(curNode)
		{
			// Don't add the types that have NonPlaceable in their directives
			if (!strstr(curNode->data.strCmds, NONPLACEABLE_METACMD))
				SendDlgItemMessage(hwndUI,IDC_TYPELIST,CB_ADDSTRING,(WPARAM)0,(LPARAM)(char*)curNode->data.name);

			curNode=curNode->next;
		}
	}

	// Select the first item in the type list
	SendDlgItemMessage(hwndUI,IDC_TYPELIST,CB_SETCURSEL,(WPARAM)0,0);
	UpdateTypeSel(bUpdateChunk);
}

void TriggerUI::UpdateTypeSel(bool bUpdateChunk)
{ FUNC_ENTER("TriggerUI::UpdateTypeSel"); 
	if (propList)
	{
		char bufClass[256], bufType[256];
		int  index;

		index=SendDlgItemMessage(hwndUI,IDC_CLASSLIST,CB_GETCURSEL,0,0);
		SendDlgItemMessage(hwndUI,IDC_CLASSLIST,CB_GETLBTEXT,(WPARAM)index,(LPARAM)bufClass);

		index=SendDlgItemMessage(hwndUI,IDC_TYPELIST,CB_GETCURSEL,0,0);
		SendDlgItemMessage(hwndUI,IDC_TYPELIST,CB_GETLBTEXT,(WPARAM)index,(LPARAM)bufType);

		if (bUpdateChunk)
		{
			propList->Clear();

			CStr strType;
			CStr strClassRec;

			// Unique doesn't account for // @ defs in orig (change back): 5-20-03
			strClassRec = pPropEdit->GetClassTypeRecord(bufClass,bufType);
			//strClassRec = pPropEdit->GetUniqueClassTypeRecord(bufClass, bufType);
			
			// Acquire the properties and add them to the property list
			ParseConfigProps(&props,&flags,strClassRec,&strCmds,&strCluster,&programs);

			/*
			if (flags & CCLASS_CREATEDATSTART)
				CheckDlgButton(hwndUI,IDC_CREATEDATSTART,BST_CHECKED);
			else
				CheckDlgButton(hwndUI,IDC_CREATEDATSTART,BST_UNCHECKED);

			if (flags & CCLASS_ABSENTINNETGAMES)
				CheckDlgButton(hwndUI,IDC_ABSENTINNETGAMES,BST_CHECKED);
			else
				CheckDlgButton(hwndUI,IDC_ABSENTINNETGAMES,BST_UNCHECKED);

			if (flags & CCLASS_TRICKOBJECT)
				SetDlgItemText(hwndUI,IDC_CLUSTER,(char*)strCluster);
			*/

			BuildPropList(propList,&props);
			propList->BuildUI();

			COLORREF color = ParseColor(strClassRec);
			if (color != 0)
			{
				IColor->SetColor(color);
				UpdateExtData();
			}
			
			UpdateChunk();
		}
	}
}

void TriggerUI::ChangeCB(PropList* plist,void* pData)
{ FUNC_ENTER("TriggerUI::ChangeCB"); 
	TriggerUI* pthis=(TriggerUI*)pData;

	if (pthis->bLockChangeCB)
		return;
	
	pthis->UpdateChunk();
}

void TriggerUI::BeginEditParams(IObjParam *ip, ULONG flags, Animatable *prev)
{ FUNC_ENTER("TriggerUI::BeginEditParams"); 
	if (ip->GetCommandPanelTaskMode()==TASK_MODE_CREATE)
	{
		TriggerLayout::BeginEditParams(ip,flags,prev);

		propList=new MultiPropList(hInstance,1);
		propList->HasApply(false);

		hwndUI=ip->AddRollupPage(hInstance,MAKEINTRESOURCE(IDD_TRIGGERUI),DlgProc,"Trigger Create Parameters");

		gLastUIhwnd=hwndUI;
		SetWindowLong(hwndUI,GWL_USERDATA,(LONG)this);

		IColor=GetIColorSwatch(GetDlgItem(hwndUI,IDC_COLOR),RGB(0,255,0),_T("Trigger Creation color"));
		IEdit=GetICustEdit(GetDlgItem(hwndUI,IDC_EDITNAME));

		propList->UIControl::Attach(GetDlgItem(hwndUI,IDC_PROPS));
		propList->SetChangeCB(ChangeCB,this);

		// Set settings
		if (bLinkLast)
			CheckDlgButton(hwndUI,IDC_LINKLAST,BST_CHECKED);
		else
			CheckDlgButton(hwndUI,IDC_LINKLAST,BST_UNCHECKED);
		
		if (bShowNames)
			CheckDlgButton(hwndUI,IDC_SHOWNAMES,BST_CHECKED);
		else
			CheckDlgButton(hwndUI,IDC_SHOWNAMES,BST_UNCHECKED);

		/*
		if (bAssignProps)
			CheckDlgButton(hwndUI,IDC_OUTPUTPROPS,BST_CHECKED);
		else
			CheckDlgButton(hwndUI,IDC_OUTPUTPROPS,BST_UNCHECKED);
		*/

		// Read the TriggerObject types out of scripts.ini (already loaded from PE)
		//if (ParseScriptIni())
		{
			SendDlgItemMessage(hwndUI,IDC_CLASSLIST,CB_RESETCONTENT,0,0);

			Link<ConfigClass>* curNode = pPropEdit->GetConfigDBHead();

			while(curNode)
			{
				// Don't add the Default class or the classes that are [NonPlaceable]
				if (!strstr(curNode->data.strCmds, NONPLACEABLE_METACMD) &&
					curNode->data.name != CStr("Default"))
					SendDlgItemMessage(hwndUI,IDC_CLASSLIST,CB_ADDSTRING,0,(LPARAM)(char*)curNode->data.name);

				curNode=curNode->next;
			}
		}

		SendDlgItemMessage(hwndUI, IDC_CLASSLIST, CB_SELECTSTRING, (WPARAM)-1, (LPARAM)bufDefClass);
		SendDlgItemMessage(hwndUI, IDC_TYPELIST, CB_SELECTSTRING, (WPARAM)-1, (LPARAM)bufDefType);

		// Set the class selection default
		if (gPropBuf.Length()>0)
		{
			// Set defaults
			//AddGlobalDefaults(propBuf);
			
			///////////////
			ParseConfigProps(&props,&flags,gPropBuf,&strCmds,&strCluster);
			//pPropEdit->AddGlobalDefaults(gPropBuf,&props,&flags,&strCmds);
			pPropEdit->GetDynUIProps(&props,GetClassName(gPropBuf),GetTypeName(gPropBuf));
			pPropEdit->RemoveOmissions(GetClassName(gPropBuf), GetTypeName(gPropBuf), &props);
			//AttachExtendedData(&props, propBuf);

			//pPropEdit->AddGlobalDefaults(propBuf,&props,&flags,&strCmds);
			//strClassRec = pPropEdit->GetClassTypeRecord(bufClass,bufType);
			
			// Acquire the properties and add them to the property list
			//ParseConfigProps(&props,&flags,strClassRec,&strCmds,&strCluster,&programs);

			//UpdateClassSel();
			///////////////

			/*
			if (flags & CCLASS_CREATEDATSTART)
				CheckDlgButton(hwndUI,IDC_CREATEDATSTART,BST_CHECKED);
			else
				CheckDlgButton(hwndUI,IDC_CREATEDATSTART,BST_UNCHECKED);

			if (flags & CCLASS_ABSENTINNETGAMES)
				CheckDlgButton(hwndUI,IDC_ABSENTINNETGAMES,BST_CHECKED);
			else
				CheckDlgButton(hwndUI,IDC_ABSENTINNETGAMES,BST_UNCHECKED);

			if (flags & CCLASS_TRICKOBJECT)
				SetDlgItemText(hwndUI,IDC_CLUSTER,(char*)strCluster);
			*/

			CStr strClass,strType;
			strClass = GetClassName(gPropBuf);
			strType  = GetTypeName(gPropBuf);

			propList->Clear();
		
			// Convert defaults
			pPropEdit->ConvertToDefaults(strClass,strType,&props);

			// Select the appropriate class
			int index=SendDlgItemMessage(hwndUI,IDC_CLASSLIST,CB_FINDSTRING,(WPARAM)-1,(LPARAM)(char*)strClass);
			SendDlgItemMessage(hwndUI,IDC_CLASSLIST,CB_SETCURSEL,(WPARAM)index,0);

			UpdateClassSel(false);

			// Select the appropriate type
			index=SendDlgItemMessage(hwndUI,IDC_TYPELIST,CB_FINDSTRING,(WPARAM)-1,(LPARAM)(char*)strType);
			SendDlgItemMessage(hwndUI,IDC_TYPELIST,CB_SETCURSEL,(WPARAM)index,0);

			propList->Clear();
			BuildPropList(propList,&props);
			bLockChangeCB = true;
			propList->BuildUI();
			bLockChangeCB = false;
		}
		else
		{
			int index=SendDlgItemMessage(hwndUI,IDC_CLASSLIST,CB_FINDSTRING,(WPARAM)-1,(LPARAM)DEFAULT_TRIGGER_CLASS);
		
			if (index!=CB_ERR)
				SendDlgItemMessage(hwndUI,IDC_CLASSLIST,CB_SETCURSEL,(WPARAM)index,0);

			UpdateClassSel();
		}

		GetExtData();
	}
}

void TriggerUI::EndEditParams(IObjParam *ip, ULONG flags, Animatable *next)
{ FUNC_ENTER("TriggerUI::EndEditParams"); 
	CStr strClass = GetClass();
	CStr strType  = GetType();
	
	TriggerLayout::EndEditParams(ip,flags,next);

	if (propList)
	{
		delete propList;
		propList=NULL;

		// Using config data from the PE now (can't clear)
		//configDB.Clear();

		if (IColor)
		{
			ReleaseIColorSwatch(IColor);
			IColor=NULL;
		}

		if (IEdit)
		{
			ReleaseICustEdit(IEdit);
			IEdit=NULL;
		}

		ip->DeleteRollupPage(hwndUI);
		hwndUI=NULL;
	}

	// Only write out class/type defaults to the .ini file if there are not
	// empty strings
	if(	( strClass.Length() > 0 ) ||
		( strType.Length() > 0 ))
	{
		CStr appDir=ip->GetDir(APP_PLUGCFG_DIR);
		appDir+="\\TriggerUI.ini";

		memset(bufDefClass, 0, 256);
		memset(bufDefType, 0, 256);

		assert(strClass.Length() < 256);
		assert(strType.Length() < 256);

		strcpy(bufDefClass, strClass);
		strcpy(bufDefType, strType);

		WritePrivateProfileString("Properties", "Class", (char*)bufDefClass, (char*)appDir);
		WritePrivateProfileString("Properties", "Type", (char*)bufDefType, (char*)appDir);
	}
}

void TriggerUI::TriggerCreated(RefMakerHandle rm)
{ FUNC_ENTER("TriggerUI::TriggerCreated"); 
	if (ip->GetSelNodeCount()>0)
		lastNode = ip->GetSelNode(0);
	else
		lastNode = NULL;
	
	if (rm->ClassID()==Class_ID(BASENODE_CLASS_ID,0))
	{
		INode* node=(INode*)rm;

		Object* obj=node->EvalWorldState(0).obj;
		
		if (obj && obj->ClassID()==vTRIGGER_CLASS_ID)
			contNode=node;
	}
}

void CenterPivot(INode* node)
{ FUNC_ENTER("CenterPivot"); 
	// Pivots should no longer be centered  4-2-01  aml
	/*
	TimeValue t = gInterface->GetTime();
	Point3 amt;
	Point3 ot = node->GetObjectTM(t).GetTrans();
	Point3 nt = node->GetNodeTM(t).GetTrans();

	amt = ot-nt;
	//node->Move( t, node->GetNodeTM(t), -19.0f/2.0f * Point3(0.0f, 0.5f, -0.5f), TRUE, FALSE, PIV_PIVOT_ONLY);
	node->Move( t, node->GetNodeTM(t), -19.0f/2.0f * Point3(0.0f, 0.75f, -0.5f), TRUE, FALSE, PIV_PIVOT_ONLY);
	*/
}

void TriggerUI::TriggerLink(BOOL endOfChain, BOOL cyclicLink)
{ FUNC_ENTER("TriggerUI::TriggerLink"); 
	// Retrieve chunk from the scene indicating the last trigger created
	// and then update it to indicate this newly created trigger
	if (!contNode)
		return;
	
	//INode* lastNode=NULL;

	CenterPivot(contNode);

	AppDataChunk* appdata;

	ReferenceTarget* scene=ip->GetScenePointer();
	appdata=scene->GetAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_LASTTRIGGER_ID);

	if (hwndUI)
	{
		// Name the node
		char buf[256];
		CStr strName;
		
		if (IEdit)
			IEdit->GetText(buf,255);
		
		strName=buf;
		ip->MakeNameUnique(strName);
		contNode->SetName(strName);

		// Set the node color
		if (IColor)
			contNode->SetWireColor(IColor->GetColor());
	}

	if (appdata)
	{
		ULONG nodeID=*((ULONG*)appdata->data);

		if (bLinkLast && !endOfChain)
		{
			// Do the link
			ILinkMan* linkman=GetLinkMan();

			// Ensure that parent and child chain selection is turned off
			bool bSelectChildren, bSelectParents;

			bSelectChildren = linkman->GetSelectChildren();
			bSelectParents  = linkman->GetSelectParents();

			linkman->SetSelectChildren( false );
			linkman->SetSelectParents( false );

			/*
			lastNode=ip->GetINodeByHandle(nodeID);

			ip->SelectNode(lastNode);
			*/

			// Changing the selected node at this state seems to do strange things to MAX
			// and results in Trigger snap not getting called for one of the 2 nodes (TT443)
			//ip->SelectNode(lastNode);
			//ip->SelectNode(contNode, 0);
			//linkman->ChainLink(false);
			linkman->ChainNodes(lastNode, contNode);

			if (cyclicLink)
			{
				INode* startNode = FindStartLink(contNode);
				ip->SelectNode(contNode);
				ip->SelectNode(startNode, 0);
				linkman->ChainLink(false);
				ip->ClearNodeSelection();
			}

			// Restore the chain auto selection to what it was before the SRLT link
			linkman->SetSelectChildren( bSelectChildren );
			linkman->SetSelectParents( bSelectParents );
		}

		scene->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_LASTTRIGGER_ID);
	}

	// Apply the stored property buffer
	appdata=scene->GetAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_TRIGGERPROP_ID);

	if (appdata && bAssignProps)
		contNode->SetUserPropBuffer(CStr((char*)appdata->data));

	// Force PE refresh so it can update to the new prop buffer settings
	//pPropEdit->UnLockSelChange();
	pPropEdit->EnableAutoPropAssign();
	pPropEdit->Update();

	// Add the newly created node as the last trigger now
	ULONG* pNodeID=(ULONG*)malloc(sizeof(ULONG));
	*pNodeID=contNode->GetHandle();

	/*
	if (endOfChain)
	{
		// Uncheck the link last trigger option
		if (gLastUIhwnd)
			CheckDlgButton(gLastUIhwnd,IDC_LINKLAST,BST_UNCHECKED);

		bLinkLast=false;
		UpdateTriggerSettings();
	}
	*/

	scene->AddAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_LASTTRIGGER_ID,sizeof(ULONG),pNodeID);
}

void TriggerUI::UpdateTriggerSettings()
{ FUNC_ENTER("TriggerUI::UpdateTriggerSettings"); 
	ReferenceTarget* scene=ip->GetScenePointer();

	TriggerUIData* pUIData=(TriggerUIData*)malloc(sizeof(TriggerUIData));
		
	pUIData->bLinkLast    = bLinkLast;
	pUIData->bShowNames   = bShowNames;
	//pUIData->bAssignProps = bAssignProps;
	pUIData->bAssignProps = true;
		
	scene->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_TRIGGERSETTINGS_ID);
	scene->AddAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_TRIGGERSETTINGS_ID,sizeof(TriggerUIData),pUIData);
}

void TriggerUI::UpdateChunk()
{ FUNC_ENTER("TriggerUI::UpdateChunk"); 
	ReferenceTarget* scene=ip->GetScenePointer();

	UpdateTriggerSettings();

	strClass=GetClass();
	strType=GetType();

	// Acquire flags
	flags=0;

	/*
	if (IsDlgButtonChecked(hwndUI,IDC_CREATEDATSTART)==BST_CHECKED)
		flags|=CCLASS_CREATEDATSTART;

	if (IsDlgButtonChecked(hwndUI,IDC_ABSENTINNETGAMES)==BST_CHECKED)
		flags|=CCLASS_ABSENTINNETGAMES;

	char strCluster[256];
	GetDlgItemText(hwndUI,IDC_CLUSTER,strCluster,255);

	if (strlen(strCluster)>0)
		flags|=CCLASS_TRICKOBJECT;
	*/
	
	// Acquire settings from property list
	int count=propList->NumProps();

	for(int i=0;i<count;i++)
	{
		CStr strValue;
		propList->GetValue(i,strValue);
		props[i].value=strValue;
	}

	propBuf=pPropEdit->BuildPropBuffer(NULL,
								    strClass,
									strType,
									flags,
									&props,
									strCmds,
									"",				// No scripts
									strCluster,
									&programs);

	gPropBuf = propBuf;

	char* PropBuf=(char*)malloc(propBuf.Length()+1);
	strcpy(PropBuf,(char*)propBuf);

	scene->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_TRIGGERPROP_ID);
	scene->AddAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_TRIGGERPROP_ID,propBuf.Length()+1,PropBuf);
}

CStr TriggerUI::GetClass()
{ FUNC_ENTER("TriggerUI::GetClass"); 
	char buf[256];
	
	buf[0] = '\0';
	int index=SendDlgItemMessage(hwndUI,IDC_CLASSLIST,CB_GETCURSEL,0,0);
	SendDlgItemMessage(hwndUI,IDC_CLASSLIST,CB_GETLBTEXT,(WPARAM)index,(LPARAM)buf);	

	return CStr(buf);
}

CStr TriggerUI::GetType()
{ FUNC_ENTER("TriggerUI::GetType"); 
	char buf[256];

	buf[0] = '\0';
	int index=SendDlgItemMessage(hwndUI,IDC_TYPELIST,CB_GETCURSEL,0,0);
	SendDlgItemMessage(hwndUI,IDC_TYPELIST,CB_GETLBTEXT,(WPARAM)index,(LPARAM)buf);

	return CStr(buf);
}

void TriggerUI::UpdateExtData()
{ FUNC_ENTER("TriggerUI::UpdateExtData"); 
	if (hwndUI)
	{
		ExtTriggerData* pextdata=(ExtTriggerData*)malloc(sizeof(ExtTriggerData));
		
		if (IEdit)
			IEdit->GetText(pextdata->name,255);
		else
			pextdata->name[0]='\0';
		
		if (IColor)
			pextdata->color=IColor->GetColor();
		else
			pextdata->color=RGB(0,255,0);

		ReferenceTarget* scene=ip->GetScenePointer();

		scene->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_EXTTRIGGERSETTINGS_ID);
		scene->AddAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_EXTTRIGGERSETTINGS_ID,sizeof(ExtTriggerData),pextdata);
	}
}

void TriggerUI::GetExtData()
{ FUNC_ENTER("TriggerUI::GetExtData"); 
	ReferenceTarget* scene=ip->GetScenePointer();

	AppDataChunk* appdata;
	appdata=scene->GetAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_EXTTRIGGERSETTINGS_ID);

	if (appdata)
	{
		ExtTriggerData* pExtData=(ExtTriggerData*)appdata->data;
		
		// Set name
		if (strlen(pExtData->name)==0)
			strcpy(pExtData->name,"TRG_");

		if (IEdit)
			IEdit->SetText(pExtData->name);

		// Set color
		if (IColor)
			IColor->SetColor(pExtData->color);
	}
	else
	{
		IEdit->SetText("TRG_");
	}
}

void TriggerUI::DestroyRetainedData()
{ FUNC_ENTER("TriggerUI::DestroyRetainedData"); 
	ReferenceTarget* scene = gInterface->GetScenePointer();
	
	scene->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_TRIGGERPROP_ID);
	//scene->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_LASTTRIGGER_ID);
	//scene->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_TRIGGERSETTINGS_ID);
}

COLORREF TriggerUI::ParseColor(char* line)
{ FUNC_ENTER("TriggerUI::ParseColor"); 
	COLORREF color;
	char* cpos = strstr(line, "// @nodecolor |");
	char  bufColor[256];

	if (!cpos)
		return 0;
	
	cpos += 15;
	cpos = strstr(cpos, "[");
	cpos++;

	GetOption(cpos, bufColor, ',', 0);
	color = (COLORREF)((unsigned char)atoi(bufColor));
	GetOption(cpos, bufColor, ',', 1);
	color |= (COLORREF)((unsigned char)atoi(bufColor)) << 8;
	GetOption(cpos, bufColor, ',', 2);
	color |= (COLORREF)((unsigned char)atoi(bufColor)) << 16;

	return color;
}

void TriggerUI::SetRenderVPCheck()
{ FUNC_ENTER("TriggerUI::SetRenderVPCheck"); 
	if (ShouldRenderVPData())
		CheckDlgButton(hwndUI, IDC_RENDERVPDATA, BST_CHECKED);
	else
		CheckDlgButton(hwndUI, IDC_RENDERVPDATA, BST_UNCHECKED);
}

bool TriggerUI::ShouldRenderVPData()
{ FUNC_ENTER("TriggerUI::ShouldRenderVPData"); 
	INode* root = gInterface->GetRootNode();

	AppDataChunk* appdata = root->GetAppDataChunk(vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_RENDERVPDATA);

	if (appdata && appdata->data)
	{
		bool* bShouldRenderVPData = (bool*)appdata->data;

		return *bShouldRenderVPData;
	}

	return true;
}

void TriggerUI::RenderVPData()
{ FUNC_ENTER("TriggerUI::RenderVPData"); 
	bool* bNewState = (bool*)malloc(sizeof(bool));
	*bNewState = !ShouldRenderVPData();

	INode* root = gInterface->GetRootNode();

	root->RemoveAppDataChunk(vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_RENDERVPDATA);
	root->AddAppDataChunk(vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_RENDERVPDATA, sizeof(bool), bNewState);

	SetRenderVPCheck();
}

