/**********************************************************************
 *<
	FILE: BMTEX.CPP

	DESCRIPTION: BMTEX 2D Texture map.

	CREATED BY: Dan Silva

	HISTORY:

 *>	Copyright (c) 1994, All Rights Reserved.
 **********************************************************************/

//#include "mtlhdr.h"
//#include "mtlres.h"
#include "BMTex.h"

#define NO_PREINCLUDES
#define NO_BASEPREINCLUDES
#include "FuncEnter.h"

extern HINSTANCE hInstance;

// ParamBlock entries
/*
#define PB_CLIPU	0
#define PB_CLIPV	1
#define PB_CLIPW	2
#define PB_CLIPH	3
#define PB_JITTER   4
#define NPARAMS 5
*/
// Image filtering types
#define FILTER_PYR     0
#define FILTER_SAT     1
#define FILTER_NADA	   2

// Alpha source types
#define ALPHA_FILE 	0
#define ALPHA_RGB	2
#define ALPHA_NONE	3

// End conditions:
#define END_LOOP     0
#define END_PINGPONG 1
#define END_HOLD     2

#define NCOLS 0

#define UVGEN_REF 0
#define PBLOCK_REF 1 
#define TEXOUT_REF 2

static AColor black(0.0f,0.0f,0.0f,0.0f);

char filtering_modes[2][32] = {
	{ "Nearest Pixel" },
	{ "Linear Blend" }	
};

#if 0
static void LoadFailedMsg(const TCHAR* name) {
	if (name==NULL) return;
	TCHAR msg[128];
	wsprintf(msg,GetString(IDS_DS_FILE_NOT_FOUND), name);
	MessageBox(NULL, msg, GetString(IDS_DS_BITMAP_TEXTURE_ERR), MB_TASKMODAL);
	}
#endif

static bool valid_bitmap( PBBitmap* bm );

static void InvalidNameMsg(const TCHAR* name) { FUNC_ENTER("InvalidNameMsg"); 
	if (name==NULL) return;
	TCHAR msg[128];
	wsprintf(msg,_T("Invalid File Name: %s"), name);
	MessageBox(NULL, msg, GetString(IDS_DS_BITMAP_TEXTURE_ERR), MB_TASKMODAL);
	}

// JBW: IDs for ParamBlock2 blocks and parameters
// Parameter and ParamBlock IDs, bmtex_time
enum { bmtex_params,bmtex_time, bmcp_params };  // pblock ID

//////////////// WAS BMTex.h


ParamDlg* BMTex::uvGenDlg;	
//ParamDlg* BMTex::texoutDlg;
BMTexDlg* BMTex::paramDlg;

//------------------------------------------------------------------------
// BMSampler -- Methods
//------------------------------------------------------------------------
void BMSampler::Init(BMTex *bmt) { FUNC_ENTER("BMSampler::Init"); 
	 bm = bmt->thebm; 
	 tex = bmt; 
	 alphaSource = bmt->alphaSource; 
	 if (bm) {
		u0 = tex->clipu;
		v0 = tex->clipv;
		u1 = tex->clipu + ufac;
		v1 = tex->clipv + vfac;
		ufac= tex->clipw;
		vfac = tex->cliph;
		bmw = bm->Width();
		bmh = bm->Height();
		fbmw = float(bmw/*-1*/);  // DS 4/23/99
		fbmh = float(bmh/*-1*/);  // DS 4/23/99
		clipx = int(tex->clipu*fbmw);
		clipy = int(tex->clipv*fbmh);
		fclipw = tex->clipw*fbmw;
		fcliph = tex->cliph*fbmh;
		cliph = int(fcliph);
		ujit = tex->jitter*(1.0f-ufac);
		vjit = tex->jitter*(1.0f-vfac);
		}
	 }


static inline void Jitter(ShadeContext &sc, float ujit, float vjit, float &ru, float &rv, int iu, int iv) { FUNC_ENTER("Jitter"); 
//	srand(((sc.uTile+593)*14693+(sc.vTile+4991)*2517)&0x7fff);
	srand(((iu+593)*14693+(iv+967)*29517)&0x7fff);
	int urnd = rand()&0x7fff;
	rand();	 // these extra calls seem to make the pattern more random
	rand();	 // these extra calls seem to make the pattern more random
	int vrnd = rand()&0x7fff;
	ru = ujit*float(urnd)/float(32767.0f);
	rv = vjit*float(vrnd)/float(32767.0f);
	}

int BMSampler::PlaceUV(ShadeContext &sc, float &u, float &v, int iu, int iv) { FUNC_ENTER("BMSampler::PlaceUV"); 
	if (tex->randPlace) {
		float ru,rv;
		Jitter(sc,ujit,vjit,ru,rv,iu,iv);
		if (u<ru||v<rv||u>ru+ufac||v>rv+vfac) return 0;
		// note jitter ignores u0,v0, effectively setting them to zero
		u = (u-ru)/ufac;
		v = (v-rv)/vfac;  
		}
	else {
		if (u<u0||v<v0||u>u1||v>v1) return 0;
		u = (u-u0)/ufac;
		v = (v-v0)/vfac;
		}
	return 1;
	}

void BMSampler::PlaceUVFilter(ShadeContext &sc, float &u, float &v, int iu, int iv) { FUNC_ENTER("BMSampler::PlaceUVFilter"); 
	if (tex->randPlace) {
		float ru,rv;
		Jitter(sc,ujit,vjit,ru,rv,iu,iv);
		// note jitter ignores u0,v0, effectively setting them to zero
		u = (u-ru)/ufac;
		v = (v-rv)/vfac;
		}
	else {
		u = (u-u0)/ufac;
		v = (v-v0)/vfac;
		}
	}

AColor BMSampler::Sample(ShadeContext& sc, float u,float v) { FUNC_ENTER("BMSampler::Sample"); 
	BMM_Color_64 c;
	int x,y;
	float fu,fv;
	fu = frac(u);
	fv = 1.0f-frac(v);
	if (tex->applyCrop) {
		if (tex->placeImage) {
			if (!PlaceUV(sc,fu, fv, int(u), int(v))) return black;
			x = (int)(fu*fbmw);
			y = (int)(fv*fbmh);
			}
		else {
			x = mod(clipx + (int)(fu*fclipw),bmw);
			y = mod(clipy + (int)(fv*fcliph),bmh);
			}
		}
	else {
		x = (int)(fu*fbmw);
		y = (int)(fv*fbmh);
		}
	bm->GetLinearPixels(x,y,1,&c);
	switch(alphaSource) {
		case ALPHA_NONE:  c.a = 0xffff; break;
		case ALPHA_RGB:   c.a = (c.r+c.g+c.b)/3; break;
		//  TBD
		// XPCOL needs to be handled in bitmap for filtering. 
		// Need to open a bitmap with this property.
		//	case ALPHA_XPCOL:  break; 
		}
	return c;
	}


AColor BMSampler::SampleFilter(ShadeContext& sc, float u,float v, float du, float dv) { FUNC_ENTER("BMSampler::SampleFilter"); 
	BMM_Color_64 c;
	float fu,fv;
	fu = frac(u);
	fv = 1.0f-frac(v);
	if (tex->applyCrop) {
		if (tex->placeImage) {
			PlaceUVFilter(sc,fu, fv, int(u), int(v));
			du /= ufac;
			dv /= vfac;
			float du2 = 0.5f*du;
			float ua = fu-du2;
			float ub = fu+du2;
			if (ub<=0.0f||ua>=1.0f) return black;
			float dv2 = 0.5f*dv;
			float va = fv-dv2;
			float vb = fv+du2;
			if (vb<=0.0f||va>=1.0f) return black;
			BOOL clip = 0;
			if (ua<0.0f) { ua=0.0f; clip = 1; }
			if (ub>1.0f) { ub=1.0f;	clip = 1; }
			if (va<0.0f) { va=0.0f;	clip = 1; }
			if (vb>1.0f) { vb=1.0f;	clip = 1; }
			bm->GetFiltered(fu,fv,du,dv,&c);
			switch(alphaSource) {
				case ALPHA_NONE:  c.a = 0xffff; break;
				case ALPHA_RGB:   c.a = (c.r+c.g+c.b)/3; break;
				}
			AColor ac(c);
			if (clip) {
				float f = ((ub-ua)/du) * ((vb-va)/dv);
				ac *= f;
				}
			return ac;
			}
		else {
			fu = (u0 + ufac*fu);
			fv = (v0 + vfac*fv);
			du *= ufac;
			dv *= vfac;
			bm->GetFiltered(fu,fv,du,dv,&c);
			}
		}

	else 
		bm->GetFiltered(fu,fv,du,dv,&c);
	switch(alphaSource) {
		case ALPHA_NONE:  c.a = 0xffff; break;
		case ALPHA_RGB:   c.a = (c.r+c.g+c.b)/3; break;
		}
	return c;
	}


//------------------------------------------------------------------------
// BMAlphaSampler -- Methods
//------------------------------------------------------------------------
void BMAlphaSampler::Init(BMTex *bmt) { FUNC_ENTER("BMAlphaSampler::Init");  
	bm = bmt->thebm; 
	tex = bmt; 
	if (bm) {
		u0 = tex->clipu;
		v0 = tex->clipv;
		ufac= tex->clipw;
		vfac = tex->cliph;
		bmw = bm->Width();
		bmh = bm->Height();
		fbmw = float(bmw-1);
		fbmh = float(bmh-1);
		clipx = int(tex->clipu*fbmw);
		clipy = int(tex->clipv*fbmh);
		fclipw = tex->clipw*fbmw;
		fcliph = tex->cliph*fbmh;
		cliph = int(fcliph);
		ujit = tex->jitter*(1.0f-ufac);
		vjit = tex->jitter*(1.0f-vfac);
		}
	}

int BMAlphaSampler::PlaceUV(ShadeContext &sc, float &u, float &v, int iu, int iv) { FUNC_ENTER("BMAlphaSampler::PlaceUV"); 
	if (tex->randPlace) {
		float ru,rv;
		Jitter(sc,ujit,vjit,ru,rv,iu,iv);
		if (u<ru||v<rv||u>ru+ufac||v>rv+vfac) return 0;
		u = (u-ru)/ufac;
		v = (v-rv)/vfac;
		}
	else {
		if (u<u0||v<v0||u>u1||v>v1) return 0;
		u = (u-u0)/ufac;
		v = (v-v0)/vfac;
		}

	return 1;
	}

void BMAlphaSampler::PlaceUVFilter(ShadeContext &sc, float &u, float &v, int iu, int iv) { FUNC_ENTER("BMAlphaSampler::PlaceUVFilter"); 
	if (tex->randPlace) {
		float ru,rv;
		Jitter(sc,ujit,vjit,ru,rv,iu,iv);
		u = (u-ru)/ufac;
		v = (v-rv)/vfac;
		}
	else {
		u = (u-u0)/ufac;
		v = (v-v0)/vfac;
		}
	}

float BMAlphaSampler::SampleMono(ShadeContext& sc, float u,float v) { FUNC_ENTER("BMAlphaSampler::SampleMono"); 
	BMM_Color_64 c;
	int x,y;
	float fu,fv;
	fu = frac(u);
	fv = 1.0f-frac(v);
	if (tex->applyCrop) {
		if (tex->placeImage) {
			if (!PlaceUV(sc,fu,fv,int(u),int(v))) return 0.0f;
			x = (int)(fu*fclipw);
			y = (int)(fv*fcliph);
			}
		else {
			x = mod(clipx + (int)(fu*fclipw),bmw);
			y = mod(clipy + cliph-1-(int)(fv*fcliph),bmh);
			}
		}
	else {
		x = (int)(fu*fbmw);
		y = (int)(fv*fbmh);
		}
	bm->GetLinearPixels(x,y,1,&c);
	return( (float)c.a/65536.0f);
	}

float BMAlphaSampler::SampleMonoFilter(ShadeContext& sc, float u,float v, float du, float dv) { FUNC_ENTER("BMAlphaSampler::SampleMonoFilter"); 
	BMM_Color_64 c;
	float fu,fv;
	fu = frac(u);
	fv = 1.0f-frac(v);
	if (tex->applyCrop) {
		if (tex->placeImage) {
			PlaceUVFilter(sc,fu, fv, int(u), int(v));
			du /= ufac;
			dv /= vfac;
			float du2 = 0.5f*du;
			float ua = fu-du2;
			float ub = fu+du2;
			if (ub<=0.0f||ua>=1.0f) return 0.0f;
			float dv2 = 0.5f*dv;
			float va = fv-dv2;
			float vb = fv+du2;
			if (vb<=0.0f||va>=1.0f) return 0.0f;
			BOOL clip = 0;
			if (ua<0.0f) { ua=0.0f; clip = 1; }
			if (ub>1.0f) { ub=1.0f;	clip = 1; }
			if (va<0.0f) { va=0.0f;	clip = 1; }
			if (vb>1.0f) { vb=1.0f;	clip = 1; }
			bm->GetFiltered(fu,fv,du,dv,&c);
			float alph = (float)c.a/65536.0f;
			if (clip) {
				float f = ((ub-ua)/du) * ((vb-va)/dv);
				alph *= f;
				}
			return alph;
			}
		else {
			fu = frac(u0 + ufac*fu);
			fv = frac(v0 + vfac*fv);
			du *= ufac;
			dv *= vfac;
			}
		}
	bm->GetFiltered(fu,fv,du,dv,&c);
	return( (float)c.a/65536.0f);
	}

//------------------------------------------------------------------------
// BMCropper  -- Methods
//------------------------------------------------------------------------

void BMCropper::Init(BMTexDlg *txdlg, TimeValue t) { FUNC_ENTER("BMCropper::Init"); 
	dlg = txdlg;
	tex = txdlg->theBMTex;
	u0 = tex->GetClipU(t);
	v0 = tex->GetClipV(t);
	w0 = tex->GetClipW(t);
	h0 = tex->GetClipH(t);
	mode= tex->placeImage;
	}

void BMCropper::SetValues(float u, float v, float w, float h, BOOL md) { FUNC_ENTER("BMCropper::SetValues"); 
	BOOL b = FALSE;
	if (u!=tex->clipu) {
		tex->SetClipU(dlg->ip->GetTime(), u);
		b = TRUE;		
		}
	if (v!=tex->clipv) {
		tex->SetClipV(dlg->ip->GetTime(), v);
		b = TRUE;		
		}
	if (w!=tex->clipw) {
		tex->SetClipW(dlg->ip->GetTime(), w);
		b = TRUE;		
		}
	if (h!=tex->cliph) {
		tex->SetClipH(dlg->ip->GetTime(), h);
		b = TRUE;		
		}

	if (md!=tex->placeImage) {
		tex->placeImage= md;
		b = TRUE;
		}

	if(b) {
		tex->DiscardTexHandle();
		tex->NotifyChanged();
		dlg->UpdateMtlDisplay();
		}
	}

void BMCropper::OnClose(){ FUNC_ENTER("BMCropper::OnClose"); 
	dlg->cropping = FALSE;
	}

//------------------------------------------------------------------------
// BMTexNotify -- Methods
//------------------------------------------------------------------------

int BMTexNotify::Changed(ULONG flags) { FUNC_ENTER("BMTexNotify::Changed"); 
	tex->NotifyChanged();
	tex->DiscardTexHandle();
	return 1;
	}

//------------------------------------------------------------------------
//------------------------------------------------------------------------

int numBMTexs = 0;
class BMTexClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() { FUNC_ENTER("BMTexClassDesc::IsPublic");  return 1; }
	void *			Create(BOOL loading);
//	{ 	return new BMTex; }
	const TCHAR *	ClassName() { FUNC_ENTER("BMTexClassDesc::ClassName");  return "NExt Texture"; } // mjm - 2.3.99
	SClass_ID		SuperClassID() { FUNC_ENTER("BMTexClassDesc::SuperClassID");  return TEXMAP_CLASS_ID; }
	Class_ID 		ClassID() { FUNC_ENTER("BMTexClassDesc::ClassID");  return NEXT_TEXTURE_CLASS_ID; }
	const TCHAR* 	Category() { FUNC_ENTER("BMTexClassDesc::Category");  return TEXMAP_CAT_2D;  }
// PW: new descriptor data accessors added.  Note that the 
//      internal name is hardwired since it must not be localized.
	const TCHAR*	InternalName() { FUNC_ENTER("BMTexClassDesc::InternalName");  return _T("NExt Texture"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { FUNC_ENTER("BMTexClassDesc::HInstance");  return hInstance; }			// returns owning module handle

	};

static BMTexClassDesc next_tex_cd;

static int bmFilterType(int filt_type) { FUNC_ENTER("bmFilterType"); 
	switch(filt_type) {
		case FILTER_PYR: return BMM_FILTER_PYRAMID;
		case FILTER_SAT: return BMM_FILTER_SUM;
		default: return BMM_FILTER_NONE;
		}
	}


ClassDesc* GetNExtTextureDesc() { FUNC_ENTER("GetNExtTextureDesc");  return &next_tex_cd;  }

class BMCpPBAccessor : public PBAccessor
{
public:
	void Set(PB2Value& val, ReferenceMaker* owner, ParamID id, int tabIndex, TimeValue t)
	{ FUNC_ENTER("BMCpPBAccessor::Set"); 
		BMTex* bmt = (BMTex*)owner;
		switch (id)
			{
			case bmcp_clipu: {
				float u = val.f;
				float w = bmt->GetClipW(t);
				if (u+w>1.0f) 
					bmt->SetClipW(t,1.0f-u);
				break;
				}
			case bmcp_clipv: {
				float v = val.f;
				float h = bmt->GetClipH(t);
				if (v+h>1.0f) 
					bmt->SetClipH(t,1.0f-v);
				break;
				}
			case bmcp_clipw: {
				float w = val.f;
				float u = bmt->GetClipU(t);
				if (u+w>1.0f) 
					bmt->SetClipU(t,1.0f-w);
				break;
				}
			case bmcp_cliph: {
				float h = val.f;
				float v = bmt->GetClipV(t);
				if (v+h>1.0f) 
					bmt->SetClipV(t,1.0f-h);
				break;
				}
			}
	}
	
	void Get(PB2Value& v, ReferenceMaker* owner, ParamID id, int tabIndex, TimeValue t, Interval &valid)    // get into v
	{ FUNC_ENTER("BMCpPBAccessor::Get"); 

	}
};

class BMTexPBAccessor : public PBAccessor
{
public:
	void Set(PB2Value& val, ReferenceMaker* owner, ParamID id, int tabIndex, TimeValue t)    // set from v
		{ FUNC_ENTER("BMTexPBAccessor::Set"); 
		BMTex* bmt = (BMTex*)owner;
		switch (id)
			{
			case bmtex_bitmap_ps2:
				{
				if (!bmt->loading) {
					bmt->ReloadBitmapAndUpdate();
					// send message so browser/navigator name gets updated
					bmt->NotifyDependents(FOREVER,PART_ALL,REFMSG_SUBANIM_STRUCTURE_CHANGED);
					}
				break;
				}
			case bmtex_bitmap_ngc:
				break;
			case bmtex_bitmap_xbox:
				break;
			case bmtex_filename:
				{
				bmt->SetMapName(val.s);
				break;
				}
			
			}
		}
	void Get(PB2Value& v, ReferenceMaker* owner, ParamID id, int tabIndex, TimeValue t, Interval &valid)    // get into v
	{ FUNC_ENTER("BMTexPBAccessor::Get"); 
		BMTex* bmt = (BMTex*)owner;
		switch (id)
		{
			case bmtex_filename:
			{
				v.s = bmt->GetMapName();
				break;
			}

		}
	}
};

static BMTexPBAccessor bmtex_accessor;
static BMCpPBAccessor  bmcp_accessor;

static ParamBlockDesc2 bmtex_param_blk ( bmtex_params, _T("parameters"),  0, &next_tex_cd, P_AUTO_CONSTRUCT + P_AUTO_UI, PBLOCK_REF, 
	//rollout
	IDD_BMTEX, IDS_DS_BITMAP_PARAMS, 0, 0, NULL, 
	// params

	bmtex_bitmap_ps2, _T("bitmap_ps2"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_NAME_PS2,
		p_accessor,		&bmtex_accessor,
		end,
	
	bmtex_bitmap_ngc, _T("bitmap_ngc"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_NAME_NGC,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_xbox, _T("bitmap_xbox"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_NAME_XBOX,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_filter_mode_min, _T("Min Filtering Mode"), TYPE_INT, 0, 0, 	
		p_default, 		vFILTERING_LINEAR, 
		p_ui, 			TYPE_INTLISTBOX, IDC_MIN_FILTERING_MODE, 0,
		p_accessor,		NULL,
		end, 
	bmtex_bitmap_filter_mode_mag, _T("Mag Filtering Mode"), TYPE_INT, 0, 0, 	
		p_default, 		vFILTERING_LINEAR, 
		p_ui, 			TYPE_INTLISTBOX, IDC_MAG_FILTERING_MODE, 0,
		p_accessor,		NULL,
		end, 

	bmtex_bitmap_mip_filter_mode, _T("Mip Min Filtering Mode"), TYPE_INT, 0, 0, 	
		p_default, 		vFILTERING_NEAREST, 
		p_ui, 			TYPE_INTLISTBOX, IDC_MIN_MIP_FILTERING_MODE, 0,
		p_accessor,		NULL,
		end, 
	
	bmtex_bitmap_mip_map_k,	_T("MipMapK"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		-8.0, 
		p_range, 		-100.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_MIPMAP_K, IDC_MIPMAP_K_SPINNER, 0.1, 
		end, 	

	bmtex_bitmap_compress_ngc,	_T("Compress NGC"),		TYPE_BOOL, 		0,	0,
		p_default, 		TRUE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_COMPRESS_NGC, 
		p_accessor,		&bmtex_accessor,
		end, 

	bmtex_bitmap_compress_xbox,	_T("Compress Xbox"),		TYPE_BOOL, 		0,	0,
		p_default, 		TRUE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_COMPRESS_XBOX, 
		p_accessor,		&bmtex_accessor,
		end, 

	bmtex_bitmap_use_ps2_mips_ngc,	_T("Use PS2 mips NGC"),		TYPE_BOOL, 		0,	0,
		p_default, 		TRUE, 
		p_enabled,		TRUE,
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_USE_PS2_MIPMAPS_NGC, 
		p_accessor,		&bmtex_accessor,
		end, 

	bmtex_bitmap_use_ps2_mips_xbox,	_T("Use PS2 mips XBOX"),		TYPE_BOOL, 		0,	0,
		p_default, 		TRUE, 
		p_enabled,		TRUE,
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_USE_PS2_MIPMAPS_XBOX, 
		p_accessor,		&bmtex_accessor,
		end, 

	bmtex_bitmap_mip_1_ps2, _T("mipmap_1_ps2"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_MIP_NAME_1_PS2,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_mip_2_ps2, _T("mipmap_2_ps2"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_MIP_NAME_2_PS2,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_mip_3_ps2, _T("mipmap_3_ps2"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_MIP_NAME_3_PS2,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_mip_4_ps2, _T("mipmap_4_ps2"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_MIP_NAME_4_PS2,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_mip_5_ps2, _T("mipmap_5_ps2"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_MIP_NAME_5_PS2,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_mip_1_ngc, _T("mipmap_1_ngc"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_MIP_NAME_1_NGC,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_mip_2_ngc, _T("mipmap_2_ngc"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_MIP_NAME_2_NGC,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_mip_3_ngc, _T("mipmap_3_ngc"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_MIP_NAME_3_NGC,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_mip_4_ngc, _T("mipmap_4_ngc"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_MIP_NAME_4_NGC,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_mip_5_ngc, _T("mipmap_5_ngc"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_MIP_NAME_5_NGC,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_mip_1_xbox, _T("mipmap_1_xbox"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_MIP_NAME_1_XBOX,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_mip_2_xbox, _T("mipmap_2_xbox"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_MIP_NAME_2_XBOX,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_mip_3_xbox, _T("mipmap_3_xbox"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_MIP_NAME_3_XBOX,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_mip_4_xbox, _T("mipmap_4_xbox"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_MIP_NAME_4_XBOX,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_mip_5_xbox, _T("mipmap_5_xbox"),	TYPE_BITMAP, 0, IDS_DS_BITMAP,
		p_ui,			TYPE_BITMAPBUTTON, IDC_BMTEX_MIP_NAME_5_XBOX,
		p_accessor,		&bmtex_accessor,
		end,

	bmtex_bitmap_mip_xbox,	_T("mip xbox"),	TYPE_INT, 0,	0,
		p_default,		1,
		p_ui,			TYPE_RADIO,	3,	IDC_MIP_TYPE_NONE_XBOX, IDC_MIP_TYPE_AUTO_XBOX, IDC_MIP_TYPE_MANUAL_XBOX,
		p_enabled,		TRUE,
		p_accessor,		&bmtex_accessor,
		end,	

	bmtex_bitmap_mip_ps2,	_T("mip ps2"),	TYPE_INT, /*TYPE_RADIOBTN_INDEX*/	0,	0,
		p_default,		0,
		//p_default,      1,
		p_ui,			TYPE_RADIO,	3,	IDC_MIP_TYPE_NONE_PS2, IDC_MIP_TYPE_AUTO_PS2, IDC_MIP_TYPE_MANUAL_PS2,
		p_enabled,		TRUE,
		p_accessor,		&bmtex_accessor,
		end, 

	bmtex_bitmap_mip_ngc,	_T("mip ngc"),	TYPE_INT, /*TYPE_RADIOBTN_INDEX*/	0,	0,
		p_default,		1,
		p_ui,			TYPE_RADIO,	3,	IDC_MIP_TYPE_NONE_NGC, IDC_MIP_TYPE_AUTO_NGC, IDC_MIP_TYPE_MANUAL_NGC,
		p_enabled,		TRUE,
		p_accessor,		&bmtex_accessor,
		end, 
	
	bmtex_bitmap_truecolor_palette,	_T("24-bit palette"), TYPE_BOOL, 0,	IDS_24_BIT,
		p_enabled,		TRUE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_24_BIT, 
		p_accessor,		&bmtex_accessor,
		end, 	
	bmtex_bitmap_change_trans_color, _T("Trans Color"),	TYPE_RGBA,		P_ANIMATABLE,	0,
		p_default,		Color(0,0,0), 
		p_ui,			TYPE_COLORSWATCH, IDC_TRANS_COLOR, 
		end,
	bmtex_bitmap_change_trans, _T("Change Color of Fully Trans. Pal Entry"), TYPE_BOOL, 0, IDS_CHANGE_TRANS,
		p_enabled,		TRUE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_CHANGE_TRANS, 
		p_accessor,		&bmtex_accessor,
		p_enable_ctrls,	1,	bmtex_bitmap_change_trans_color,
		end, 	

	bmtex_coords,		_T("coords"),	TYPE_REFTARG,		P_OWNERS_REF,	IDS_DS_COORDINATES,
		p_refno,		UVGEN_REF, 
		end,
	/*bmtex_output,		_T("output"),	TYPE_REFTARG,		P_OWNERS_REF,	IDS_DS_TEXOUT,
		p_refno,		TEXOUT_REF, 
		end,*/	

	bmtex_filename,		_T("fileName"), TYPE_STRING,		P_TRANSIENT,	IDS_JW_FILENAME,
		p_accessor,		&bmtex_accessor,
		end,

	/// New stuff
	bmtex_bitmap_mip_1_ps2_pal, _T("mipmap_1_ps2_pal"), TYPE_BOOL, 0, 0,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_PAL_PS2_MIP1,
		p_accessor,     &bmtex_accessor,
		end,

	bmtex_bitmap_mip_2_ps2_pal, _T("mipmap_2_ps2_pal"), TYPE_BOOL, 0, 0,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_PAL_PS2_MIP2,
		p_accessor,     &bmtex_accessor,
		end,

	bmtex_bitmap_mip_3_ps2_pal, _T("mipmap_3_ps2_pal"), TYPE_BOOL, 0, 0,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_PAL_PS2_MIP3,
		p_accessor,     &bmtex_accessor,
		end,

	bmtex_bitmap_mip_4_ps2_pal, _T("mipmap_4_ps2_pal"), TYPE_BOOL, 0, 0,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_PAL_PS2_MIP4,
		p_accessor,     &bmtex_accessor,
		end,

	bmtex_bitmap_mip_5_ps2_pal, _T("mipmap_5_ps2_pal"), TYPE_BOOL, 0, 0,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_PAL_PS2_MIP5,
		p_accessor,     &bmtex_accessor,
		end,

	bmtex_bitmap_mip_1_ngc_pal, _T("mipmap_1_ngc_pal"), TYPE_BOOL, 0, 0,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_PAL_NGC_MIP1,
		p_accessor,     &bmtex_accessor,
		end,

	bmtex_bitmap_mip_2_ngc_pal, _T("mipmap_2_ngc_pal"), TYPE_BOOL, 0, 0,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_PAL_NGC_MIP2,
		p_accessor,     &bmtex_accessor,
		end,

	bmtex_bitmap_mip_3_ngc_pal, _T("mipmap_3_ngc_pal"), TYPE_BOOL, 0, 0,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_PAL_NGC_MIP3,
		p_accessor,     &bmtex_accessor,
		end,

	bmtex_bitmap_mip_4_ngc_pal, _T("mipmap_4_ngc_pal"), TYPE_BOOL, 0, 0,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_PAL_NGC_MIP4,
		p_accessor,     &bmtex_accessor,
		end,

	bmtex_bitmap_mip_5_ngc_pal, _T("mipmap_5_ngc_pal"), TYPE_BOOL, 0, 0,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_PAL_NGC_MIP5,
		p_accessor,     &bmtex_accessor,
		end,

	bmtex_bitmap_mip_1_xbox_pal, _T("mipmap_1_xbox_pal"), TYPE_BOOL, 0, 0,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_PAL_XBX_MIP1,
		p_accessor,     &bmtex_accessor,
		end,

	bmtex_bitmap_mip_2_xbox_pal, _T("mipmap_2_xbox_pal"), TYPE_BOOL, 0, 0,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_PAL_XBX_MIP2,
		p_accessor,     &bmtex_accessor,
		end,

	bmtex_bitmap_mip_3_xbox_pal, _T("mipmap_3_xbox_pal"), TYPE_BOOL, 0, 0,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_PAL_XBX_MIP3,
		p_accessor,     &bmtex_accessor,
		end,

	bmtex_bitmap_mip_4_xbox_pal, _T("mipmap_4_xbox_pal"), TYPE_BOOL, 0, 0,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_PAL_XBX_MIP4,
		p_accessor,     &bmtex_accessor,
		end,

	bmtex_bitmap_mip_5_xbox_pal, _T("mipmap_5_xbox_pal"), TYPE_BOOL, 0, 0,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_PAL_XBX_MIP5,
		p_accessor,     &bmtex_accessor,
		end,

///////////// Crop/Placement
	bmcp_clipu,			_T("clipu"),		TYPE_FLOAT,		P_ANIMATABLE,		_T("Clip U Offset"),
	p_default,			0.0,
	p_range,			0.0, 1.0,
	p_ui,				TYPE_SPINNER,  EDITTYPE_FLOAT,  IDC_CLIP_X,  IDC_CLIP_XSPIN,  0.001f,
	p_accessor,			&bmcp_accessor,
	end,

	bmcp_clipv,			_T("clipv"),		TYPE_FLOAT,		P_ANIMATABLE,		_T("Clip V Offset"),
	p_default,			0.0,
	p_range,			0.0, 1.0,
	p_ui,				TYPE_SPINNER,  EDITTYPE_FLOAT,  IDC_CLIP_Y,  IDC_CLIP_YSPIN,  0.001f,
	p_accessor,         &bmcp_accessor,
	end,


	bmcp_clipw,			_T("clipw"),		TYPE_FLOAT,		P_ANIMATABLE,		_T("Clip W Offset"),
	p_default,			0.0,
	p_range,			0.0, 1.0,
	p_ui,				TYPE_SPINNER,  EDITTYPE_FLOAT,	IDC_CLIP_W,  IDC_CLIP_WSPIN,  0.001f,
	p_accessor,			&bmcp_accessor,
	end,


	bmcp_cliph,			_T("cliph"),		TYPE_FLOAT,		P_ANIMATABLE,		_T("Clip H Offset"),
	p_default,			0.0,
	p_range,			0.0, 1.0,
	p_ui,				TYPE_SPINNER,  EDITTYPE_FLOAT,  IDC_CLIP_H,  IDC_CLIP_HSPIN,  0.001f,
	p_accessor,			&bmcp_accessor,
	end,

	bmcp_apply,			_T("apply"),		TYPE_BOOL,		0,					_T("Apply UV Crop/Place updates"),
	p_default,			FALSE,
	p_ui,				TYPE_SINGLECHEKBOX,  IDC_BM_CLIP,
	end,	

	bmcp_crop_place,	_T("cropPlace"), TYPE_INT,			0,					_T("Select Cropping or Placement"),
	p_default,			0,
	p_range,			0, 1,
	p_ui,				TYPE_RADIO, 2,  IDC_BM_CROP,  IDC_BM_PLACE,
	end,

///////////// end Crop/Placement

	end
);




//Function Publishing descriptor for Mixin interface
//*****************************************************
static FPInterfaceDesc bitmaptex_interface(
    BITMAPTEX_INTERFACE, _T("bitmapTex"), 0, &next_tex_cd, FP_MIXIN,
		bitmaptex_reload, _T("reload"), 0, TYPE_VOID, 0, 0,
		bitmaptex_crop, _T("viewImage"), 0, TYPE_VOID, 0, 0,
      end
      );


void *	BMTexClassDesc::Create(BOOL loading)
	{ FUNC_ENTER("BMTexClassDesc::Create");  	
	AddInterface(&bitmaptex_interface);
	return new BMTex; 
	}


FPInterfaceDesc* BitmapTex::GetDesc()
	{ FUNC_ENTER("BitmapTex::GetDesc"); 
	 return &bitmaptex_interface;
	}



void BMTex::SetEndCondition(int endcond) { FUNC_ENTER("BMTex::SetEndCondition");  
    #ifndef DESIGN_VER
	endCond = endcond; 
//	ParamID changedParam = pblockTime->LastNotifyParamID();
//	bmtex_time_param_blk.InvalidateUI(changedParam);
    #endif // DESIGN_VER
}
void BMTex::SetStartTime(TimeValue t) { FUNC_ENTER("BMTex::SetStartTime"); 
    #ifndef DESIGN_VER
	startTime = t; 
//	ParamID changedParam = pblockTime->LastNotifyParamID();
//	bmtex_time_param_blk.InvalidateUI(changedParam);
    #endif // DESIGN_VER
}
void BMTex::SetPlaybackRate(float r) { FUNC_ENTER("BMTex::SetPlaybackRate");  
    #ifndef DESIGN_VER
	pbRate = r; 
//	ParamID changedParam = pblockTime->LastNotifyParamID();
//	bmtex_time_param_blk.InvalidateUI(changedParam);
    #endif // DESIGN_VER
}


//------------------------------------------------------------------------
// BMTexDlg -- Methods
//------------------------------------------------------------------------
BMTexDlg::BMTexDlg(HWND hwMtlEdit, IMtlParams *imp, BMTex *m) { FUNC_ENTER("BMTexDlg::BMTexDlg");  
	hwmedit = hwMtlEdit;
	ip = imp;
	hPanel = NULL;
	theBMTex = m; 
	valid  = FALSE;
	isActive  = FALSE;
	cropping = FALSE;
	curTime = imp->GetTime();

//	hTime = 0;
	curTime = 0;
	}

void BMTexDlg::ReloadDialog() { FUNC_ENTER("BMTexDlg::ReloadDialog"); 
	Interval valid;
	theBMTex->Update(curTime, valid);
	LoadDialog(FALSE);
	}

void BMTexDlg::Update(TimeValue t) { FUNC_ENTER("BMTexDlg::Update"); 
	Interval valid;
	curTime = t;
	if (!theBMTex->ivalid.InInterval(t)) {
		theBMTex->Update(curTime, valid);
#ifndef DESIGN_VER
		LoadDialog(FALSE);
		InvalidateRect(hPanel,NULL,0);
		if (cropping) {
		    theBMTex->StuffCropValues();
			}
#endif // !DESIGN_VER
		}
	}


BMTexDlg::~BMTexDlg() { FUNC_ENTER("BMTexDlg::~BMTexDlg"); 
	RemoveCropImage();
	theBMTex->paramDlg = NULL;
	SetWindowLongPtr(hPanel, GWLP_USERDATA, NULL);
	hPanel =  NULL;
	}

void BMTex::FreeBitmap() { FUNC_ENTER("BMTex::FreeBitmap"); 
	if (thebm) {
		thebm->DeleteThis();
		thebm = NULL;
		}
	if (texHandle) {
		texHandle->DeleteThis();
		texHandle = NULL;	
		}
	loadFailed = FALSE;
	}


void BMTexDlg::BMNameChanged() { FUNC_ENTER("BMTexDlg::BMNameChanged"); 
	theBMTex->FreeBitmap();
	theBMTex->NotifyChanged();
	StuffBMNameField(hPanel);
	theBMTex->loadFailed = FALSE;
	BMMRES res = theBMTex->LoadBitmap(ip->GetTime());
	if (res==BMMRES_NODRIVER) 
	   	InvalidNameMsg(theBMTex->bi.Name());
	EnableAlphaButtons(TRUE);
    UpdateMtlDisplay();
	}



void BMTexDlg::HandleNameButton() { FUNC_ENTER("BMTexDlg::HandleNameButton"); 
	BOOL silent = TheManager->SetSilentMode(TRUE);
	BOOL res = TheManager->SelectFileInputEx(&theBMTex->bi, hPanel, GetString(IDS_DS_SELECT_BMFILE));
	TheManager->SetSilentMode(silent);
	if (res) {
		BMNameChanged();
		}
	}

BOOL BMTexDlg::KeyAtCurTime(int id) { FUNC_ENTER("BMTexDlg::KeyAtCurTime");  return theBMTex->pblock->KeyFrameAtTime(id,curTime); }

void GetBMName(BitmapInfo& bi, TSTR &fname, BOOL full=FALSE) { FUNC_ENTER("GetBMName");  
	TSTR fullName;
	if (bi.Name()[0]==0)
		fullName = bi.Device();
	else 
		fullName =  bi.Name();
	if (full)
		fname = fullName;
	else 
		SplitPathFile(fullName,NULL,&fname);
	}

void BMTexDlg::StuffBMNameField(HWND hwndDlg) { FUNC_ENTER("BMTexDlg::StuffBMNameField"); 
	TSTR fname;
//	GetBMName(theBMTex->bi,fname,TRUE);
//	if (iName) {
//		iName->SetText(fname.data());
//		iName->SetTooltip(TRUE,fname.data());
//		}
	}

void BMTexDlg::ShowCropImage() { FUNC_ENTER("BMTexDlg::ShowCropImage"); 
	if (!theBMTex) return;
	Bitmap *bm = theBMTex->thebm;
	if (!bm) { 
		BMMRES res = theBMTex->LoadBitmap(ip->GetTime());
		if (!bm) return;
		}
	cropper.Init(this,curTime);
	cropping = TRUE;
    int junk = bm->Display( GetString(IDS_DS_CROP_TITLE),BMM_CN, FALSE, FALSE, &cropper );
	}

void BMTexDlg::RemoveCropImage() { FUNC_ENTER("BMTexDlg::RemoveCropImage"); 
	cropping = FALSE;
	if (!theBMTex) return;
	Bitmap *bm = theBMTex->thebm;
	if (!bm) return;
 	bm->UnDisplay( );
	}


static int colID[2] = { IDC_CHECK_COL1, IDC_CHECK_COL2 };

void BMTexDlg::EnableAlphaButtons(BOOL isNew) { FUNC_ENTER("BMTexDlg::EnableAlphaButtons"); 
	if (hPanel==NULL) return;
	if (theBMTex->bi.Flags()&MAP_HAS_ALPHA) {
		EnableWindow(GetDlgItem(hPanel,IDC_ALPHA_FILE), 1);
		EnableWindow(GetDlgItem(hPanel,IDC_ALPHA_PREMULT), 1);
		EnableWindow(GetDlgItem(hPanel,IDC_BMTEX_ALPHAOUT), 1);
		EnableWindow(GetDlgItem(hPanel,IDC_BMTEX_ALPHAOUT2), 1);
		if (isNew) {
			theBMTex->SetAlphaSource(ALPHA_FILE);
			}
		}
	else {
		EnableWindow(GetDlgItem(hPanel,IDC_ALPHA_FILE), 0);
		EnableWindow(GetDlgItem(hPanel,IDC_ALPHA_PREMULT), 0);
		EnableWindow(GetDlgItem(hPanel,IDC_BMTEX_ALPHAOUT), 0);
		EnableWindow(GetDlgItem(hPanel,IDC_BMTEX_ALPHAOUT2), 0);
		if (theBMTex->alphaSource == ALPHA_FILE)
			theBMTex->SetAlphaSource(ALPHA_NONE);
		if (theBMTex->premultAlpha)
			theBMTex->SetPremultAlpha(TRUE);
		if (isNew) {
			if (theBMTex->alphaAsRGB) 
				theBMTex->SetAlphaAsRGB(FALSE);
			if (theBMTex->alphaAsMono) 
				theBMTex->SetAlphaAsMono(FALSE);
			}
		}
	}


void BMTexDlg::EnableViewImage() { FUNC_ENTER("BMTexDlg::EnableViewImage"); 
	EnableWindow(GetDlgItem(hPanel,IDC_BM_CROP_IMAGE2),(_tcslen(theBMTex->bi.Name())>0)?1:0); 	
	}

BOOL BMTexDlg::DlgProc(TimeValue t,IParamMap2 *map,HWND hwndDlg,UINT msg,WPARAM wParam,LPARAM lParam)		
{ FUNC_ENTER("BMTexDlg::DlgProc"); 	
	int id = LOWORD(wParam);
	int code = HIWORD(wParam);
    switch (msg)    {
		case WM_INITDIALOG:
		{
			HWND drop_down;
			IParamBlock2 *pblock = map->GetParamBlock();
			PBBitmap *bm;
			int i, mode;
			Interval valid;
			HWND static_ctrl;
			char description[64];
			BOOL use_ps2_mips;

			hPanel = map->GetHWnd();			
			
			drop_down = GetDlgItem( hwndDlg, IDC_MIN_FILTERING_MODE );
			SendMessage( drop_down, CB_RESETCONTENT, 0L, 0L );
			for( i = 0; i < 2; i++ )
			{
				SendMessage( drop_down, CB_ADDSTRING, 0L, 
							(LPARAM) filtering_modes[i] );
			}							
			pblock->GetValue( bmtex_bitmap_filter_mode_mag, 0, mode, FOREVER );
			SendMessage( drop_down, CB_SETCURSEL, mode, 0 );

			drop_down = GetDlgItem( hwndDlg, IDC_MAG_FILTERING_MODE );
			SendMessage( drop_down, CB_RESETCONTENT, 0L, 0L );
			for( i = 0; i < 2; i++ )
			{
				SendMessage( drop_down, CB_ADDSTRING, 0L, 
							(LPARAM) filtering_modes[i] );
			}							
			pblock->GetValue( bmtex_bitmap_filter_mode_min, 0, mode, FOREVER );
			SendMessage( drop_down, CB_SETCURSEL, mode, 0 );

			drop_down = GetDlgItem( hwndDlg, IDC_MIN_MIP_FILTERING_MODE );
			SendMessage( drop_down, CB_RESETCONTENT, 0L, 0L );
			for( i = 0; i < 2; i++ )
			{
				SendMessage( drop_down, CB_ADDSTRING, 0L, 
							(LPARAM) filtering_modes[i] );
			}										
			pblock->GetValue( bmtex_bitmap_mip_filter_mode, 0, mode, FOREVER );
			SendMessage( drop_down, CB_SETCURSEL, mode, 0 );

			pblock->GetValue( bmtex_bitmap_ps2, 0, bm, FOREVER );
			if( valid_bitmap( bm ))
			{
				static_ctrl = GetDlgItem( hwndDlg, IDC_BITMAP_DETAILS_PS2 );
				sprintf( description, "%dx%d", bm->bi.Width(), bm->bi.Height());						
				SetWindowText( static_ctrl, description );
			}					
					
			pblock->GetValue( bmtex_bitmap_ngc, 0, bm, FOREVER );
			if( valid_bitmap( bm ))
			{
				static_ctrl = GetDlgItem( hwndDlg, IDC_BITMAP_DETAILS_NGC );
				sprintf( description, "%dx%d", bm->bi.Width(), bm->bi.Height());						
				SetWindowText( static_ctrl, description );
			}					

			pblock->GetValue( bmtex_bitmap_xbox, 0, bm, FOREVER );
			if( valid_bitmap( bm ))
			{
				static_ctrl = GetDlgItem( hwndDlg, IDC_BITMAP_DETAILS_XBOX );
				sprintf( description, "%dx%d", bm->bi.Width(), bm->bi.Height());						
				SetWindowText( static_ctrl, description );
			}	
			
			pblock->GetValue( bmtex_bitmap_use_ps2_mips_ngc, 0, use_ps2_mips, FOREVER );
			if( use_ps2_mips )
			{
				HWND win;

				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_1_NGC );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_2_NGC );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_3_NGC );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_4_NGC );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_5_NGC );
				EnableWindow( win, FALSE );

				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_1_NGC_CLEAR );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_2_NGC_CLEAR );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_3_NGC_CLEAR );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_4_NGC_CLEAR );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_5_NGC_CLEAR );
				EnableWindow( win, FALSE );
			}

			pblock->GetValue( bmtex_bitmap_use_ps2_mips_xbox, 0, use_ps2_mips, FOREVER );
			if( use_ps2_mips )
			{
				HWND win;

				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_1_XBOX );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_2_XBOX );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_3_XBOX );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_4_XBOX );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_5_XBOX );
				EnableWindow( win, FALSE );

				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_1_XBOX_CLEAR );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_2_XBOX_CLEAR );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_3_XBOX_CLEAR );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_4_XBOX_CLEAR );
				EnableWindow( win, FALSE );
				win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_5_XBOX_CLEAR );
				EnableWindow( win, FALSE );
			}

			EnableAlphaButtons();
			EnableViewImage();
			return TRUE;
		}
		break;
		case WM_COMMAND:  
		    switch (id) {
				case IDC_PALALLPS2:
				{
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_1_ps2_pal,0,TRUE);
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_2_ps2_pal,0,TRUE);
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_3_ps2_pal,0,TRUE);
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_4_ps2_pal,0,TRUE);
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_5_ps2_pal,0,TRUE);
					break;
				}

				case IDC_PALALLNGC:
				{
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_1_ngc_pal,0,TRUE);
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_2_ngc_pal,0,TRUE);
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_3_ngc_pal,0,TRUE);
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_4_ngc_pal,0,TRUE);
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_5_ngc_pal,0,TRUE);
					break;
				}

				case IDC_PALALLXBX:
				{
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_1_xbox_pal,0,TRUE);
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_2_xbox_pal,0,TRUE);
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_3_xbox_pal,0,TRUE);
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_4_xbox_pal,0,TRUE);
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_5_xbox_pal,0,TRUE);
					break;
				}

				case IDC_BMTEX_NAME_PS2_CLEAR:
				{
					BitmapInfo info;
		
					info.SetName( "None" );	
					info.SetWidth( 0 );
					info.SetHeight( 0 );
					PBBitmap ps2_bm( info );

					theBMTex->pblock->SetValue(bmtex_bitmap_ps2, 0, &ps2_bm );
					//theBMTex->pblock->SetValue(bmtex_bitmap_ps2, 0, NULL );
					break;
				}

				case IDC_BMTEX_NAME_NGC_CLEAR:
				{
					BitmapInfo info;
					
					info.SetName( "Use PS2" );
					info.SetWidth( 0 );
					info.SetHeight( 0 );

					PBBitmap pb_bm( info );

					theBMTex->pblock->SetValue( bmtex_bitmap_ngc, 0, &pb_bm );
					//theBMTex->pblock->SetValue(bmtex_bitmap_ngc, 0, NULL );
					break;
				}

				case IDC_BMTEX_NAME_XBOX_CLEAR:
				{
					BitmapInfo info;
					
					info.SetName( "Use PS2" );
					info.SetWidth( 0 );
					info.SetHeight( 0 );

					PBBitmap pb_bm( info );

					theBMTex->pblock->SetValue( bmtex_bitmap_xbox, 0, &pb_bm );		
					//theBMTex->pblock->SetValue(bmtex_bitmap_xbox, 0, NULL );
					break;
				}

				case IDC_BMTEX_MIP_1_PS2_CLEAR:
				case IDC_BMTEX_MIP_2_PS2_CLEAR:
				case IDC_BMTEX_MIP_3_PS2_CLEAR:
				case IDC_BMTEX_MIP_4_PS2_CLEAR:
				case IDC_BMTEX_MIP_5_PS2_CLEAR:
				{
					int index;
					BitmapInfo info;
		
					info.SetName( "None" );	
					info.SetWidth( 0 );
					info.SetHeight( 0 );
					PBBitmap mip_bm( info );					
					
					index = id - IDC_BMTEX_MIP_1_PS2_CLEAR;					
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_1_ps2 + index, 0, &mip_bm );
					//theBMTex->pblock->SetValue(bmtex_bitmap_mip_1_ps2 + index, 0, NULL );
					break;
				}

				case IDC_BMTEX_MIP_1_NGC_CLEAR:
				case IDC_BMTEX_MIP_2_NGC_CLEAR:
				case IDC_BMTEX_MIP_3_NGC_CLEAR:
				case IDC_BMTEX_MIP_4_NGC_CLEAR:
				case IDC_BMTEX_MIP_5_NGC_CLEAR:
				{
					int index;
					BitmapInfo info;
		
					info.SetName( "None" );	
					info.SetWidth( 0 );
					info.SetHeight( 0 );
					PBBitmap mip_bm( info );					
					
					index = id - IDC_BMTEX_MIP_1_NGC_CLEAR;
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_1_ngc + index, 0, &mip_bm );
					//theBMTex->pblock->SetValue(bmtex_bitmap_mip_1_ngc + index, 0, NULL);
					break;
				}

				case IDC_BMTEX_MIP_1_XBOX_CLEAR:
				case IDC_BMTEX_MIP_2_XBOX_CLEAR:
				case IDC_BMTEX_MIP_3_XBOX_CLEAR:
				case IDC_BMTEX_MIP_4_XBOX_CLEAR:
				case IDC_BMTEX_MIP_5_XBOX_CLEAR:
				{
					int index;
					BitmapInfo info;
		
					info.SetName( "None" );	
					info.SetWidth( 0 );
					info.SetHeight( 0 );
					PBBitmap mip_bm( info );					
					
					index = id - IDC_BMTEX_MIP_1_XBOX_CLEAR;
					theBMTex->pblock->SetValue(bmtex_bitmap_mip_1_xbox + index, 0, &mip_bm );
					//theBMTex->pblock->SetValue(bmtex_bitmap_mip_1_xbox + index, 0, NULL);
					break;
				}

				case IDC_USE_PS2_MIPMAPS_NGC:
				{
					HWND win;
					BOOL checked = GetCheckBox( hwndDlg, IDC_USE_PS2_MIPMAPS_NGC);
						
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_1_NGC );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_2_NGC );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_3_NGC );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_4_NGC );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_5_NGC );
					EnableWindow( win, !checked );

					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_1_NGC_CLEAR );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_2_NGC_CLEAR );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_3_NGC_CLEAR );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_4_NGC_CLEAR );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_5_NGC_CLEAR );
					EnableWindow( win, !checked );
					break;
				}

				case IDC_USE_PS2_MIPMAPS_XBOX:
				{
					HWND win;

					BOOL checked = GetCheckBox( hwndDlg, IDC_USE_PS2_MIPMAPS_XBOX );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_1_XBOX );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_2_XBOX );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_3_XBOX );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_4_XBOX );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_NAME_5_XBOX );
					EnableWindow( win, !checked );

					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_1_XBOX_CLEAR );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_2_XBOX_CLEAR );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_3_XBOX_CLEAR );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_4_XBOX_CLEAR );
					EnableWindow( win, !checked );
					win = GetDlgItem( hwndDlg, IDC_BMTEX_MIP_5_XBOX_CLEAR );
					EnableWindow( win, !checked );
					break;
				}

				case IDC_BMTEX_NAME: 
					bmtex_param_blk.InvalidateUI(bmtex_bitmap_ps2);
					break;

				case IDC_ALPHA_FILE:
				case IDC_ALPHA_XPCOL:
				case IDC_ALPHA_RGB:
				case IDC_ALPHA_NONE:
					theBMTex->NotifyChanged();
					theBMTex->DiscardTexHandle();
				    UpdateMtlDisplay();
					break;
				case IDC_FILTER_NADA:
				case IDC_FILTER_PYR:
				case IDC_FILTER_SAT:
					theBMTex->NotifyChanged();
					break;
				case IDC_BMTEX_RELOAD:
					theBMTex->ReloadBitmap();
					BroadcastNotification(NOTIFY_BITMAP_CHANGED, (void *)theBMTex->bi.Name());
					//theBMTex->NotifyChanged();
				    UpdateMtlDisplay(); // redraw viewports
					Invalidate();  // incase path of map has changed.
					macroRec->OperandSequence(1, mr_prop, _T("bitmaptex.Reload()"),mr_reftarg, theBMTex);

					break;
				case IDC_BMTEX_RGBOUT:
				case IDC_BMTEX_ALPHAOUT:
					theBMTex->NotifyChanged();
					break;
				case IDC_BMTEX_RGBOUT2:
				case IDC_BMTEX_ALPHAOUT2:
					theBMTex->NotifyChanged();
					theBMTex->DiscardTexHandle();
				    UpdateMtlDisplay();
					break;
				case IDC_ALPHA_PREMULT:
					theBMTex->NotifyChanged();
					theBMTex->DiscardTexHandle();
				    UpdateMtlDisplay();
					break;
				case IDC_BM_CLIP: 
					theBMTex->applyCrop = GetCheckBox(hwndDlg,id);
					theBMTex->NotifyChanged();
					theBMTex->DiscardTexHandle();
				    UpdateMtlDisplay();
					break;
				case IDC_BM_CROP_IMAGE2: 
					ShowCropImage();
					macroRec->OperandSequence(1, mr_prop, _T("bitmaptex.ViewImage()"),mr_reftarg, theBMTex);

//					macroRecorder->FunctionCall(_T("$.modifiers[#flex].quality"), 0, 0);

					break;
				case IDC_BM_CROP:
				case IDC_BM_PLACE:
					CheckRadioButton( hwndDlg, IDC_BM_CROP, IDC_BM_PLACE, id);
					theBMTex->placeImage = id==IDC_BM_PLACE?1:0;
					theBMTex->NotifyChanged();
					theBMTex->DiscardTexHandle();
				    UpdateMtlDisplay();
					if (cropping) theBMTex->StuffCropValues();
					theBMTex->EnableStuff();
					break;
				case IDC_BM_JITTER:
//					theBMTex->randPlace =  GetCheckBox(hwndDlg,id);
					theBMTex->NotifyChanged();
				    UpdateMtlDisplay();
					theBMTex->EnableStuff();
					break;
				}
			break;

		case WM_PAINT: 	
			if (!valid) {
				valid = TRUE;
				ReloadDialog();
				}
			break;

		case CC_SPINNER_CHANGE: 
			if (!theHold.Holding()) theHold.Begin();
//			switch (id) {
				theBMTex->NotifyChanged();
				if (cropping) theBMTex->StuffCropValues();
//need to make as an accesot
/*
				case IDC_CLIP_XSPIN: {
					float u = 0.0f;//clipUSpin->GetFVal();
					theBMTex->SetClipU(curTime,u);
//					clipUSpin->SetKeyBrackets(KeyAtCurTime(PB_CLIPU));
					float w = theBMTex->GetClipW(curTime);
					if (u+w>1.0f) {
						w = 1.0f-u;
						theBMTex->SetClipW(curTime,w);
//						clipWSpin->SetValue(theBMTex->clipw,FALSE);
//						clipWSpin->SetKeyBrackets(KeyAtCurTime(PB_CLIPW));
						}
					theBMTex->NotifyChanged();
					if (cropping) theBMTex->StuffCropValues();
					}
					break; 	
				case IDC_CLIP_YSPIN: {
					float v = 0.0f;//clipVSpin->GetFVal();
					theBMTex->SetClipV(curTime,v);
//					clipVSpin->SetKeyBrackets(KeyAtCurTime(PB_CLIPV));
					float h = theBMTex->GetClipH(curTime);
					if (v+h>1.0f) {
						h = 1.0f-v;
						theBMTex->SetClipH(curTime,h);
//						clipHSpin->SetValue(theBMTex->cliph,FALSE);
//						clipHSpin->SetKeyBrackets(KeyAtCurTime(PB_CLIPH));
						}
					theBMTex->NotifyChanged();
					if (cropping) theBMTex->StuffCropValues();
					}
					break; 	
				case IDC_CLIP_WSPIN: {
					float w = 0.0f;//clipWSpin->GetFVal();
					theBMTex->SetClipW(curTime,w);
//					clipWSpin->SetKeyBrackets(KeyAtCurTime(PB_CLIPW));
					float u = theBMTex->GetClipU(curTime);
					if (u+w>1.0f) {
						u = 1.0f-w;
						theBMTex->SetClipU(curTime,u);
//						clipUSpin->SetValue(theBMTex->clipu,FALSE);
//						clipUSpin->SetKeyBrackets(KeyAtCurTime(PB_CLIPU));
						}
					theBMTex->NotifyChanged();
					if (cropping) theBMTex->StuffCropValues();
					}
					break; 	
				case IDC_CLIP_HSPIN: {
					float h = 0.0f;//clipHSpin->GetFVal();
					theBMTex->SetClipH(curTime,h);
//					clipHSpin->SetKeyBrackets(KeyAtCurTime(PB_CLIPH));
					float v = theBMTex->GetClipV(curTime);
					if (v+h>1.0f) {
						v = 1.0f-h;
						theBMTex->SetClipV(curTime,v);
//						clipVSpin->SetValue(theBMTex->clipv,FALSE);
//						clipVSpin->SetKeyBrackets(KeyAtCurTime(PB_CLIPV));
						}
					theBMTex->NotifyChanged();
					if (cropping) theBMTex->StuffCropValues();
					}
					break;
				case IDC_JITTER_SPIN:
//					theBMTex->SetJitter(curTime,jitterSpin->GetFVal());
//					jitterSpin->SetKeyBrackets(KeyAtCurTime(PB_JITTER));
					theBMTex->NotifyChanged();
					break;
*/

//				}
			break;
		case CC_SPINNER_BUTTONDOWN:
			theHold.Begin();
			break;		
		case WM_CUSTEDIT_ENTER:
		case CC_SPINNER_BUTTONUP: 
			if (HIWORD(wParam) || msg==WM_CUSTEDIT_ENTER) theHold.Accept(GetString(IDS_DS_PARAMCHG));
			else theHold.Cancel();
			theBMTex->DiscardTexHandle();
			theBMTex->NotifyChanged();
		    UpdateMtlDisplay();
			if (cropping) theBMTex->StuffCropValues();
			break;
		case WM_DESTROY:		
			RemoveCropImage();
			break;
    	}
	return FALSE;
	}



void BMTexDlg::LoadDialog(BOOL draw) { FUNC_ENTER("BMTexDlg::LoadDialog"); 
	if (theBMTex) {
		Interval valid;
		theBMTex->Update(curTime,valid);
		StuffBMNameField(hPanel);
		CheckRadioButton( hPanel, IDC_ALPHA_FILE, IDC_ALPHA_NONE, IDC_ALPHA_FILE+theBMTex->alphaSource);
		CheckRadioButton( hPanel, IDC_FILTER_PYR, IDC_FILTER_NADA, IDC_FILTER_PYR+theBMTex->filterType);
		CheckRadioButton( hPanel, IDC_BMTEX_RGBOUT, IDC_BMTEX_ALPHAOUT, IDC_BMTEX_RGBOUT+theBMTex->alphaAsMono);
		CheckRadioButton( hPanel, IDC_BMTEX_RGBOUT2, IDC_BMTEX_ALPHAOUT2, IDC_BMTEX_RGBOUT2+theBMTex->alphaAsRGB);
		SetCheckBox( hPanel, IDC_ALPHA_PREMULT, theBMTex->premultAlpha);
		SetCheckBox( hPanel, IDC_BM_CLIP, theBMTex->applyCrop);
		EnableAlphaButtons(FALSE);
		}
	}

void BMTexDlg::SetThing(ReferenceTarget *m) { FUNC_ENTER("BMTexDlg::SetThing"); 
	assert (m->ClassID()==NEXT_TEXTURE_CLASS_ID);
	assert (m->SuperClassID()==TEXMAP_CLASS_ID);
 	RemoveCropImage();
	if (theBMTex) {
		theBMTex->paramDlg = NULL;
		}
	theBMTex = (BMTex *)m;
	if (theBMTex) theBMTex->paramDlg = this;
	LoadDialog(TRUE);
	}


ReferenceTarget *BMTexDlg::GetInstance(HWND hwnd, POINT p, SClass_ID type) { FUNC_ENTER("BMTexDlg::GetInstance"); 
	DADBitmapCarrier *bmc = GetDADBitmapCarrier();
	TSTR nm = theBMTex->bi.Name();
	bmc->SetName(nm);
	return bmc;
	}

void BMTexDlg::Drop(ReferenceTarget *dropThis, HWND hwnd, POINT p, SClass_ID type) { FUNC_ENTER("BMTexDlg::Drop"); 
	if (dropThis->SuperClassID()!=BITMAPDAD_CLASS_ID) 
		return;
	DADBitmapCarrier *bmc = (DADBitmapCarrier *)dropThis;
	theBMTex->bi.SetName(bmc->GetName().data());
	BMNameChanged();
	}

//------------------------------------------------------------------------
// BMTex -- Methods
//------------------------------------------------------------------------



#define BMTEX_VERSION 3

static ParamBlockDescID pbdesc1[] = {
	{ TYPE_FLOAT, NULL, TRUE,1} 	// blur
	};   

/*
static ParamVersionDesc oldVersions[] = {
	ParamVersionDesc(pbdesc2, 5, 2)
	};
*/
#define NUMOLDVERSIONS 4
//static ParamVersionDesc curVersion(pbdesc2,5,BMTEX_VERSION);

//static int name_id[NPARAMS] = { IDS_DS_CLIPU, IDS_DS_CLIPV, IDS_DS_CLIPW, IDS_DS_CLIPH, IDS_DS_JITTERAMT };

void BMTex::Init() { FUNC_ENTER("BMTex::Init"); 
	if (uvGen) uvGen->Reset();
	else ReplaceReference( 0, GetNewDefaultUVGen());	
//	ReplaceReference( 1, CreateParameterBlock( pbdesc2, NPARAMS, BMTEX_VERSION) );	
	if (texout) texout->Reset();
	else ReplaceReference( 2, GetNewDefaultTextureOutput());
	placeImage = FALSE;
	randPlace = FALSE;
	filterType = FILTER_PYR;
	alphaSource = ALPHA_FILE;
	alphaAsMono = FALSE;
	alphaAsRGB = FALSE;
	premultAlpha = TRUE;
	SetClipU(0,0.0f);
	SetClipV(0,0.0f);
	SetClipW(0,1.0f);
	SetClipH(0,1.0f);
	SetJitter(0,1.0f);
	ivalid.SetEmpty();
	clipValid.SetInfinite();
	isNew = FALSE;
	rumax = rvmax = -100000.0f;
	rumin = rvmin = +100000.0f;
	}

void BMTex::Reset() { FUNC_ENTER("BMTex::Reset"); 
	next_tex_cd.Reset(this, TRUE);	// reset all pb2's
	if (!isNew) {
		FreeBitmap();
		NotifyChanged();
	    if (paramDlg) paramDlg->UpdateMtlDisplay();
		}
	Init();
	}

void BMTex::NotifyChanged() { FUNC_ENTER("BMTex::NotifyChanged"); 
	NotifyDependents(FOREVER, PART_ALL, REFMSG_CHANGE);
	}

#ifdef DESIGN_VER
static void SetGeoReferenceInfo(BitmapInfo & bi, StdUVGen * uvGen)
{
	TheManager->Execute(BMM_RETRIEVE_GEOREF_DATA,
					ULONG_PTR(bi.Name()), ULONG_PTR(&(uvGen->m_geoRefInfo)), 0);
}
#endif

static void BMTexNotify(void *param, NotifyInfo *info) { FUNC_ENTER("BMTexNotify"); 
	OutputDebugString("HANDLER: BMTexNotify\n");
	BMTex *bmt = (BMTex *) param;
	switch(info->intcode) {
		case NOTIFY_BITMAP_CHANGED: {
			TCHAR *nm = (TCHAR *)info->callParam;
			if (nm==NULL || !_tcscmp(nm,bmt->bi.Name())) {
				bmt->NotifyChanged();
				}
			if (nm==NULL) {
				bmt->fileNotFound = 0;
				}
#ifdef DESIGN_VER
			if (!_tcscmp(_T("TIF Image File"), bmt->bi.Device()))
				SetGeoReferenceInfo(bmt->bi, bmt->GetUVGen());
#endif
			break;
			}
		}
	}

BMTex::BMTex() 
{ FUNC_ENTER("BMTex::BMTex"); 
	int i;

	ip = NULL;
	isParm2 = TRUE;
	paramDlg = NULL;
	pblock = NULL;
	uvGen = NULL;
	texout = NULL;
	thebm = NULL;
	texHandle = NULL;
	loadFailed = FALSE;
	inRender = FALSE;
	startTime = 0;
	pbRate = 1.0f;
	endCond = END_LOOP;
	isNew = TRUE;
	applyCrop = FALSE;
	loading = FALSE;
	loadingOld = FALSE;
	clipValid = FOREVER;
	bitmapPB = NULL;
	fileNotFound = FALSE;
	next_tex_cd.MakeAutoParamBlocks(this);	// make and intialize paramblock2
	Init();
	bmNotify.SetTex(this);
	rollScroll=0;
	bmWasSet = FALSE;
	m_updated = false;
	
	for( i = 0; i < vNUM_PLATFORMS; i++ )
	{
		int j;

		m_Compress[i] = ( i != vPLAT_PS2 );	// default to true for non-ps2 platforms
		m_MipType[i] = vMIP_TYPE_NONE;
		m_UsePS2Mips[i] = true;

		for( j = 0; j < vMAX_NUM_MIP_LEVELS; j++ )
		{
			m_Bitmaps[i][j] = NULL;
			useBasePal[i][j] = FALSE;
		}
	}

	for( i = 0; i < vNUM_PLATFORMS - 1; i++ )
		biTexName[i].SetFlags( MAP_IS_GENERATED );

	m_MipMapK = -8.0f;
	m_MinFilterMode = vFILTERING_LINEAR;
	m_MagFilterMode = vFILTERING_LINEAR;
	m_MipFilterMode = vFILTERING_NEAREST;	

	m_Force24Bit = FALSE;
	m_ChangeTrans = FALSE;
	m_TransColor = Color( 0, 0, 0 );		
			
	if( !loading )
	{
		BitmapInfo info;
		int i;
		
		info.SetName( "None" );	
		info.SetWidth( 0 );
		info.SetHeight( 0 );
		PBBitmap ps2_bm( info );

		pblock->SetValue( bmtex_bitmap_ps2, 0, &ps2_bm );
		
		for( i = 0; i < 5; i++ )
		{
			pblock->SetValue( bmtex_bitmap_mip_1_ps2 + i, 0, &ps2_bm );
			pblock->SetValue( bmtex_bitmap_mip_1_ngc + i, 0, &ps2_bm );
			pblock->SetValue( bmtex_bitmap_mip_1_xbox + i, 0, &ps2_bm );			
		}

		info.SetName( "Use PS2" );	
		PBBitmap other_bm( info );

		pblock->SetValue( bmtex_bitmap_ngc, 0, &other_bm );
		pblock->SetValue( bmtex_bitmap_xbox, 0, &other_bm );			
	}

#ifndef DISABLE_NOTIFICATIONS
	RegisterNotification(BMTexNotify, this, NOTIFY_BITMAP_CHANGED);
#endif
}


void BMTex::SetClipU(TimeValue t, float f) { FUNC_ENTER("BMTex::SetClipU");  
	clipu  = f; 
	pblock->SetValue(bmcp_clipu, t, f);
	bmtex_param_blk.InvalidateUI(bmcp_clipu);

	}


void BMTex::SetClipV(TimeValue t, float f) { FUNC_ENTER("BMTex::SetClipV");  
	clipv  = f; 
	pblock->SetValue( bmcp_clipv, t, f);		
	bmtex_param_blk.InvalidateUI(bmcp_clipv);
	}

void BMTex::SetClipW(TimeValue t, float f) { FUNC_ENTER("BMTex::SetClipW");  
	clipw  = f;
//	  pblock->SetValue( PB_CLIPW, t, f);		
	pblock->SetValue( bmcp_clipw, t, f);		
	bmtex_param_blk.InvalidateUI(bmcp_clipw);
	}

void BMTex::SetClipH(TimeValue t, float f) { FUNC_ENTER("BMTex::SetClipH");  
	cliph  = f; 
//	pblock->SetValue( PB_CLIPH, t, f);		
	pblock->SetValue( bmcp_cliph, t, f);		
	bmtex_param_blk.InvalidateUI(bmcp_cliph);
	}

void BMTex::SetJitter(TimeValue t, float f) { FUNC_ENTER("BMTex::SetJitter");  
	jitter = cliph  = f; 
//	pblock->SetValue( PB_JITTER, t, f);		
	//pblock->SetValue( bmtex_jitter, t, f);	
    //bmtex_param_blk.InvalidateUI(bmtex_jitter);
	}


void BMTex::EnableStuff() { FUNC_ENTER("BMTex::EnableStuff"); 
	if (pblock) {
		IParamMap2 *map = pblock->GetMap();
		pblock->GetValue( bmcp_crop_place, 0, placeImage, FOREVER );
		//pblock->GetValue( bmtex_usejitter, 0, randPlace, FOREVER );
		if (map) {
			//map->Enable(bmtex_jitter, placeImage);
			//map->Enable(bmtex_usejitter, placeImage);
			map->Enable(bmcp_clipu, !(placeImage&&randPlace));
			map->Enable(bmcp_clipv, !(placeImage&&randPlace));
			}
		}
	}

void BMTex::SetFilterType(int ft) { FUNC_ENTER("BMTex::SetFilterType"); 
	// Moved this into BMTexPBAccessor:  DS 2/16/00
//	filterType = ft;
//	if (thebm)	
//		thebm->SetFilter(bmFilterType(filterType));
    //pblock->SetValue( bmtex_filtering, 0, ft);		
	//bmtex_param_blk.InvalidateUI(bmtex_filtering);
	}


void BMTex::SetAlphaSource(int as) { FUNC_ENTER("BMTex::SetAlphaSource"); 
	if (as!=alphaSource) {
		alphaSource =as; 
		mysamp.Init(this);
		alphasamp.Init(this);
	    //if (alphaSource == ALPHA_FILE) pblock->SetValue( bmtex_alphasource, 0, 0);		
	    //else if (alphaSource == ALPHA_RGB) pblock->SetValue( bmtex_alphasource, 0, 1);		
	    //else if (alphaSource == ALPHA_NONE) pblock->SetValue( bmtex_alphasource, 0, 2);		
		//bmtex_param_blk.InvalidateUI(bmtex_alphasource);
	
		}
	}

static TimeValue modt(TimeValue x, TimeValue m) { FUNC_ENTER("modt"); 
	TimeValue n = (int)(x/m);
	x -= n*m;
	return (x<0)? x+m : x ;
	}

void BMTex::StuffCropValues() { FUNC_ENTER("BMTex::StuffCropValues"); 
	//pblock->GetValue( bmtex_crop_place, 0, placeImage, FOREVER );

	//if (thebm) thebm->SetCroppingValues(clipu,clipv,clipw,cliph, placeImage );
	}

int BMTex::CalcFrame(TimeValue t) { FUNC_ENTER("BMTex::CalcFrame"); 
	TimeValue tm,dur,td;
	int fstart = bi.FirstFrame();
	int fend = bi.LastFrame();
	int tpf = GetTicksPerFrame();
	tm = TimeValue(float(t-startTime)*pbRate);
	dur = (fend-fstart+1)*GetTicksPerFrame();
	switch (endCond) {
		case END_HOLD:
			if (tm<=0) return fstart;
			if (tm>=dur) return fend;
			return tm/tpf;
		case END_PINGPONG:
			//if ((tm/dur)&1) 
			if ( ((tm>=0) && ((tm/dur)&1)) || ( (tm<0) && !(tm/dur)))
				{
				td = modt(tm,dur);
				return fstart + fend-td/tpf;
				}
			// else fall thrue--
		case END_LOOP:
			td = modt(tm,dur);
			return td/tpf;
		}
	return 0;
	}

BMMRES BMTex::LoadBitmap(TimeValue t, BOOL quiet, BOOL reload) { FUNC_ENTER("BMTex::LoadBitmapA"); 
	BOOL silent = FALSE;
	BMMRES status = BMMRES_SUCCESS;

	if (bmWasSet) 
		goto skipall;
		
	pblock->GetValue( bmtex_bitmap_ps2, t,bitmapPB, clipValid );
	if ( ((bitmapPB != NULL) && (_tcscmp(bi.Name(), bitmapPB->bi.Name())) )   )
		FreeBitmap();

	UpdateBIName();   //DS 2/18/99
	if (bi.Name()[0]==0)
		if (bi.Device()[0]==0)
			return BMMRES_NODRIVER;
#ifdef DESIGN_VER //KENNY MERGE
	//SS 10/3/2000: In the Kenny source, this line was indented an additional 
	// level, as if the intention was to include it within the outer if 
	// statement. Since that wasn't the case, I have adjusted indentation.
	// However, if you find a bug here, it could be that this should only be
	// called if bi.Name()[0]==0.
	// Additionally, I don't know if this is a general fix or is specific to
	// VIZ; there were no previous comments.
	bi.ResetCustomFlag(BMM_CUSTOM_FILEGAMMA);
#endif
	if (thebm==NULL) {
		bi.SetCurrentFrame(CalcFrame(t));
		BOOL silent;
		if (quiet)
			silent = TheManager->SetSilentMode(TRUE);
	//	SetCursor(LoadCursor(NULL,IDC_WAIT));  // DS 11/22/00: removed this because it was causing cursor flashing in viewports
		thebm = TheManager->Load(&bi,&status);
	//	SetCursor(LoadCursor(NULL,IDC_ARROW)); // DS 11/22/00: removed this because it was causing cursor flashing in viewports
		if (quiet)
			TheManager->SetSilentMode(silent);
		if (thebm==NULL) {
			fileNotFound = TRUE;
			return status;
			}
		if (bitmapPB) {
		    bitmapPB->bi = bi;	  //DS 3/29/99: in case name has changed ( or flags)
			}
		fileNotFound = FALSE; 
		thebm->SetNotify(&bmNotify);
		thebm->SetFilter(bmFilterType(filterType));
		// fixup for imported files
		if (!(bi.Flags()&MAP_HAS_ALPHA)&&alphaSource==ALPHA_FILE) {
			if (paramDlg) 
				paramDlg->EnableAlphaButtons(FALSE);
			else 
 				SetAlphaSource(ALPHA_NONE);
			}
		if (!(bi.Flags()&MAP_HAS_ALPHA))			
			SetPremultAlpha(TRUE);   // DS 6/9/00
		if (paramDlg != NULL) {
			paramDlg->EnableAlphaButtons(!reload);
			paramDlg->EnableViewImage();
			}
		}
//	else {
	bi.SetCurrentFrame(CalcFrame(t));
	silent = TheManager->SetSilentMode(TRUE);
	status = thebm->GoTo(&bi);
	TheManager->SetSilentMode(silent);
#ifdef DESIGN_VER
	if (!_tcscmp(_T("TIF Image File"), bi.Device()))
		SetGeoReferenceInfo(bi, GetUVGen());
#endif
//		}

	skipall:
	mysamp.Init(this);
	alphasamp.Init(this);
	return status;
	}


void BMTex::RenderBitmap(TimeValue t, Bitmap *bm, float scale3D, BOOL filter) { FUNC_ENTER("BMTex::RenderBitmap"); 
	LoadBitmap(t);
	if (thebm) 
		bm->CopyImage(thebm, filter?COPY_IMAGE_RESIZE_HI_QUALITY:COPY_IMAGE_RESIZE_LO_QUALITY, 0);
	}

void BMTex::ReloadBitmap() { FUNC_ENTER("BMTex::ReloadBitmap"); 
	if (thebm) {

		loadFailed = FALSE;
		FreeBitmap(); 
		LoadBitmap(GetCOREInterface()->GetTime(), TRUE, TRUE);
		TheManager->LoadInto(&bi,&thebm,TRUE);		

		// Update the width/height static text description
		PBBitmap bm( bi );
		pblock->SetValue( bmtex_bitmap_ps2, GetCOREInterface()->GetTime(), &bm );

		}
	else {
		loadFailed = FALSE;
		TimeValue t;
		t = GetCOREInterface()->GetTime();
		LoadBitmap(t);
		}	

	// Update the width/height static text description of the ngc/xbox textures
	PBBitmap *temp_pbm;	
	BitmapInfo temp_bi;
	BMMRES status = BMMRES_SUCCESS;
	
	pblock->GetValue( bmtex_bitmap_ngc, 0, temp_pbm, ivalid );
	if( temp_pbm != NULL )   
	{
		temp_bi = temp_pbm->bi;	  //DS 2/24/99
	}
	else 
	{
		temp_bi.SetName(_T(""));   // DS 3/23/99
	}

	Bitmap* temp_bm = TheManager->Load(&temp_bi,&status);
	temp_bm = TheManager->Load(&temp_bi,&status);
	status = temp_bm->GoTo( &temp_bi );
	TheManager->LoadInto(&temp_bi,&temp_bm,TRUE);
	if( temp_bm ) 
	{
		PBBitmap pbm( temp_bi );	
	    pblock->SetValue( bmtex_bitmap_ngc, 0, &pbm );
	}

	pblock->GetValue( bmtex_bitmap_xbox, 0, temp_pbm, ivalid );
	if( temp_pbm != NULL )   
	{
		temp_bi = temp_pbm->bi;	  //DS 2/24/99
	}
	else 
	{
		temp_bi.SetName(_T(""));   // DS 3/23/99
	}

	temp_bm = TheManager->Load(&temp_bi,&status);
	if( temp_bm ) 
	{
		temp_bm->DeleteThis();
	}

	temp_bm = TheManager->Load(&temp_bi,&status);
	if( temp_bm ) 
	{
		PBBitmap pbm( temp_bi );	
	    pblock->SetValue( bmtex_bitmap_xbox, 0, &pbm );
	}


	//pblock->GetValue( bmtex_bitmap_ngc, GetCOREInterface()->GetTime(), bm, ivalid );
	

	//pblock->GetValue( bmtex_bitmap_xbox, GetCOREInterface()->GetTime(), bm, ivalid );
	//pblock->SetValue( bmtex_bitmap_xbox, GetCOREInterface()->GetTime(), bm );	

	//bmtex_bitmap_mip_1_ps2,
	//bmtex_bitmap_mip_2_ps2,
	//bmtex_bitmap_mip_3_ps2,
	//bmtex_bitmap_mip_4_ps2,
	//bmtex_bitmap_mip_5_ps2,

	//bmtex_bitmap_mip_1_ngc,
	//bmtex_bitmap_mip_2_ngc,
	//bmtex_bitmap_mip_3_ngc,
	//bmtex_bitmap_mip_4_ngc,
	//bmtex_bitmap_mip_5_ngc,

	//bmtex_bitmap_mip_1_xbox,
	//bmtex_bitmap_mip_2_xbox,
	//bmtex_bitmap_mip_3_xbox,
	//bmtex_bitmap_mip_4_xbox,
	//bmtex_bitmap_mip_5_xbox,


	//DS:  10/19/99: update path name on button in case it has changed ( fix for #196020)
	IParamMap2* pmap = pblock->GetMap();
	if (pmap != NULL)
		pmap->SetText(bmtex_bitmap_ps2, (char *)bi.Name());


	if (paramDlg) 
		paramDlg->EnableAlphaButtons(FALSE);

	}


void BMTex::DiscardTexHandle() { FUNC_ENTER("BMTex::DiscardTexHandle"); 
	if (texHandle) {
		texHandle->DeleteThis();
		texHandle = NULL;
		}
	}

void BMTex::ActivateTexDisplay(BOOL onoff) { FUNC_ENTER("BMTex::ActivateTexDisplay"); 
	if (!onoff) 
		DiscardTexHandle();
	}

static BMM_Color_64 black64 = {0,0,0,0};


BITMAPINFO* BMTex::GetVPDisplayDIB(TimeValue t, TexHandleMaker& thmaker, Interval &valid, BOOL mono, BOOL forceW, BOOL forceH) { FUNC_ENTER("BMTex::GetVPDisplayDIB");    
	LoadBitmap(t);
	valid = clipValid;
	if (thebm==NULL) {
		return NULL;
		}
	BITMAPINFO *bmi = NULL;
	int xflags = premultAlpha?0:EX_MULT_ALPHA;
	if (applyCrop) {
		int w = thebm->Width();
		int h = thebm->Height();
		Bitmap *newBM;
		BitmapInfo bif;
		bif.SetName(_T("y8798734"));
		bif.SetType(BMM_TRUE_32);
   		bif.SetFlags(MAP_HAS_ALPHA);
		if (placeImage) {
			int x0,y0,nw,nh;
			int bmw = thmaker.Size();
			int bmh = int(float(bmw)*float(h)/float(w));
			bif.SetWidth(bmw);
			bif.SetHeight(bmh);
			newBM = TheManager->Create(&bif);
		 	newBM->Fill(0,0,0,0);
			nw = int(float(bmw)*clipw);
			nh = int(float(bmh)*cliph);
			x0 = int(float(bmw-1)*clipu);
			y0 = int(float(bmh-1)*clipv);

			if (nw<1) nw = 1;
			if (nh<1) nh = 1;
			PixelBuf row(nw);
			
			Bitmap *tmpBM;
			BitmapInfo bif2;
			bif2.SetName(_T("xxxx67878"));
			bif2.SetType(BMM_TRUE_32);
			bif2.SetFlags(MAP_HAS_ALPHA);
			bif2.SetWidth(nw);				
			bif2.SetHeight(nh);
			tmpBM = TheManager->Create(&bif2);
			tmpBM->CopyImage(thebm, COPY_IMAGE_RESIZE_LO_QUALITY, 0);
			BMM_Color_64*  p1 = row.Ptr();
			for (int y = 0; y<nh; y++) {
				tmpBM->GetLinearPixels(0,y, nw, p1);
				if ((mono&&alphaAsMono)||(alphaAsRGB)) {
					for (int ix =0; ix<nw; ix++) 
						p1[ix].r = p1[ix].g = p1[ix].b = p1[ix].a;
					}
				//if (alphaSource==ALPHA_NONE||premultAlpha) {
				if (alphaSource==ALPHA_NONE) {
					for (int ix =0; ix<nw; ix++) 
						p1[ix].a = 0xffff;
					}
				else if (alphaSource==ALPHA_RGB) {
					for (int ix =0; ix<nw; ix++) 
						p1[ix].a = (p1[ix].r+p1[ix].g+p1[ix].b)/3;;
					}

				newBM->PutPixels(x0,y+y0, nw, p1);
				}
			tmpBM->DeleteThis();
//			texHandle = thmaker.CreateHandle(newBM,uvGen->SymFlags(), xflags);
			bmi = thmaker.BitmapToDIB(newBM,uvGen->SymFlags(), xflags, forceW, forceH);
			newBM->DeleteThis();
			}
		else {
			int x0,y0,nw,nh;
			nw = int(float(w)*clipw);
			nh = int(float(h)*cliph);
			x0 = int(float(w-1)*clipu);
			y0 = int(float(h-1)*clipv);
			if (nw<1) nw = 1;
			if (nh<1) nh = 1;
			bif.SetWidth(nw);
			bif.SetHeight(nh);
			PixelBuf row(nw);
			newBM = TheManager->Create(&bif);
			BMM_Color_64*  p1 = row.Ptr();
			for (int y = 0; y<nh; y++) {
				thebm->GetLinearPixels(x0,y+y0, nw, p1);
				if ((mono&&alphaAsMono)||(alphaAsRGB)) {
					for (int ix =0; ix<nw; ix++) 
						p1[ix].r = p1[ix].g = p1[ix].b = p1[ix].a;
					}
//					if (alphaSource==ALPHA_NONE||premultAlpha) {
				if (alphaSource==ALPHA_NONE) {
					for (int ix =0; ix<nw; ix++) 
						p1[ix].a = 0xffff;
					}
				else if (alphaSource==ALPHA_RGB) {
					for (int ix =0; ix<nw; ix++) 
						p1[ix].a = (p1[ix].r+p1[ix].g+p1[ix].b)/3;;
					}
				newBM->PutPixels(0,y, nw, p1);
				}
//			texHandle = thmaker.CreateHandle(newBM,uvGen->SymFlags(), xflags);
			bmi = thmaker.BitmapToDIB(newBM,uvGen->SymFlags(), xflags, forceW, forceH);
			newBM->DeleteThis();
			}
		}
	else {
		if (mono&&alphaAsMono) xflags |= EX_RGB_FROM_ALPHA;
		if (alphaAsRGB) xflags |= EX_RGB_FROM_ALPHA;
		if (alphaSource==ALPHA_NONE) xflags |= EX_OPAQUE_ALPHA;
		if (alphaSource==ALPHA_RGB) xflags |= EX_ALPHA_FROM_RGB;
//		texHandle = thmaker.CreateHandle(thebm,uvGen->SymFlags(), xflags);
		bmi = thmaker.BitmapToDIB(thebm,uvGen->SymFlags(), xflags, forceW, forceH);

		}
	return bmi;
	}

DWORD_PTR BMTex::GetActiveTexHandle(TimeValue t, TexHandleMaker& thmaker) { FUNC_ENTER("BMTex::GetActiveTexHandle"); 
	if (texHandle&&texTime==CalcFrame(t)&&texValid.InInterval(t)) 
		return texHandle->GetHandle();
	else {
		DiscardTexHandle();  
		texTime = CalcFrame(t);
		texHandle = thmaker.MakeHandle(GetVPDisplayDIB(t,thmaker,texValid));  
		return texHandle->GetHandle();
		}
	}

/*
DWORD_PTR BMTex::GetActiveTexHandle(TimeValue t, TexHandleMaker& thmaker) {
	if (texHandle&&texTime==CalcFrame(t)&&texValid.InInterval(t)) 
		return texHandle->GetHandle();
	else {
		DiscardTexHandle();  // DS 9/9/96
		if (fileNotFound) 
			return 0;
		LoadBitmap(t);
		if (thebm==NULL) {
//			if (!loadFailed) {
//				TSTR fname;
//				GetBMName(bi,fname);
//				LoadFailedMsg(fname.data());
//				loadFailed = TRUE;
//				}
			return 0;
			}
		texTime = CalcFrame(t);
		texValid = clipValid;
		int xflags = premultAlpha?0:EX_MULT_ALPHA;
		if (applyCrop) {
			int w = thebm->Width();
			int h = thebm->Height();
			Bitmap *newBM;
			BitmapInfo bif;
			bif.SetName(_T("y8798734"));
			bif.SetType(BMM_TRUE_32);
	   		bif.SetFlags(MAP_HAS_ALPHA);
			if (placeImage) {
				int x0,y0,nw,nh;
				int bmw = thmaker.Size();
				int bmh = int(float(bmw)*float(h)/float(w));
				bif.SetWidth(bmw);
				bif.SetHeight(bmh);
				newBM = TheManager->Create(&bif);
			 	newBM->Fill(0,0,0,0);
				nw = int(float(bmw)*clipw);
				nh = int(float(bmh)*cliph);
				x0 = int(float(bmw-1)*clipu);
				y0 = int(float(bmh-1)*clipv);

				if (nw<1) nw = 1;
				if (nh<1) nh = 1;
				PixelBuf row(nw);
				
				Bitmap *tmpBM;
				BitmapInfo bif2;
				bif2.SetName(_T("xxxx67878"));
				bif2.SetType(BMM_TRUE_32);
				bif2.SetFlags(MAP_HAS_ALPHA);
				bif2.SetWidth(nw);				
				bif2.SetHeight(nh);
				tmpBM = TheManager->Create(&bif2);
				tmpBM->CopyImage(thebm, COPY_IMAGE_RESIZE_LO_QUALITY, 0);
				BMM_Color_64*  p1 = row.Ptr();
				for (int y = 0; y<nh; y++) {
					tmpBM->GetLinearPixels(0,y, nw, p1);
					if (alphaAsRGB) {
						for (int ix =0; ix<nw; ix++) 
							p1[ix].r = p1[ix].g = p1[ix].b = p1[ix].a;
						}
					//if (alphaSource==ALPHA_NONE||premultAlpha) {
					if (alphaSource==ALPHA_NONE) {
						for (int ix =0; ix<nw; ix++) 
							p1[ix].a = 0xffff;
						}
					else if (alphaSource==ALPHA_RGB) {
						for (int ix =0; ix<nw; ix++) 
							p1[ix].a = (p1[ix].r+p1[ix].g+p1[ix].b)/3;;
						}
					newBM->PutPixels(x0,y+y0, nw, p1);
					}
				tmpBM->DeleteThis();
				texHandle = thmaker.CreateHandle(newBM,uvGen->SymFlags(), xflags);
				newBM->DeleteThis();
				}
			else {
				int x0,y0,nw,nh;
				nw = int(float(w)*clipw);
				nh = int(float(h)*cliph);
				x0 = int(float(w-1)*clipu);
				y0 = int(float(h-1)*clipv);
				if (nw<1) nw = 1;
				if (nh<1) nh = 1;
				bif.SetWidth(nw);
				bif.SetHeight(nh);
				PixelBuf row(nw);
				newBM = TheManager->Create(&bif);
				BMM_Color_64*  p1 = row.Ptr();
				for (int y = 0; y<nh; y++) {
					thebm->GetLinearPixels(x0,y+y0, nw, p1);
					if (alphaAsRGB) {
						for (int ix =0; ix<nw; ix++) 
							p1[ix].r = p1[ix].g = p1[ix].b = p1[ix].a;
						}
//					if (alphaSource==ALPHA_NONE||premultAlpha) {
					if (alphaSource==ALPHA_NONE) {
						for (int ix =0; ix<nw; ix++) 
							p1[ix].a = 0xffff;
						}
					else if (alphaSource==ALPHA_RGB) {
						for (int ix =0; ix<nw; ix++) 
							p1[ix].a = (p1[ix].r+p1[ix].g+p1[ix].b)/3;;
						}
					newBM->PutPixels(0,y, nw, p1);
					}
				texHandle = thmaker.CreateHandle(newBM,uvGen->SymFlags(), xflags);
				newBM->DeleteThis();
				}
			}
		else {
			if (alphaAsRGB) xflags |= EX_RGB_FROM_ALPHA;
			if (alphaSource==ALPHA_NONE) xflags |= EX_OPAQUE_ALPHA;
			if (alphaSource==ALPHA_RGB) xflags |= EX_ALPHA_FROM_RGB;
			texHandle = thmaker.CreateHandle(thebm,uvGen->SymFlags(), xflags);
			}
		return texHandle->GetHandle();
		}
	}
*/

							 
//----------------------------------------------------------- 

AColor BMTex::EvalColor(ShadeContext& sc) { FUNC_ENTER("BMTex::EvalColor"); 
	if (!sc.doMaps) return black;
	AColor c;
	if (sc.GetCache(this,c)) 
		return c; 
	IPoint3 sp = sc.ScreenCoord();
	if (gbufID) sc.SetGBufferID(gbufID);
	if (thebm==NULL) 
		return black;
	if (alphaAsRGB)	{
		float a = texout->Filter(uvGen->EvalUVMapMono(sc,&alphasamp,filterType!=FILTER_NADA));
		c = AColor(a,a,a,a);
		}
	else {
		c = texout->Filter(uvGen->EvalUVMap(sc,&mysamp,filterType!=FILTER_NADA));
		if (!premultAlpha) c= AColor(c.r*c.a, c.g*c.a, c.b*c.a, c.a);
		}
	sc.PutCache(this,c); 
	return c;
	}

float BMTex::EvalMono(ShadeContext& sc) { FUNC_ENTER("BMTex::EvalMono"); 
	if (!sc.doMaps||thebm==NULL) 
		return 0.0f;
	float f;
	if (sc.GetCache(this,f)) 
		return f; 
	if (gbufID) sc.SetGBufferID(gbufID);
	if (alphaAsMono) 
		f = texout->Filter(uvGen->EvalUVMapMono(sc,&alphasamp,filterType!=FILTER_NADA));
	else 
		f = texout->Filter(uvGen->EvalUVMapMono(sc,&mysamp,filterType!=FILTER_NADA));
	sc.PutCache(this,f); 
	return f;
	}

Point3 BMTex::EvalNormalPerturb(ShadeContext& sc) { FUNC_ENTER("BMTex::EvalNormalPerturb"); 
	Point3 dPdu, dPdv;
	Point2 dM;
	if (!sc.doMaps) return Point3(0,0,0);
	if (gbufID) sc.SetGBufferID(gbufID);
	if (thebm==NULL) 
		return Point3(0,0,0);
	uvGen->GetBumpDP(sc,dPdu,dPdv);  // get bump basis vectors
	if (alphaAsMono) 
		dM =(.01f)*uvGen->EvalDeriv(sc,&alphasamp,filterType!=FILTER_NADA);
	else 
		dM =(.01f)*uvGen->EvalDeriv(sc,&mysamp,filterType!=FILTER_NADA);

#if 0
	// Blinn's algorithm
	Point3 N = sc.Normal();
	Point3 uVec = CrossProd(N,dPdv);
	Point3 vVec = CrossProd(N,dPdu);
	return texout->Filter(-dM.x*uVec+dM.y*vVec);
#else						 
	return texout->Filter(dM.x*dPdu+dM.y*dPdv);
#endif
	}

RefTargetHandle BMTex::Clone(RemapDir &remap) { FUNC_ENTER("BMTex::Clone"); 
	BMTex *mnew = new BMTex();
	*((MtlBase*)mnew) = *((MtlBase*)this);  // copy superclass stuff
	mnew->ReplaceReference(0,remap.CloneRef(uvGen));
	mnew->ReplaceReference(1,remap.CloneRef(pblock));
	mnew->ReplaceReference(2,remap.CloneRef(texout));
	mnew->filterType  = filterType;
	mnew->alphaSource = alphaSource;
	mnew->alphaAsMono = alphaAsMono;
	mnew->alphaAsRGB  = alphaAsRGB;
	mnew->premultAlpha = premultAlpha;
	mnew->endCond     = endCond;
	mnew->applyCrop   = applyCrop;
	mnew->ivalid.SetEmpty();
	mnew->placeImage  = placeImage;
	mnew->randPlace   = randPlace;
	mnew->applyCrop   = applyCrop;
	mnew->startTime  = startTime;
	mnew->pbRate  = pbRate;
	mnew->bi = bi;
	BaseClone(this, mnew, remap);
	mnew->LoadBitmap( GetCOREInterface()->GetTime() );
	return (RefTargetHandle)mnew;
	}

ParamDlg* BMTex::CreateParamDlg(HWND hwMtlEdit, IMtlParams *imp) { FUNC_ENTER("BMTex::CreateParamDlg"); 
//	BMTexDlg *dm = new BMTexDlg(hwMtlEdit, imp, this);
//	dm->LoadDialog(TRUE);	
//	paramDlg = dm;
//	return dm;
// JBW: the main difference here is the automatic creation of a ParamDlg by the new
// ClassDesc2 function CreateParamDlgs().  This mirrors the way BeginEditParams()
// can be redirected to the ClassDesc2 for automatic ParamMap2 management.  In this 
// case a special subclass of ParamDlg, AutoMParamDlg, defined in IParamm2.h, is 
// created.  It can act as a 'master' ParamDlg to which you can add any number of 
// secondary dialogs and it will make sure all the secondary dialogs are kept 
// up-to-date and deleted as necessary.  
// Here you see we create the Coordinate, Gradient and Output ParamDlgs in the desired 
// order, and then add the Coordinate and Output dlgs as secondaries to the 
// Gradient master AutoMParamDlg so it will keep them up-to-date automatically

	// create the rollout dialogs
	uvGenDlg = uvGen->CreateParamDlg(hwMtlEdit, imp);	
	IAutoMParamDlg* masterDlg = next_tex_cd.CreateParamDlgs(hwMtlEdit, imp, this);
	//texoutDlg = texout->CreateParamDlg(hwMtlEdit, imp);
	// add the secondary dialogs to the master
	masterDlg->AddDlg(uvGenDlg);
	//masterDlg->AddDlg(texoutDlg);
	paramDlg = new BMTexDlg(hwMtlEdit,imp,this);
	bmtex_param_blk.SetUserDlgProc(paramDlg);
	ip = imp;
	EnableStuff();
	return masterDlg;
	
	}

BMTex::~BMTex() { FUNC_ENTER("BMTex::~BMTex"); 
	UnRegisterNotification(BMTexNotify, this, NOTIFY_BITMAP_CHANGED);
	DiscardTexHandle();
	FreeBitmap();
	}

BOOL BMTex::SetDlgThing(ParamDlg* dlg)
{ FUNC_ENTER("BMTex::SetDlgThing"); 
	// JBW: set the appropriate 'thing' sub-object for each
	// secondary dialog
	if (paramDlg) paramDlg->SetThing(this);
	EnableStuff();

	if ((uvGenDlg!= NULL) && (dlg == uvGenDlg))
		uvGenDlg->SetThing(uvGen);
	/*else if ((texoutDlg!= NULL) && (dlg == texoutDlg))
		texoutDlg->SetThing(texout);*/
	else 
		return FALSE;
	return TRUE;

}

bool valid_bitmap( PBBitmap* bm )
{ FUNC_ENTER("valid_bitmap"); 
	if( bm == NULL )
	{
		return false;
	}

	if( stricmp( bm->bi.Name(), "None" ) == 0 )
	{
		return false;
	}

	if( stricmp( bm->bi.Name(), "Use PS2" ) == 0 )
	{
		return false;
	}

	if( ( bm->bi.Width() == 0 ) ||
		( bm->bi.Height() == 0 ))
	{
		return false;
	}
	
	return true;
}

void BMTex::Update(TimeValue t, Interval& valid) { FUNC_ENTER("BMTex::Update"); 		

	if (!ivalid.InInterval(t)) 
	{
		PBBitmap *bm;

		m_updated = true;

		uvGen->SetClipFlag(FALSE);
		ivalid.SetInfinite();
		uvGen->Update(t,ivalid);
		clipValid.SetInfinite();
		pblock->GetValue( bmcp_clipu, t, clipu, clipValid );
		pblock->GetValue( bmcp_clipv, t, clipv, clipValid );
		pblock->GetValue( bmcp_clipw, t, clipw, clipValid );
		pblock->GetValue( bmcp_cliph, t, cliph, clipValid );
		//pblock->GetValue( bmtex_jitter, t, jitter, clipValid );

		//pblock->GetValue( bmtex_filtering, t, filterType, clipValid );
		//pblock->GetValue( bmtex_alphasource, t, alphaSource, clipValid );

		if (alphaSource == 0) alphaSource  = ALPHA_FILE;
		else if (alphaSource == 1) alphaSource  = ALPHA_RGB;
		else if (alphaSource == 2) alphaSource  = ALPHA_NONE;

		//pblock->GetValue( bmtex_monooutput, t, alphaAsMono, clipValid );
		//pblock->GetValue( bmtex_rgboutput, t, alphaAsRGB, clipValid );
		//pblock->GetValue( bmtex_premultalpha, t, premultAlpha, clipValid );
		//pblock->GetValue( bmtex_usejitter, t, randPlace, clipValid );

		pblock->GetValue( bmcp_crop_place, t, placeImage, clipValid );

		pblock->GetValue( bmcp_apply, t, applyCrop, clipValid );		

		pblock->GetValue( bmtex_bitmap_use_ps2_mips_ngc, t, m_UsePS2Mips[vPLAT_NGC], ivalid );		
		pblock->GetValue( bmtex_bitmap_use_ps2_mips_xbox, t, m_UsePS2Mips[vPLAT_XBOX], ivalid );		

		pblock->GetValue( bmtex_bitmap_compress_ngc, t, m_Compress[vPLAT_NGC], ivalid );		
		pblock->GetValue( bmtex_bitmap_compress_xbox, t, m_Compress[vPLAT_XBOX], ivalid );		

		pblock->GetValue( bmtex_bitmap_truecolor_palette, t, m_Force24Bit, ivalid );		
		pblock->GetValue( bmtex_bitmap_change_trans_color, t, m_TransColor, ivalid );
		pblock->GetValue( bmtex_bitmap_change_trans, t, m_ChangeTrans, ivalid );					
		pblock->GetValue( bmtex_bitmap_mip_ps2, t, m_MipType[vPLAT_PS2], ivalid );
		pblock->GetValue( bmtex_bitmap_mip_ngc, t, m_MipType[vPLAT_NGC], ivalid );
		pblock->GetValue( bmtex_bitmap_mip_xbox, t, m_MipType[vPLAT_XBOX], ivalid );
		pblock->GetValue( bmtex_bitmap_mip_map_k, t, m_MipMapK, ivalid );
		pblock->GetValue( bmtex_bitmap_filter_mode_min, t, m_MinFilterMode, ivalid );
		pblock->GetValue( bmtex_bitmap_filter_mode_mag, t, m_MagFilterMode, ivalid );
		pblock->GetValue( bmtex_bitmap_mip_filter_mode, t, m_MipFilterMode, ivalid );

		pblock->GetValue( bmtex_bitmap_ps2, t, bm, ivalid );
		m_Bitmaps[vPLAT_PS2][0] = valid_bitmap( bm ) ? &bm->bi : NULL;
		pblock->GetValue( bmtex_bitmap_mip_1_ps2, t, bm, ivalid );
		m_Bitmaps[vPLAT_PS2][1] = valid_bitmap( bm ) ? &bm->bi : NULL;
		pblock->GetValue( bmtex_bitmap_mip_2_ps2, t, bm, ivalid );
		m_Bitmaps[vPLAT_PS2][2] = valid_bitmap( bm ) ? &bm->bi : NULL;
		pblock->GetValue( bmtex_bitmap_mip_3_ps2, t, bm, ivalid );
		m_Bitmaps[vPLAT_PS2][3] = valid_bitmap( bm ) ? &bm->bi : NULL;
		pblock->GetValue( bmtex_bitmap_mip_4_ps2, t, bm, ivalid );
		m_Bitmaps[vPLAT_PS2][4] = valid_bitmap( bm ) ? &bm->bi : NULL;
		pblock->GetValue( bmtex_bitmap_mip_5_ps2, t, bm, ivalid );
		m_Bitmaps[vPLAT_PS2][5] = valid_bitmap( bm ) ? &bm->bi : NULL;
		
		pblock->GetValue( bmtex_bitmap_ngc, t, bm, ivalid );
		m_Bitmaps[vPLAT_NGC][0] = valid_bitmap( bm ) ? &bm->bi : NULL;
		pblock->GetValue( bmtex_bitmap_mip_1_ngc, t, bm, ivalid );
		m_Bitmaps[vPLAT_NGC][1] = valid_bitmap( bm ) ? &bm->bi : NULL;
		pblock->GetValue( bmtex_bitmap_mip_2_ngc, t, bm, ivalid );
		m_Bitmaps[vPLAT_NGC][2] = valid_bitmap( bm ) ? &bm->bi : NULL;
		pblock->GetValue( bmtex_bitmap_mip_3_ngc, t, bm, ivalid );
		m_Bitmaps[vPLAT_NGC][3] = valid_bitmap( bm ) ? &bm->bi : NULL;
		pblock->GetValue( bmtex_bitmap_mip_4_ngc, t, bm, ivalid );
		m_Bitmaps[vPLAT_NGC][4] = valid_bitmap( bm ) ? &bm->bi : NULL;
		pblock->GetValue( bmtex_bitmap_mip_5_ngc, t, bm, ivalid );
		m_Bitmaps[vPLAT_NGC][5] = valid_bitmap( bm ) ? &bm->bi : NULL;				
		
		pblock->GetValue( bmtex_bitmap_xbox, t, bm, ivalid );
		m_Bitmaps[vPLAT_XBOX][0] = valid_bitmap( bm ) ? &bm->bi : NULL;
		pblock->GetValue( bmtex_bitmap_mip_1_xbox, t, bm, ivalid );
		m_Bitmaps[vPLAT_XBOX][1] = valid_bitmap( bm ) ? &bm->bi : NULL;
		pblock->GetValue( bmtex_bitmap_mip_2_xbox, t, bm, ivalid );
		m_Bitmaps[vPLAT_XBOX][2] = valid_bitmap( bm ) ? &bm->bi : NULL;
		pblock->GetValue( bmtex_bitmap_mip_3_xbox, t, bm, ivalid );
		m_Bitmaps[vPLAT_XBOX][3] = valid_bitmap( bm ) ? &bm->bi : NULL;
		pblock->GetValue( bmtex_bitmap_mip_4_xbox, t, bm, ivalid );
		m_Bitmaps[vPLAT_XBOX][4] = valid_bitmap( bm ) ? &bm->bi : NULL;
		pblock->GetValue( bmtex_bitmap_mip_5_xbox, t, bm, ivalid );
		m_Bitmaps[vPLAT_XBOX][5] = valid_bitmap( bm ) ? &bm->bi : NULL;		

		// Get the values for basemap palette usage
		pblock->GetValue( bmtex_bitmap_mip_1_ps2_pal, t, useBasePal[vPLAT_PS2][0], ivalid );
		pblock->GetValue( bmtex_bitmap_mip_2_ps2_pal, t, useBasePal[vPLAT_PS2][1], ivalid );
		pblock->GetValue( bmtex_bitmap_mip_3_ps2_pal, t, useBasePal[vPLAT_PS2][2], ivalid );
		pblock->GetValue( bmtex_bitmap_mip_4_ps2_pal, t, useBasePal[vPLAT_PS2][3], ivalid );
		pblock->GetValue( bmtex_bitmap_mip_5_ps2_pal, t, useBasePal[vPLAT_PS2][4], ivalid );

		pblock->GetValue( bmtex_bitmap_mip_1_ngc_pal, t, useBasePal[vPLAT_NGC][0], ivalid );
		pblock->GetValue( bmtex_bitmap_mip_2_ngc_pal, t, useBasePal[vPLAT_NGC][1], ivalid );
		pblock->GetValue( bmtex_bitmap_mip_3_ngc_pal, t, useBasePal[vPLAT_NGC][2], ivalid );
		pblock->GetValue( bmtex_bitmap_mip_4_ngc_pal, t, useBasePal[vPLAT_NGC][3], ivalid );
		pblock->GetValue( bmtex_bitmap_mip_5_ngc_pal, t, useBasePal[vPLAT_NGC][4], ivalid );

		pblock->GetValue( bmtex_bitmap_mip_1_xbox_pal, t, useBasePal[vPLAT_XBOX][0], ivalid );
		pblock->GetValue( bmtex_bitmap_mip_2_xbox_pal, t, useBasePal[vPLAT_XBOX][1], ivalid );
		pblock->GetValue( bmtex_bitmap_mip_3_xbox_pal, t, useBasePal[vPLAT_XBOX][2], ivalid );
		pblock->GetValue( bmtex_bitmap_mip_4_xbox_pal, t, useBasePal[vPLAT_XBOX][3], ivalid );
		pblock->GetValue( bmtex_bitmap_mip_5_xbox_pal, t, useBasePal[vPLAT_XBOX][4], ivalid );


        if (applyCrop) ivalid &= clipValid;
		else clipValid.SetInfinite();
		texout->Update(t,ivalid);


		}
	if (thebm&&!bmWasSet) {
		if (bi.FirstFrame()!=bi.LastFrame())
			{
			ivalid.SetInstant(t);  // force bitmap to be reloaded

	    // --------- BEGIN DS:11/20/00 
		// Removed the code to load the map. It was causing slowdown of viewport playback
		// even in wireframe views.  ( defect #268603. )  I didn't put this code here - I think it got
		// added as part of the PB2 conversion. It shouldn't be necessary, and as far as I can tell
		// it isnt.
//			bi.SetCurrentFrame(CalcFrame(t));  //this is here to force non render things to advance the bitmap
//			BOOL silent = TheManager->SetSilentMode(TRUE);
//			int status = thebm->GoTo(&bi);
//			TheManager->SetSilentMode(silent);
	    // ---------- END DS:11/20/00  

			}
		}
	else 
		ivalid.SetInstant(t);  // force bitmap to be reloaded 
	UpdtSampler();
	valid &= ivalid;
	}

RefTargetHandle BMTex::GetReference(int i) { FUNC_ENTER("BMTex::GetReference"); 
	switch(i) {
		case 0: return uvGen;
		case 1: return pblock;
		case 2:	return texout;
		default: return NULL;
		}
	}

int BMTex::RemapRefOnLoad(int iref) { FUNC_ENTER("BMTex::RemapRefOnLoad");  
	if (loadingOld) { 
		switch(iref) {
			case 0: return 0;
			case 1: return 2;
			default: assert(0); return 0;
			}
		}
	else return iref;
	}

void BMTex::SetReference(int i, RefTargetHandle rtarg) { FUNC_ENTER("BMTex::SetReference"); 
	switch(i) {
		case 0: uvGen = (UVGen *)rtarg; break;
		case 1: pblock = (IParamBlock2 *)rtarg; break;
		case 2:	texout = (TextureOutput *)rtarg; break;
		default: break;
		}
	}

	 
Animatable* BMTex::SubAnim(int i) { FUNC_ENTER("BMTex::SubAnim"); 
	switch (i) {
		case 0: return uvGen;
		case 1: return pblock;
		case 2: return texout;
		default: assert(0); return NULL;
		}
	}

TSTR BMTex::GetFullName() { FUNC_ENTER("BMTex::GetFullName"); 
	TSTR cnm,nm,fname;
   	GetClassName(cnm);
	UpdateBIName();   //DS 2/18/99
	GetBMName(bi,fname);
	TCHAR *s = fname.Length()>0? fname.data(): cnm.data(); 
	nm.printf(_T("%s (%s)"),GetName().data(), s);
	return nm;
	}

TSTR BMTex::SubAnimName(int i) { FUNC_ENTER("BMTex::SubAnimName"); 
	switch (i) {
		case 0: return TSTR(GetString(IDS_DS_COORDINATES));		
		case 1: return TSTR(GetString(IDS_DS_PARAMETERS));		
		case 2: return TSTR(GetString(IDS_DS_OUTPUT));		
		case 3: return TSTR(GetString(IDS_DS_PARAMETERS));		
		default: assert(0); return TSTR(_T(""));
		}
	}

RefResult BMTex::NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, 
   PartID& partID, RefMessage message ) { FUNC_ENTER("BMTex::NotifyRefChanged"); 
	switch (message) {
		case REFMSG_CHANGE:
			{
			ivalid.SetEmpty();
			if (hTarget == pblock)
				{
			// see if this message came from a changing parameter in the pblock,
			// if so, limit rollout update to the changing item and update any active viewport texture
				ParamID changing_param = pblock->LastNotifyParamID();
				bmtex_param_blk.InvalidateUI(changing_param);
				if (changing_param != -1)
					DiscardTexHandle();
				if( changing_param == bmtex_bitmap_ps2 )
				{
					PBBitmap *bm;
					HWND static_ctrl;
					char description[64];

					if( paramDlg )
					{
						bm = NULL;
						pblock->GetValue( bmtex_bitmap_ps2, 0,bm, clipValid );
						if( valid_bitmap( bm ))
						{
							sprintf( description, "%dx%d", bm->bi.Width(), bm->bi.Height());						
						}					
						else
						{
							sprintf( description, "" );
						}

						static_ctrl = GetDlgItem( paramDlg->hPanel, IDC_BITMAP_DETAILS_PS2 );
						if( static_ctrl )
						{
							SetWindowText( static_ctrl, description );
						}
					}
				}
				else if( changing_param == bmtex_bitmap_ngc )
				{
					PBBitmap *bm;
					HWND static_ctrl;
					char description[64];

					if( paramDlg )
					{
						bm = NULL;
						pblock->GetValue( bmtex_bitmap_ngc, 0,bm, clipValid );
						if( valid_bitmap( bm ))
						{
							sprintf( description, "%dx%d", bm->bi.Width(), bm->bi.Height());
						}
						else
						{
							sprintf( description, "" );
						}
							
						static_ctrl = GetDlgItem( paramDlg->hPanel, IDC_BITMAP_DETAILS_NGC );
						if( static_ctrl )
						{
							SetWindowText( static_ctrl, description );
						}					
					}
				}
				else if( changing_param == bmtex_bitmap_xbox )
				{
					PBBitmap *bm;
					HWND static_ctrl;
					char description[64];

					if( paramDlg )
					{
						bm = NULL;
						pblock->GetValue( bmtex_bitmap_xbox, 0,bm, clipValid );
						if( valid_bitmap( bm ))
						{
							sprintf( description, "%dx%d", bm->bi.Width(), bm->bi.Height());
						}
						else
						{
							sprintf( description, "" );
						}
							
						static_ctrl = GetDlgItem( paramDlg->hPanel, IDC_BITMAP_DETAILS_XBOX );
						if( static_ctrl )
						{
							SetWindowText( static_ctrl, description );
						}					
					}
				}

				if(	( changing_param == bmtex_bitmap_ps2 ) ||
					( changing_param == bmtex_bitmap_ngc ) ||
					( changing_param == bmtex_bitmap_xbox ))
				{
					PBBitmap *bm_ps2, *bm_ngc, *bm_xbox;					

					bm_ps2 = NULL;
					bm_ngc = NULL;
					bm_xbox = NULL;
					pblock->GetValue( bmtex_bitmap_ps2, 0, bm_ps2, clipValid );
					pblock->GetValue( bmtex_bitmap_ngc, 0, bm_ngc, clipValid );
					pblock->GetValue( bmtex_bitmap_xbox, 0, bm_xbox, clipValid );
					if( bm_ps2 && paramDlg )
					{
						HWND use_ps2_checkbox;
						TSTR ps2_name, ngc_name, xbox_name;
						
						ps2_name = bm_ps2->bi.Name();
						ngc_name = ps2_name;
						xbox_name = ps2_name;

						if( bm_ngc && ( bm_ngc->bi.Width() > 0 ) && ( bm_ngc->bi.Height() > 0 ))
						{
							ngc_name = bm_ngc->bi.Name();							
						}
						if( bm_xbox && ( bm_xbox->bi.Width() > 0 ) && ( bm_xbox->bi.Height() > 0 ))
						{
							xbox_name = bm_xbox->bi.Name();							
						}
						
						use_ps2_checkbox = GetDlgItem( paramDlg->hPanel, IDC_USE_PS2_MIPMAPS_NGC );
						
						if( ngc_name == ps2_name )
						{
							EnableWindow( use_ps2_checkbox, TRUE );
						}
						else
						{	
							HWND win;

							pblock->SetValue( bmtex_bitmap_use_ps2_mips_ngc, 0, FALSE );
							EnableWindow( use_ps2_checkbox, FALSE );

							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_NAME_1_NGC );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_NAME_2_NGC );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_NAME_3_NGC );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_NAME_4_NGC );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_NAME_5_NGC );
							EnableWindow( win, TRUE );

							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_1_NGC_CLEAR );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_2_NGC_CLEAR );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_3_NGC_CLEAR );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_4_NGC_CLEAR );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_5_NGC_CLEAR );
							EnableWindow( win, TRUE );
						}

						use_ps2_checkbox = GetDlgItem( paramDlg->hPanel, IDC_USE_PS2_MIPMAPS_XBOX );
						if( xbox_name == ps2_name )
						{
							EnableWindow( use_ps2_checkbox, TRUE );
						}
						else
						{			
							HWND win;

							pblock->SetValue( bmtex_bitmap_use_ps2_mips_xbox, 0, FALSE );
							EnableWindow( use_ps2_checkbox, FALSE );

							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_NAME_1_XBOX );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_NAME_2_XBOX );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_NAME_3_XBOX );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_NAME_4_XBOX );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_NAME_5_XBOX );
							EnableWindow( win, TRUE );

							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_1_XBOX_CLEAR );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_2_XBOX_CLEAR );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_3_XBOX_CLEAR );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_4_XBOX_CLEAR );
							EnableWindow( win, TRUE );
							win = GetDlgItem( paramDlg->hPanel, IDC_BMTEX_MIP_5_XBOX_CLEAR );
							EnableWindow( win, TRUE );
						}
					}
				}
//				if (changing_param == bmtex_bitmap_ps2)
//					FreeBitmap();
				}

			break;
			}
		case REFMSG_UV_SYM_CHANGE:
			DiscardTexHandle();  
			break;
		}
	return(REF_SUCCEED);
	}



//------------------------------------------------------------------------
// IO
//------------------------------------------------------------------------

class BMTexPostLoad : public PostLoadCallback {
	public:
		BMTex *chk;
		BMTexPostLoad(BMTex *b) {chk=b;}
		void proc(ILoad *iload) {
			chk->loadingOld = FALSE;
			if (chk->bmName.Length()>0) {
				chk->bi.SetName(chk->bmName);   // for obsolete files	
				iload->SetObsolete();
				}
			delete this;
			}
	};

#define MTL_HDR_CHUNK 0x4000
#define OLDBMTEX_NAME_CHUNK 0x5001
#define BMTEX_FILTER_CHUNK 0x5002
#define BMTEX_ALPHASOURCE_CHUNK 0x5003
#define BMTEX_NAME_CHUNK 0x5004
#define BMTEX_IO_CHUNK 0x5010
#define BMTEX_START_CHUNK 0x5011
#define BMTEX_RATE_CHUNK 0x5012
#define BMTEX_ALPHA_MONO_CHUNK 0x5013
#define BMTEX_ENDCOND_CHUNK 0x5014
#define BMTEX_ALPHA_RGB_CHUNK 0x5016
#define BMTEX_VERSOLD_CHUNK 0x5021
#define BMTEX_VERSION_CHUNK 0x5022
#define BMTEX_ALPHA_NOTPREMULT_CHUNK 0x5030
#define BMTEX_CLIP_CHUNK 0x5040
#define BMTEX_PLACE_IMAGE_CHUNK 0x5050
#define BMTEX_JITTER_CHUNK 0x5060

IOResult BMTex::Save(ISave *isave) { FUNC_ENTER("BMTex::Save");  
//	ULONG nb;
	IOResult res;
	// Save common stuff
	isave->BeginChunk(MTL_HDR_CHUNK);
	res = MtlBase::Save(isave);
	if (res!=IO_OK) return res;
	isave->EndChunk();
	return IO_OK;
	}	


class BMTex2PostLoad : public PostLoadCallback {
	public:
		BMTex *n;
		BOOL isParam2;
		BMTex2PostLoad(BMTex *ns, BOOL b) {n = ns;isParam2 = b;}
		void proc(ILoad *iload) {  

			if (!isParam2)
				{
				macroRecorder->Disable();
				//n->pblock->SetValue( bmtex_filtering, 0, n->filterType);
				if (n->alphaSource == ALPHA_FILE) n->alphaSource  = 0;
					else if (n->alphaSource == ALPHA_RGB) n->alphaSource  = 1;
					else if (n->alphaSource == ALPHA_NONE) n->alphaSource  = 2;

				//n->pblock->SetValue( bmtex_alphasource, 0, n->alphaSource);


				//n->pblock->SetValue( bmtex_monooutput, 0, n->alphaAsMono );
				//n->pblock->SetValue( bmtex_rgboutput, 0, n->alphaAsRGB );
				//n->pblock->SetValue( bmtex_premultalpha, 0, n->premultAlpha);
				//n->pblock->SetValue( bmtex_usejitter, 0, n->randPlace );

				n->pblock->SetValue( bmcp_crop_place, 0, n->placeImage);

				n->pblock->SetValue( bmcp_apply, 0, n->applyCrop);

				PBBitmap bPB(n->bi);
				n->loading = TRUE;
				n->pblock->SetValue( bmtex_bitmap_ps2, 0, &bPB);
				n->loading = FALSE;

                macroRecorder->Enable();

				}
			delete this; 


			} 
	};


IOResult BMTex::Load(ILoad *iload) { FUNC_ENTER("BMTex::Load");  
	ULONG nb;
	IOResult res;
	bmName.Resize(0);
	//iload->RegisterPostLoadCallback(new ParamBlockPLCB(oldVersions, 3, &curVersion, this,1));
	while (IO_OK==(res=iload->OpenChunk())) {
		switch(iload->CurChunkID())  {
			case MTL_HDR_CHUNK:
				res = MtlBase::Load(iload);
				break;
			case BMTEX_VERSOLD_CHUNK:
				loadingOld = TRUE;
				break;
			case BMTEX_FILTER_CHUNK:
				iload->Read(&filterType,sizeof(filterType),&nb);			
				isParm2 = FALSE;
				break;
			case BMTEX_ALPHASOURCE_CHUNK:
				isParm2 = FALSE;
				iload->Read(&alphaSource,sizeof(alphaSource),&nb);			
				break;
			case BMTEX_NAME_CHUNK:
				isParm2 = FALSE;
				TCHAR *buf;
				if (IO_OK==iload->ReadWStringChunk(&buf)) 
					bmName = buf;					
				break;
			case BMTEX_IO_CHUNK:
				isParm2 = FALSE;
				res = bi.Load(iload);
				// DS 7/18/96 - This is to handle old files 
				// that had the bi saved with start = end = 0, 
				// which now screws up animation.
				bi.SetStartFrame(BMM_UNDEF_FRAME);
				bi.SetEndFrame(BMM_UNDEF_FRAME);
				break;
			case BMTEX_START_CHUNK:
				isParm2 = FALSE;
				iload->Read(&startTime,sizeof(startTime),&nb);			
				break;
			case BMTEX_RATE_CHUNK:
				isParm2 = FALSE;
				iload->Read(&pbRate,sizeof(pbRate),&nb);			
				break;
			case BMTEX_ALPHA_MONO_CHUNK:
				isParm2 = FALSE;
				alphaAsMono = TRUE;
				break;
			case BMTEX_ALPHA_RGB_CHUNK:
				isParm2 = FALSE;
				alphaAsRGB = TRUE;
				break;
			case BMTEX_ALPHA_NOTPREMULT_CHUNK:
				isParm2 = FALSE;
				premultAlpha = FALSE;
				break;
			case BMTEX_ENDCOND_CHUNK:
				isParm2 = FALSE;
				iload->Read(&endCond,sizeof(endCond),&nb);			
				break;
			case BMTEX_CLIP_CHUNK:
				isParm2 = FALSE;
				applyCrop = TRUE;
				break;
			case BMTEX_PLACE_IMAGE_CHUNK:
				isParm2 = FALSE;
				placeImage = TRUE;
				break;
			case BMTEX_JITTER_CHUNK:
				isParm2 = FALSE;
				randPlace = TRUE;
				break;
			}
		iload->CloseChunk();
		if (res!=IO_OK) 
			return res;
		}
	if (alphaSource<0||alphaSource>ALPHA_NONE) 
		alphaSource = ALPHA_FILE;


	if (!isParm2)
		{
		//ParamBlock2PLCB* plcb = new ParamBlock2PLCB( oldVersions, NUMOLDVERSIONS, &bmtex_param_blk, this, 1);
		//iload->RegisterPostLoadCallback(plcb);

		//BMTex2PostLoad *bmt2PLCB = new BMTex2PostLoad(this,isParm2);
		//iload->RegisterPostLoadCallback(bmt2PLCB);
		}
	


	return IO_OK;
	}

void BMTex::SetBitmap(Bitmap *bm) { FUNC_ENTER("BMTex::SetBitmap"); 
	FreeBitmap(); 
	thebm = bm;
	bmWasSet = thebm?TRUE:FALSE;
	}

#define PROPID_SETBITMAP 0x111

int BMTex::SetProperty(ULONG id, void *data)
	{ FUNC_ENTER("BMTex::SetProperty"); 
	switch (id) {
		case PROPID_CLEARCACHES:
			FreeBitmap();
			return 1;
		case PROPID_SETBITMAP: 
			SetBitmap((Bitmap *)data);
			return 1;

		default: return 0;
		}
	}



void BMTex::BitmapLoadDlg()	{ FUNC_ENTER("BMTex::BitmapLoadDlg"); 
	//BOOL silent = TheManager->SetSilentMode(TRUE);
	HWND hpanel = GetCOREInterface()->GetMAXHWnd();
	BOOL res = TheManager->SelectFileInputEx(&bi, hpanel, GetString(IDS_DS_SELECT_BMFILE));
	//TheManager->SetSilentMode(silent);
	
	//load into param block
	if (res) {
		PBBitmap bt(bi);
		loading = 1;  // disable accessor
		pblock->SetValue(bmtex_bitmap_ps2, 0, &bt);
		loading = 0;
		FreeBitmap();   // DS 9/25/00   
		ReloadBitmap(); // DS 9/25/00  -- this is to fix #254986
		}
	}

//watje forces the bitmap to reload and view to be redrawn
void BMTex::ReloadBitmapAndUpdate()
	{ FUNC_ENTER("BMTex::ReloadBitmapAndUpdate"); 
	FreeBitmap();
	ReloadBitmap();
	fileNotFound = FALSE; // DS 4/20/99 
	if (TestMtlFlag(MTL_TEX_DISPLAY_ENABLED)) {
		if (ip)
			ip->MtlChanged();
		}
	}


void BMTex::fnReload()
{ FUNC_ENTER("BMTex::fnReload"); 
	ReloadBitmap();
	BroadcastNotification(NOTIFY_BITMAP_CHANGED, (void *)bi.Name());
	if (ip) ip->MtlChanged();
	if ((ip) && (paramDlg)) paramDlg->Invalidate();  // incase path of map has changed.

}

void BMTex::fnViewImage()
{ FUNC_ENTER("BMTex::fnViewImage"); 
if ((ip) && (paramDlg)) paramDlg->ShowCropImage();
}

bool	BMTex::Force24BitPalette( void )
{ FUNC_ENTER("BMTex::Force24BitPalette"); 
	return ( m_Force24Bit == TRUE );
}

void	BMTex::SetForce24BitPalette( bool bMode )
{ FUNC_ENTER("BMTex::SetForce24BitPalette");
	
	pblock->SetValue( bmtex_bitmap_truecolor_palette, 0, bMode );
	m_Force24Bit = bMode;
}

bool	BMTex::ShouldCompress( int platform )
{ FUNC_ENTER("BMTex::ShouldCompress"); 
	return ( m_Compress[ platform ] == TRUE );
}

void	BMTex::SetShouldCompress( int platform, bool bMode )
{ FUNC_ENTER("BMTex::SetShouldCompress");
	
	switch(platform)
	{
	case vPLAT_PS2:
		OutputDebugString("BMTex::SetShouldCompress:  PS2 Platform unsupported\n");
		break;

	case vPLAT_NGC:
		pblock->SetValue( bmtex_bitmap_compress_ngc, 0, bMode );
		m_Compress[vPLAT_NGC] = bMode;
		break;

	case vPLAT_XBOX:
		pblock->SetValue( bmtex_bitmap_compress_xbox, 0, bMode );
		m_Compress[vPLAT_XBOX] = bMode;
		break;
	}
}

int		BMTex::GetMipType( int platform )
{ FUNC_ENTER("BMTex::GetMipType"); 
	return m_MipType[ platform ];
}

void	BMTex::SetMipType( int platform, int miptype )
{ FUNC_ENTER("BMTex::SetMipType");

	switch(platform)
	{
	case vPLAT_PS2:
		pblock->SetValue( bmtex_bitmap_mip_ps2, 0, miptype );
		m_MipType[vPLAT_PS2] = miptype;
		break;

	case vPLAT_NGC:
		pblock->SetValue( bmtex_bitmap_mip_ngc, 0, miptype );
		m_MipType[vPLAT_NGC] = miptype;
		break;

	case vPLAT_XBOX:
		pblock->SetValue( bmtex_bitmap_mip_xbox, 0, miptype );
		m_MipType[vPLAT_XBOX] = miptype;
		break;
	}
}

bool	BMTex::UsePS2Mips( int platform )
{ FUNC_ENTER("BMTex::UsePS2Mips"); 
	return ( m_UsePS2Mips[ platform ] == TRUE );
}

void	BMTex::SetUsePS2Mips( int platform, bool bMode )
{ FUNC_ENTER("BMTex::SetUsePS2Mips");
	
	switch(platform)
	{
	case vPLAT_PS2:
		OutputDebugString("BMTex::SetUsePS2Mips:  Can't specify PS2 platform\n");
		break;

	case vPLAT_NGC:
		pblock->SetValue( bmtex_bitmap_use_ps2_mips_ngc, 0, bMode );
		m_UsePS2Mips[vPLAT_NGC] = bMode;
		break;

	case vPLAT_XBOX:
		pblock->SetValue( bmtex_bitmap_use_ps2_mips_xbox, 0, bMode );
		m_UsePS2Mips[vPLAT_XBOX] = bMode;
		break;
	}
}

int		BMTex::GetMinFilterMode( void )
{ FUNC_ENTER("BMTex::GetMinFilterMode"); 
	return m_MinFilterMode;
}

void	BMTex::SetMinFilterMode( int filterMode )
{ FUNC_ENTER("BMTex::SetMinFilterMode");

	pblock->SetValue( bmtex_bitmap_filter_mode_min, 0, filterMode );
	m_MinFilterMode = filterMode;
}

int		BMTex::GetMagFilterMode( void )
{ FUNC_ENTER("BMTex::GetMagFilterMode"); 
	return m_MagFilterMode;
}

void	BMTex::SetMagFilterMode( int filterMode )
{ FUNC_ENTER("BMTex::SetMagFilterMode");
	
	pblock->SetValue( bmtex_bitmap_filter_mode_mag, 0, filterMode );
	m_MagFilterMode = filterMode;
}

int		BMTex::GetMipFilterMode( void )
{ FUNC_ENTER("BMTex::GetMipFilterMode"); 
	return m_MipFilterMode;
}

void	BMTex::SetMipFilterMode( int filterMode )
{ FUNC_ENTER("BMTex::SetMipFilterMode");

	pblock->SetValue( bmtex_bitmap_mip_filter_mode, 0, filterMode );
	m_MipFilterMode = filterMode;
}

int		BMTex::GetAddressModeU( void )
{ FUNC_ENTER("BMTex::GetAddressModeU"); 
	StdUVGen *uv = GetUVGen();
	
	if( uv->GetTextureTiling() & U_WRAP )
	{
		return NxMaterial::vADDRESS_MODE_REPEAT;
	}

	return NxMaterial::vADDRESS_MODE_CLAMP;
}

int		BMTex::GetAddressModeV( void )
{ FUNC_ENTER("BMTex::GetAddressModeV"); 
	StdUVGen *uv = GetUVGen();
	
	if( uv->GetTextureTiling() & V_WRAP )
	{
		return NxMaterial::vADDRESS_MODE_REPEAT;
	}

	return NxMaterial::vADDRESS_MODE_CLAMP;
}

BitmapInfo*	BMTex::GetBaseMap( int platform, bool allow_mips )
{ FUNC_ENTER("BMTex::GetBaseMap"); 
	if( !m_updated )
	{
		Update( 0, FOREVER );
	}
	// If no map is specified for a platform, fall back on the PS2's base map
	if( m_Bitmaps[ platform ][ 0 ] == NULL && 
		                  platform != vPLAT_PS2)
	{
		if ( allow_mips && (GetMipType( platform ) == vMIP_TYPE_AUTO))
		{
			// We want to use generated maps for XBOX and NGC textures if not overidden
			if (CStr(biTexName[ platform - 1 ].Name()).Length() > 0)
				return &biTexName[ platform - 1 ];
			else
			{
				// Undefined XBOX textures should revert to 32-bit NGC texture override
				if (platform == vPLAT_XBOX &&
					CStr(biTexName[ vPLAT_NGC - 1 ].Name()).Length() > 0)
					return &biTexName[ vPLAT_NGC - 1 ];

				if (platform == vPLAT_NGC &&
					CStr(biTexName[ vPLAT_XBOX - 1 ].Name()).Length() > 0)
					return &biTexName[ vPLAT_XBOX - 1 ];
			}
		}

		// If none of these is the case default to the PS2 texture		
		return m_Bitmaps[ vPLAT_PS2 ][ 0 ];
	}

	return m_Bitmaps[ platform ][ 0 ];
}

bool	BMTex::SetBaseMap( int platform, BitmapInfo* bmi )
{ FUNC_ENTER("BMTex::SetBaseMap");

	ParamID id;

	switch(platform)
	{
	case vPLAT_PS2:
		id = bmtex_bitmap_ps2;
		break;

	case vPLAT_NGC:
		id = bmtex_bitmap_ngc;
		break;

	case vPLAT_XBOX:
		id = bmtex_bitmap_xbox;
		break;
	}

	// Assign bitmap
	PBBitmap* bm = NULL;

	//pblock->GetValue( id, 0, bm, ivalid );
	
	// Free current bitmap
	//if (bm)
	//	delete bm;

	bm = new PBBitmap;
	bm->bi = *bmi;

	BMMRES status;
	if (_stricmp(bm->bi.Name(), "none") != 0)
	{
		bm->bm = TheManager->Load(&bm->bi, &status);

		if (status != BMMRES_SUCCESS)
		{
			MessageBox(gInterface->GetMAXHWnd(), "Failed to open bitmap", "BMTex::SetBaseMap", MB_ICONSTOP|MB_OK);
			return false;
		}
	}

	pblock->SetValue( id, 0, bm );
	
	m_Bitmaps[platform][0] = valid_bitmap( bm ) ? &bm->bi : NULL;
	return true;
}

BitmapInfo* BMTex::GetActualBaseMap( int platform )
{ FUNC_ENTER("BMTex::GetActualBaseMap"); 
	return m_Bitmaps[ platform ][ 0 ];
}

void BMTex::AssignOverrideTexName( int platform, TSTR name )
{ FUNC_ENTER("BMTex::AssignOverrideTexName"); 
	if (platform - 1 < 0)
		return;

	// We can only override if the mip type is auto
	if (GetMipType( platform ) != vMIP_TYPE_AUTO)
		return;

	// Don't allow override if a user-defined texture is already defined
	BitmapInfo* curplat = GetActualBaseMap( platform );

	if (curplat &&
		curplat->Name() != CStr("Use PS2"))
		return;

	// We'll use the with and height from the PS2 base texture
	BitmapInfo* bi = GetBaseMap( vPLAT_PS2 );

	biTexName[ platform - 1 ].SetWidth(bi->Width());
	biTexName[ platform - 1 ].SetHeight(bi->Height());
	biTexName[ platform - 1 ].SetName(name);
}

bool	BMTex::BaseMapDefined( int platform )
{ FUNC_ENTER("BMTex::BaseMapDefined"); 
	PBBitmap *bm;
	
	Interval ivalid;
	ivalid.SetInfinite();
	bm = NULL;
	switch( platform )
	{
		case vPLAT_PS2:
			pblock->GetValue( bmtex_bitmap_ps2, 0, bm, ivalid );
			break;
		case vPLAT_XBOX:
			pblock->GetValue( bmtex_bitmap_xbox, 0, bm, ivalid );
			break;
		case vPLAT_NGC:
			pblock->GetValue( bmtex_bitmap_ngc, 0, bm, ivalid );
			break;
	}

	if( bm )
	{
		if( stricmp( bm->bi.Name(), "None" ))
		{
			return true;
		}
	}

	return false;

}

BitmapInfo*	BMTex::GetMipMap( int platform, int level )
{ FUNC_ENTER("BMTex::GetMipMap"); 
	assert( level <= vMAX_NUM_MIP_LEVELS	);

	// TT7381: NEXT material - if PS2 set NONE mip - then USe PS2 mips doesn't work for other platforms (aml)
	// In the event that a platform is instructed to use PS2 mips we should
	// return those instead if PS2 is set to no mipping and the other platform is set to manual
	if ( GetMipType(vPLAT_PS2) == vMIP_TYPE_NONE &&
		 GetMipType(platform)  == vMIP_TYPE_MANUAL &&
		 UsePS2Mips(platform) )
		return m_Bitmaps[ vPLAT_PS2 ][ level ];

	return m_Bitmaps[ platform ][ level ];
}

int		BMTex::GetNumMipLevels( int platform )
{ FUNC_ENTER("BMTex::GetNumMipLevels"); 
	int i, num_levels;

	num_levels = 0;
	for( i = 0; i < vMAX_NUM_MIP_LEVELS; i++ )
	{
		if( GetMipMap( platform, i + 1 ))
		{
			num_levels++;
		}
		else
		{
			break;
		}
	}

	return num_levels;
}

float	BMTex::GetMipMapK( void )
{ FUNC_ENTER("BMTex::GetMipMapK"); 
	return m_MipMapK;
}

void	BMTex::SetMipMapK( float fVal )
{ FUNC_ENTER("BMTex::SetMipMapK");

	pblock->SetValue( bmtex_bitmap_mip_map_k, 0, fVal );
	m_MipMapK = fVal;
}

Color	BMTex::GetTransColor( void )
{ FUNC_ENTER("BMTex::GetTransColor"); 
	return m_TransColor;
}

void	BMTex::SetTransColor( Color color )
{ FUNC_ENTER("BMTex::SetTransColor");

	pblock->SetValue( bmtex_bitmap_change_trans_color, 0, color );
	m_TransColor = color;
}

bool	BMTex::ChangeTransColor( void )
{ FUNC_ENTER("BMTex::ChangeTransColor"); 
	//if (pblock)
	//	pblock->GetValue( bmtex_bitmap_change_trans, 0, m_ChangeTrans, ivalid );

	return ( m_ChangeTrans == TRUE );
}

void	BMTex::SetChangeTransColor( bool bMode )
{ FUNC_ENTER("BMTex::SetChangeTransColor");
	
	pblock->SetValue( bmtex_bitmap_change_trans, 0, bMode );
	m_ChangeTrans = bMode;
}

void BMTex::EnumAuxFiles(NameEnumCallback& nameEnum, DWORD flags)
{ FUNC_ENTER("BMTex::EnumAuxFiles"); 
	UpdateBIName(); // DS 2/24/99
	bi.EnumAuxFiles(nameEnum,flags);

	// Add the mipmaps (aml)
	for(int plat=0;plat<vNUM_PLATFORMS;plat++)
		for(int mip=0;mip<vMAX_NUM_MIP_LEVELS;mip++)
			if (m_Bitmaps[plat] && m_Bitmaps[plat][mip])
				m_Bitmaps[plat][mip]->EnumAuxFiles(nameEnum,flags);
}

BOOL BMTex::UseBasePal(int platform, int level)
{ FUNC_ENTER("BMTex::UseBasePal"); 
	return useBasePal[platform][level];
}

void BMTex::SetUseBasePal(int platform, int level, bool bMode)
{ FUNC_ENTER("BMTex::SetUseBasePal");

	switch(platform)
	{
	case vPLAT_PS2:
		switch(level)
		{
		case 0:
			pblock->SetValue( bmtex_bitmap_mip_1_ps2_pal, 0, bMode );
			useBasePal[vPLAT_PS2][0] = bMode;
			break;

		case 1:
			pblock->SetValue( bmtex_bitmap_mip_2_ps2_pal, 0, bMode );
			useBasePal[vPLAT_PS2][1] = bMode;
			break;

		case 2:
			pblock->SetValue( bmtex_bitmap_mip_3_ps2_pal, 0, bMode );
			useBasePal[vPLAT_PS2][2] = bMode;
			break;

		case 3:
			pblock->SetValue( bmtex_bitmap_mip_4_ps2_pal, 0, bMode );
			useBasePal[vPLAT_PS2][3] = bMode;
			break;

		case 4:
			pblock->SetValue( bmtex_bitmap_mip_5_ps2_pal, 0, bMode );
			useBasePal[vPLAT_PS2][4] = bMode;
			break;
		}
		break;

	case vPLAT_NGC:
		switch(level)
		{
		case 0:
			pblock->SetValue( bmtex_bitmap_mip_1_ngc_pal, 0, bMode );
			useBasePal[vPLAT_NGC][0] = bMode;
			break;

		case 1:
			pblock->SetValue( bmtex_bitmap_mip_2_ngc_pal, 0, bMode );
			useBasePal[vPLAT_NGC][1] = bMode;
			break;

		case 2:
			pblock->SetValue( bmtex_bitmap_mip_3_ngc_pal, 0, bMode );
			useBasePal[vPLAT_NGC][2] = bMode;
			break;

		case 3:
			pblock->SetValue( bmtex_bitmap_mip_4_ngc_pal, 0, bMode );
			useBasePal[vPLAT_NGC][3] = bMode;
			break;

		case 4:
			pblock->SetValue( bmtex_bitmap_mip_5_ngc_pal, 0, bMode );
			useBasePal[vPLAT_NGC][4] = bMode;
			break;
		}
		break;

	case vPLAT_XBOX:
		switch(level)
		{
		case 0:
			pblock->SetValue( bmtex_bitmap_mip_1_xbox_pal, 0, bMode );
			useBasePal[vPLAT_XBOX][0] = bMode;
			break;

		case 1:
			pblock->SetValue( bmtex_bitmap_mip_2_xbox_pal, 0, bMode );
			useBasePal[vPLAT_XBOX][1] = bMode;
			break;

		case 2:
			pblock->SetValue( bmtex_bitmap_mip_3_xbox_pal, 0, bMode );
			useBasePal[vPLAT_XBOX][2] = bMode;
			break;

		case 3:
			pblock->SetValue( bmtex_bitmap_mip_4_xbox_pal, 0, bMode );
			useBasePal[vPLAT_XBOX][3] = bMode;
			break;

		case 4:
			pblock->SetValue( bmtex_bitmap_mip_5_xbox_pal, 0, bMode );
			useBasePal[vPLAT_XBOX][4] = bMode;
			break;
		}
		break;
	}
}

float BMTex::GetCropPlaceU()
{ FUNC_ENTER("BMTex::GetCropPlaceU"); 
	float clipu;
	pblock->GetValue( bmcp_clipu, 0, clipu, clipValid );
	
	return clipu;
}

void BMTex::SetCropPlaceU( float fVal )
{ FUNC_ENTER("BMTex::SetCropPlaceU");

	pblock->SetValue( bmcp_clipu, 0, fVal );
}

float BMTex::GetCropPlaceV()
{ FUNC_ENTER("BMTex::GetCropPlaceV"); 
	float clipv;
	pblock->GetValue( bmcp_clipv, 0, clipv, clipValid );

	return clipv;
}

void BMTex::SetCropPlaceV( float fVal )
{ FUNC_ENTER("BMTex::SetCropPlaceV");

	pblock->SetValue( bmcp_clipv, 0, fVal );
}

float BMTex::GetCropPlaceW()
{ FUNC_ENTER("BMTex::GetCropPlaceW"); 
	float clipw;
	pblock->GetValue( bmcp_clipw, 0, clipw, clipValid );

	return clipw;
}

void BMTex::SetCropPlaceW( float fVal )
{ FUNC_ENTER("BMTex::SetCropPlaceW");

	pblock->SetValue( bmcp_clipw, 0, fVal );
}

float BMTex::GetCropPlaceH()
{ FUNC_ENTER("BMTex::GetCropPlaceH"); 
	float cliph;
	pblock->GetValue( bmcp_cliph, 0, cliph, clipValid );

	return cliph;
}

void BMTex::SetCropPlaceH( float fVal )
{
	pblock->SetValue( bmcp_cliph, 0, fVal );
}

int BMTex::GetCropPlaceMode()
{ FUNC_ENTER("BMTex::GetCropPlaceMode"); 
	BOOL bPlaceImage;
	BOOL bApply;

	pblock->GetValue( bmcp_apply, 0, bApply, FOREVER );

	if (!bApply)
		return vNONE;

	pblock->GetValue( bmcp_crop_place, 0, bPlaceImage, FOREVER );
	
	if (bPlaceImage)
		return vPLACE;

	return vCROP;
}

bool BMTex::GetCropPlaceApply()
{ FUNC_ENTER("GetCropPlaceApply");
	BOOL bApply;
	
	pblock->GetValue( bmcp_apply, 0, bApply, clipValid );

	return bApply;
}

void BMTex::SetCropPlaceApply( bool bMode )
{
	pblock->SetValue( bmcp_apply, 0, bMode );
}

void BMTex::SetCropPlaceMode( int iMode )
{ FUNC_ENTER("BMTex::SetCropPlaceMode");

	pblock->SetValue( bmcp_apply, 0, TRUE );
	pblock->SetValue( bmcp_crop_place, 0, iMode );
}

BitmapInfo* BMTex::GetManualMap(int plat, int mip)
{ FUNC_ENTER("BMTex::GetManualMap"); 
	PBBitmap *bm = NULL;
	Interval ivalid = FOREVER;

	switch(plat)
	{
	case vPLAT_PS2:
		switch(mip)
		{
		case 0:
			pblock->GetValue(bmtex_bitmap_mip_1_ps2, 0, bm, ivalid);
			break;

		case 1:
			pblock->GetValue(bmtex_bitmap_mip_2_ps2, 0, bm, ivalid);
			break;

		case 2:
			pblock->GetValue(bmtex_bitmap_mip_3_ps2, 0, bm, ivalid);
			break;

		case 3:
			pblock->GetValue(bmtex_bitmap_mip_4_ps2, 0, bm, ivalid);
			break;

		case 4:
			pblock->GetValue(bmtex_bitmap_mip_5_ps2, 0, bm, ivalid);
			break;
		}
		break;

	case vPLAT_NGC:
		switch(mip)
		{
		case 0:
			pblock->GetValue(bmtex_bitmap_mip_1_ngc, 0, bm, ivalid);
			break;

		case 1:
			pblock->GetValue(bmtex_bitmap_mip_2_ngc, 0, bm, ivalid);
			break;

		case 2:
			pblock->GetValue(bmtex_bitmap_mip_3_ngc, 0, bm, ivalid);
			break;

		case 3:
			pblock->GetValue(bmtex_bitmap_mip_4_ngc, 0, bm, ivalid);
			break;

		case 4:
			pblock->GetValue(bmtex_bitmap_mip_5_ngc, 0, bm, ivalid);
			break;
		}
		break;

	case vPLAT_XBOX:
		switch(mip)
		{
		case 0:
			pblock->GetValue(bmtex_bitmap_mip_1_xbox, 0, bm, ivalid);
			break;

		case 1:
			pblock->GetValue(bmtex_bitmap_mip_2_xbox, 0, bm, ivalid);
			break;

		case 2:
			pblock->GetValue(bmtex_bitmap_mip_3_xbox, 0, bm, ivalid);
			break;

		case 3:
			pblock->GetValue(bmtex_bitmap_mip_4_xbox, 0, bm, ivalid);
			break;

		case 4:
			pblock->GetValue(bmtex_bitmap_mip_5_xbox, 0, bm, ivalid);
			break;
		}
		break;
	}

	if (!bm)
		return NULL;

	return &bm->bi;
}

bool	BMTex::SetManualMap( int platform, int level, BitmapInfo* bmi )
{ FUNC_ENTER("BMTex::SetManualMap");
	// TODO: Implement
	ParamID id;

	switch(platform)
	{
	case vPLAT_PS2:
		switch(level)
		{
		case 0:
			id = bmtex_bitmap_mip_1_ps2;
			break;

		case 1:
			id = bmtex_bitmap_mip_2_ps2;
			break;

		case 2:
			id = bmtex_bitmap_mip_3_ps2;
			break;

		case 3:
			id = bmtex_bitmap_mip_4_ps2;
			break;

		case 4:
			id = bmtex_bitmap_mip_5_ps2;
			break;
		}
		break;

	case vPLAT_NGC:
		switch(level)
		{
		case 0:
			id = bmtex_bitmap_mip_1_ngc;
			break;

		case 1:
			id = bmtex_bitmap_mip_2_ngc;
			break;

		case 2:
			id = bmtex_bitmap_mip_3_ngc;
			break;

		case 3:
			id = bmtex_bitmap_mip_4_ngc;
			break;

		case 4:
			id = bmtex_bitmap_mip_5_ngc;
			break;
		}
		break;

	case vPLAT_XBOX:
		switch(level)
		{
		case 0:
			id = bmtex_bitmap_mip_1_xbox;
			break;

		case 1:
			id = bmtex_bitmap_mip_2_xbox;
			break;

		case 2:
			id = bmtex_bitmap_mip_3_xbox;
			break;

		case 3:
			id = bmtex_bitmap_mip_4_xbox;
			break;

		case 4:
			id = bmtex_bitmap_mip_5_xbox;
			break;
		}
		break;
	}

	// Assign bitmap
	PBBitmap* bm = NULL;

	//pblock->GetValue( id, 0, bm, ivalid );
	
	// Free current bitmap
	//if (bm)
	//	delete bm;

	bm = new PBBitmap;
	bm->bi = *bmi;

	BMMRES status;
	bm->bm = TheManager->Load(&bm->bi, &status);

	if (status != BMMRES_SUCCESS)
	{
		MessageBox(gInterface->GetMAXHWnd(), "Failed to open bitmap", "BMTex::SetBaseMap", MB_ICONSTOP|MB_OK);
		return false;
	}

	pblock->SetValue( id, 0, bm );
	
	//m_Bitmaps[platform][0] = valid_bitmap( bm ) ? &bm->bi : NULL;
	m_Bitmaps[platform][level] = valid_bitmap( bm ) ? &bm->bi : NULL;
	return true;
}

float BMTex::GetClipW(TimeValue t)
{ FUNC_ENTER("BMTex::GetClipW");  
	return pblock->GetFloat( bmcp_clipw, t); 
}