/*
	PropUpdater.h
	Property Updater

	The property updater is responsible for updating the properties of all objects within
	the level when property fields are added/deleted
*/

#ifndef __PROPUPDATER__
#define __PROPUPDATER__

#include "ScriptIniParser.h"
#include "max.h"
#include "notify.h"
#include "../UI/ModalDlg.h"
#include "PropBufGen.h"
#include "../misc/GenCrc.h"
#include <core/HashTable.h>

class ColorListBox;
class ProgressBar;

class PropUpdater: public ModalDlgWindow, public PropBufGen
{
	Lst::HashTable<unsigned long> crcTable;
	LinkList<unsigned long>       crcList;
	LinkList<ConfigClass*>        classUpdateList;	// List of all class only entries that have been modified since last update
	LinkList<ConfigType*>         typeUpdateList;	// List of all types that have been modified since last update
	LinkList<ConfigClass*>        selClassList;		// List of modified classes that are selected for update
	LinkList<ConfigType*>		  selTypeList;		// List of modified types that are selected for update
	LinkList<INode*>              updateList;		// List of all the nodes that should be updated
	LinkList<INode*>              delList;			// List of all nodes that should be deleted due to removed classes (bDiscardRemovedClasses)
	LinkList<INode*>			  particleList;		// List of particle systems that require updating after the new scripts.ini is loaded

	ColorListBox*   pCTList;
	ColorListBox*   pNList;
	Interface*      ip;
	HINSTANCE       hInstance;
	HWND            hwndParent;
	ProgressBar*    pProgress;
	bool            bUpdateTriggerColors;		// Node colors for triggers will be updated to match any @nodecolor metacommands
	bool            bUpdateOmissions;			// Remove omitted properties from existing nodes
	bool            bDeleteRemovedDefaultProps;	// Remove old defaulted properties
	bool            bAddNewProps;				// Newly added properties to scripts.ini will be added to nodes of that class/type (Normally on)
	bool            bDeleteAllOld;				// Any properties not contained within scripts.ini will be deleted (WARNING! Potentially Dangerous, User props will be destroyed)
	bool            bDiscardRemovedClasses;		// Any nodes assigned to a class or type that no longer exists in scripts.ini will be deleted from the scene
	ULONG           lastNodeID;					// Records the largest node ID encountered when scanning the level
												// This is done prior to merging so we can know when scanning the
												// scene if the object previously existed or is part of the merge
	bool		    bForceScriptUpdates;		// True if scripts.ini updates should be forced to occur when changed
	bool            bCancel;					// True if the property update has been cancelled

	CStr GetScriptIniName();
	bool FileIsNewer( char* file1, char* file2 );
	void ProcNode(INode* node);
	void ProcNodes();
	int  CountNodes(INode* node,int num);

	static void LoadCB(void* pthis,  NotifyInfo* ninfo);
	static void PreMergeCB(void* param,NotifyInfo* ninfo);
	static void MergeCB(void* pthis, NotifyInfo* ninfo);

	bool     ShouldUpdate(bool bForce = false);
	COLORREF ParseColor(char* line);

	bool	 DoUpdate(WIN32_FIND_DATA timestampDest);
	void     FindLastNodeID(INode* node = NULL);

	BOOL     DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void	 PopulateClassTypeList();
	void     PopulateClassTypeListAll();
	void	 PopulateNodeList();
	void	 DumpClassTypeCRCs();
	void	 LoadClassTypeCRCs();
	int		 GetTotalEntries();

	void	 SelAll(int id);
	void     SelNone(int id);
	void     SelInvert(int id);

	void	 BuildSelLists();
	void     BuildUpdateList();

	void     SetOptions();
	void     GetOptions();

	void     DoFullUpdate();

public:
	PropUpdater(HINSTANCE hInstance, HWND hwndParent, Interface* ip);
	~PropUpdater();

	void ProcChanges(bool bForce = false);
	void ProcPostParticleChanges();
	void ForceParticleBoxesToDefault(ScriptIniParser* pScriptIniParser);
};

#endif
