#include "FuncEnter.h"

/*
	MapFileParser.cpp
	This class provides functions for parsing map files
	5-15-01
*/

#include "MapFileParser.h"
#include "../UI/ProgressBar.h"
#include <stdio.h>
#include "../path.h"
#include "../PropEdit/ParseFuncs.h"
#include "../UI/PropList.h"

MapFileParser::MapFileParser() : scriptDB(8)
{ FUNC_ENTER("MapFileParser::MapFileParser"); 
}

MapFileParser::~MapFileParser()
{ FUNC_ENTER("MapFileParser::~MapFileParser"); 
}

bool MapFileParser::ParseMapFile(char* Filename,bool bProgBar)
{ FUNC_ENTER("MapFileParser::ParseMapFile"); 
	FILE* fp;
	char  buf[256];
	char  bufName[256];
	char  bufFileName[256];

	ProgressBar* pProgBar;
	DataType mode;

	enum LineMode
	{
		LMODE_NAME,
		LMODE_FILENAME
	};

	fp=fopen(Filename,"r");

	if (!fp)
		return false;

	// Determine the size of the file
	fseek(fp,0,SEEK_END);
	int lastPos=ftell(fp);
	fseek(fp,0,SEEK_SET);

	// Create Progress Bar
	if (bProgBar)
		pProgBar=new ProgressBar(hInstance,NULL,"Loading Map File...",0,lastPos);

	// First two lines contain header information
	fgets(buf,256,fp);
	fgets(buf,256,fp);

	// Parse out the information line by line
	while(fgets(buf,256,fp))
	{
		// Clear out name buffers
		bufName[0]='\0';
		bufFileName[0]='\0';

		// Update Progress Bar
		if (bProgBar)
			pProgBar->SetVal(ftell(fp));

		// Determine if there's a change of type
		if (strstr(buf,"<Scripts>"))
		{
			if (bProgBar)
				pProgBar->SetCaption("Loading Scripts...");

			mode=DATA_SCRIPT;
			continue;
		}

		if (strstr(buf,"<Integers>"))
		{
			if (bProgBar)
				pProgBar->SetCaption("Loading Integers...");

			mode=DATA_INTEGER;
			continue;
		}

		if (strstr(buf,"<Floats>"))
		{
			if (bProgBar)
				pProgBar->SetCaption("Loading Floats...");

			mode=DATA_FLOAT;
			continue;
		}

		if (strstr(buf,"<Vectors>"))
		{
			if (bProgBar)
				pProgBar->SetCaption("Loading Vectors...");

			mode=DATA_VECTOR;
			continue;
		}

		if (strstr(buf,"<Pairs>"))
		{
			if (bProgBar)
				pProgBar->SetCaption("Loading Pairs...");

			mode=DATA_PAIR;
			continue;
		}

		if (strstr(buf,"<Strings>"))
		{
			if (bProgBar)
				pProgBar->SetCaption("Loading Strings...");

			mode=DATA_STRING;
			continue;
		}

		if (strstr(buf,"<LocalStrings>"))
		{
			if (bProgBar)
				pProgBar->SetCaption("Loading LocalStrings...");

			mode=DATA_LOCALSTRING;
			continue;
		}

		if (strstr(buf,"<Arrays>"))
		{
			if (bProgBar)
				pProgBar->SetCaption("Loading Arrays...");

			mode=DATA_ARRAY;
			continue;
		}

		if (strstr(buf,"<Structures>"))
		{
			if (bProgBar)
				pProgBar->SetCaption("Loading Structures...");

			mode=DATA_STRUCT;
			continue;
		}

		if (strstr(buf,"<Names>"))
		{
			if (bProgBar)
				pProgBar->SetCaption("Loading Names...");

			mode=DATA_NAME;
			continue;
		}

		int slen=strlen(buf);
		int namePos=0;
		int filePos=0;

		LineMode curMode=LMODE_NAME;

		for(int i=0;i<slen;i++)
		{
			switch(curMode)
			{
			case LMODE_NAME:
				if (buf[i]!=' ')
				{
					if (buf[i]!=29 && buf[i]!=10)
						bufName[namePos++]=buf[i];
				}
				else
				{
					bufName[namePos]='\0';
					curMode=LMODE_FILENAME;
				}
				break;
			
			case LMODE_FILENAME:
				if (buf[i]!=' ')
				{
					if (buf[i]!=29 && buf[i]!=10)
						bufFileName[filePos++]=buf[i];
				}
				break;
			}

			bufFileName[filePos]='\0';
		}

		// Don't add the entity if it's empty
		if (bufName[0]=='\0' || bufFileName[0]=='\0')
			continue;

		// Add type to script db
		TypeDesc* tdesc=AddType(bufName,bufFileName,mode);
		tdesc->type=mode;

		if (!tdesc)
		{
			MessageBox(NULL,"Failed to load Map file Hash table add failed.","ParseMapFile",MB_OK);
			return false;
		}
	}

	fclose(fp);

	if (bProgBar)
		delete pProgBar;

	return true;
}

TypeDesc* MapFileParser::AddType(CStr Name,CStr ScriptFile,DataType type)
{ FUNC_ENTER("MapFileParser::AddType"); 
	TypeDesc* pType=new TypeDesc;

	pType->Name      =Name;
	pType->type      =type;
	pType->ScriptFile=ScriptFile;

	//pTVIScripts->AddItem(Name,pType,TV_SORT);

	if (scriptDB.GetItem(Name))
		scriptDB.FlushItem(Name);

	if (!scriptDB.PutItem(Name,pType))
	{
		delete pType;
		return NULL;
	}
	
	return pType;
}

void MapFileParser::DeleteType(CStr Name)
{ FUNC_ENTER("MapFileParser::DeleteType"); 
	if (Name==CStr(""))
		return;

	TypeDesc* pScript=scriptDB.GetItem(Name);
	
	if (pScript)
	{
		delete pScript;
		scriptDB.FlushItem(Name);
	}
}

bool MapFileParser::ParseTagDBFile()
{ FUNC_ENTER("MapFileParser::ParseTagDBFile"); 
	// Load in Brad's tagsdb.q file that list out all the C++ Autoduck tags
	// So we can provide automated info on everything, not just script tags

	CStr strTagFile = getenv(APP_ENV);
	strTagFile += CStr(TAGDB_PATH) + CStr(TAGDB_NAME);
	
	FILE* fp = fopen(strTagFile,"r");
	
	if (!fp)
		return false;
	
	char  lineBuf[1024];

	while(!feof(fp))
	{
		fgets(lineBuf,1023,fp);
		if (IsInstr(lineBuf,"// @script "))
		{
			int pos1 = Instr(lineBuf,"|");
			if (pos1==-1)
				continue;

			int pos2 = Instr(lineBuf,"|",pos1+2);
			if (pos2==-1)
				continue;

			CStr line = lineBuf;
			CStr name = line.Substr(pos1+2,pos2-pos1-3);

			char strErr[256];
			sprintf(strErr,"ParseTagsDB: Added '%s'\n",name);
			OutputDebugString(strErr);
			AddType(name,strTagFile,DATA_SCRIPT);
		}
	}

	fclose(fp);
	return true;
}

CStr MapFileParser::ParseScriptDesc(CStr Filename,CStr Keyword)
{ FUNC_ENTER("MapFileParser::ParseScriptDesc"); 
	char funcDesc[1024]="";	// Buffer to store the description of the function
	//char ErrorMsg[256];		// Error buffer
	char lineBuf[512];		// line buffer
	char token[1024];
	int  pos=0;
	int  filepos;

	CStr strLine;

	CStr strAutoDuck;

	FILE* fp=fopen(Filename,"r");

	Keyword.toLower();
	CStr strSearch1=CStr("// @script ");
	CStr strSearch2=CStr("| ")+Keyword+CStr(" |");

	if (!fp)
	{
		//sprintf(ErrorMsg,"Failed to open script file: %s",(char*)Filename);
		//MessageBox(hwnd,ErrorMsg,"PropEdit",MB_OK|MB_ICONSTOP);
		return CStr("");
	}

	filepos=0;

	while(fgets(lineBuf,512,fp))
	{
		strLine=lineBuf;
		strLine.toLower();

		if (IsInstr(strLine,strSearch1) &&
			IsInstr(strLine,strSearch2))
		{
			strAutoDuck=BuildAutoDuckString(fp,filepos);
			char* str=strAutoDuck;
			char* loc;

			// Parse the AutoDuck string for the script description
			loc=strstr(str,"@script ");
			if (loc!=NULL)
			{
				loc+=7;
				CStr strDesc;
				CStr strLine;
				int  pos=0;

				GetToken(loc,&pos,token);	// This is undefined
				GetToken(loc,&pos,token);	// This is the script name

				strLine=GetRemainLinePartial(loc,&pos);
				
				int len=strlen(loc);

				while (Instr(strLine,"@")==-1 && pos<len)
				{
					strDesc+=strLine+CStr("\n");
					strLine=GetRemainLinePartial(loc,&pos);
				}

				strDesc=StripLeft(strDesc);
				strDesc=StripRight(strDesc);
				return strDesc;
			}
		}
			
		filepos=ftell(fp);
	}

	fclose(fp);

	//sprintf(ErrorMsg,"Failed to locate AutoDuck Script definition\nFilename: %s\nSearch: %s",(char*)Filename,(char*)(strSearch1+strSearch2));
	//MessageBox(gInterface->GetMAXHWnd(),ErrorMsg,"MapFileDB",MB_OK|MB_ICONSTOP);
	return CStr("");
}
