/*
	NSPiece.h
	This is the structure to maintain data loaded from .NSP files
	(NeverSoft Piece files)
*/

#ifndef __NSPIECE__
#define __NSPIECE__

#include <max.h>
#include "../FaceFlags/FaceFlags.h"
#include "D3DMesh.h"

struct NSPiece
{
	Mesh      mesh;
	int       nTextures;		// Number of textures
	CStr      mtlName;			// Name of the material to be used with this piece
	CStr*     texname;			// An array of strings for each unique texture that needs loaded for the mesh
	int*      texnameID;		// An array of the texture ID for the corresponding texname
	int*      texnameIDGL;		// An array of the OpenGL texture ID for the corresponding texname
	int*      texID;			// An array of the bound OpenGL texture ID for each face
	int       nFlagTypes;		// Number of items in the face flags array
	FlagType* flags;			// An array of face flags for the object
	float     width;			// Original width of the piece
	float     height;			// Original height of the piece
	float     length;			// Original length of the piece
	float     scalar;			// The scalar value in which the width/height/length were normalized by
	D3DMesh   D3Dmesh;			// Direct3D format mesh for this piece if using D3D Renderer
	CStr      pieceName;		// The name of the piece file w/o extension (name used when creating node)

	NSPiece();
	~NSPiece();

	int  FindTexture(int mtlID);
	void AllocNames(int i);
	void Alloc();
	void AssignTexIDs();
	void AllocFlags(int nFlags);
	
	void BuildD3DMesh(int nDisp);
	void BuildD3DMeshAsIndexed(int nDisp);
	void BuildD3DMeshToIndexed(int nDisp);
};

#endif
