/*
	D3DTypes.h
	Miscellaneous structures for the D3D Renderer
	aml - 11-21-02
*/

#ifndef __D3DTYPES__
#define __D3DTYPES__

#include <windows.h>
#include <d3dx8.h>
#include "../misc/llist.h"
#include "max.h"

struct Texture
{
	LPDIRECT3DTEXTURE8 texture;

	Texture()
	{
		texture = NULL;
	}

	~Texture()
	{
		if (texture)
			texture->Release();
	}
};

//////////// Vert and face are uploaded to the card do not add members!
struct D3DVert
{
	float x, y, z;
	DWORD color;
	float u, v;		// Texture UV coordinates

	enum
	{
		Type = D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1
	};
};

struct D3DFace
{
	unsigned short f[3];	// Indicies into the vertex array for this face
};
///////////////////////////////////////////////////////////////////////////

struct TexFace
{
	unsigned short f[3];	// Indicies into the vertex array for this face
	int            tex;		// ID of the texture to be mapped to this face
};

struct VertexBuffer
{
	LPDIRECT3DVERTEXBUFFER8  vertBuffer;

	VertexBuffer()
	{
		vertBuffer = NULL;
	}

	~VertexBuffer()
	{
		if (vertBuffer)
			vertBuffer->Release();
	}
};

struct IndexBuffer
{
	IDirect3DIndexBuffer8* indexBuffer;

	IndexBuffer()
	{
		indexBuffer = NULL;
	}

	~IndexBuffer()
	{
		if (indexBuffer)
			indexBuffer->Release();
	}
};

struct MeshTexture
{
	Link<Texture>** textures;	// List of references to this texture 1 per device
	CStr            texname;	// The filename of this texture

	MeshTexture()
	{
		textures = NULL;
	}

	~MeshTexture()
	{
		if (textures)
			delete [] textures;
	}

	void AllocTextureRefs(int nRefs)
	{
		textures = new Link<Texture>*[nRefs];
		ZeroMemory(textures, sizeof(Link<Texture>*) * nRefs);
	}
};

// A list of arrays of Vertex/IndexBuffer references
// each array contains an entry per display device, 
// and each entry in the list corresponds to a texture in the mesh
// So we have seperate Vert/Index lists per texture to avoid swapping
// textures in/out of VRAM
typedef Link<VertexBuffer>*        VertBufRef;
typedef VertBufRef*                VertBufRefArray;
typedef Link<IndexBuffer>*         IndexBufRef;
typedef IndexBufRef*               IndexBufRefArray;

typedef LinkList<VertBufRefArray>  VertGroup;
typedef LinkList<IndexBufRefArray> IndexGroup;

#endif
