/**********************************************************************
 *<
	FILE: NExt.h

	DESCRIPTION:	Includes for Plugins

	CREATED BY:

	HISTORY:

 *>	Copyright (c) 2000, All Rights Reserved.
 **********************************************************************/

#ifndef __NEXT__H
#define __NEXT__H

#include "Max.h"
#include "resource.h"
#include "istdplug.h"
#include "iparamb2.h"
#include "iparamm2.h"
#include "path.h"

#include <guplib.h>

#define vNEXT_CLASS_ID	Class_ID(0x61c8135b, 0x688bfbb7)

enum
{
	vPLAT_PS2,
	vPLAT_NGC,
	vPLAT_XBOX,
	vNUM_PLATFORMS,
	vPLAT_PCVIEWER,
};

enum
{
	mPLAT_PS2 = 1 << vPLAT_PS2,
	mPLAT_NGC = 1 << vPLAT_NGC,
	mPLAT_XBOX= 1 << vPLAT_XBOX,
	mPLAT_PCVIEWER= 1 << vPLAT_PCVIEWER,
};

extern TCHAR *GetString(int id);
extern ClassDesc* GetEditTriObjectDesc();

class StaticObject {
public:
	Object *ob;
	StaticObject () { ob = NULL; }
	~StaticObject () { if (ob) ob->DeleteThis(); }
	Object *GetEditTriOb ();
};

extern Interface* gInterface;
extern StaticObject statob;
extern HINSTANCE hInstance;
extern int enabled;

// Needs to be able to be referred to by RCMenu
class NExtClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() { return TRUE; }
	void *			Create(BOOL loading = FALSE);
	const TCHAR *	ClassName() { return GetString(IDS_CLASS_NAME); }
	SClass_ID		SuperClassID() { return GUP_CLASS_ID; }
	Class_ID		ClassID() { return vNEXT_CLASS_ID; }
	const TCHAR* 	Category() { return GetString(IDS_CATEGORY); }
	char*			GetRsrcString( long id ) { return GetString( id ); }
	const TCHAR*	InternalName() { return _T("NExt"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }				// returns owning module handle

};

#endif // __NEXT__H
