#include "FuncEnter.h"

/*
	BrandCheck.h
	Brander checking routines
	aml - 1-9-02
*/

#include "BrandCheck.h"
#include <stdio.h>
#include <string.h>
#include <windows.h>

void ReadStr(FILE* fp, char* str)
{ FUNC_ENTER("ReadStr"); 
	char chr[2];
	str[0] = 0;
	chr[1] = 0;

	while(!feof(fp))
	{
		fread(&chr[0], sizeof(char), 1, fp);
		if (chr[0] == 0)
			return;

		strcat(str, chr);
	}
}

bool VerifyAuthenticity(char* bufdate, char* buftime, char* bufmsg)
{ FUNC_ENTER("VerifyAuthenticity"); 
	// Verifies brand on executable

	//////////////// Only do the actual authenticity check once (hold vals in mem)
	static char authdate[256];
	static char authtime[256];
	static char authmsg[256];
	static bool bFirstCall = true;
	static bool IsBranded = false;

	if (!bFirstCall)
	{
		if (!IsBranded)
			return false;

		if (bufdate)
			strcpy(bufdate, authdate);

		if (buftime)
			strcpy(buftime, authtime);

		if (bufmsg)
			strcpy(bufmsg, authmsg);

		return true;
	}
	///////////////////////////////////////////////////////////////////////////

	HMODULE hModule = GetModuleHandle("next.gup");
	char    filename[1024];
	char    footer[5];
	char    chr;

	footer[4] = 0;

	GetModuleFileName(hModule, filename, 1023);

	// Open ourselves
	FILE* fp = fopen(filename, "rb");
	fseek(fp, -4, SEEK_END);
	
	fread(footer, sizeof(char), 4, fp);
	if (footer[0] == 0x04 &&
		footer[1] == 0x03 &&
		footer[2] == 0x02 &&
		footer[3] == 0x01)
	{
		// Seek back until we locate last header byte of brand header (0x04)
		fseek(fp, -3, SEEK_CUR);

		while(ftell(fp) != 0)
		{
			fseek(fp, -2, SEEK_CUR);
			fread(&chr, sizeof(char), 1, fp);

			if (chr == 0x04)
				break;
		}

		// Get date string
		ReadStr(fp, authdate);
		ReadStr(fp, authtime);
		ReadStr(fp, authmsg);

		if (bufdate)
			strcpy(bufdate, authdate);

		if (buftime)
			strcpy(buftime, authtime);

		if (bufmsg)
			strcpy(bufmsg, authmsg);

		fclose(fp);
		bFirstCall = false;
		IsBranded  = true;
		return true;
	}

	fclose(fp);
	bFirstCall = false;
	return false;
}
