/*
	MergeList.h
	4-1-01
*/

#ifndef __MERGELIST__
#define __MERGELIST__

#include "../UI/ModalDlg.h"
#include "MergeTypes.h"
#include "merge.h"

class PropList;
class ColorListBox;

class NodeMergeList: public ModalDlgWindow
{
	Interface* ip;
	ICustEdit* IEdit;
	
	PropList*  plist;							// Used for listing out custom stat values

	int nSrcFaces;

	ColorListBox* listbox;

	LinkList<NodeEntry>* srcList;				// Source nodes
	LinkList<NodeEntry>* mergeList;				// Merge file nodes
	LinkList<NodeEntry>  finalList;

	INodeTab             nonMergeDelList;
	INodeTab             preDelList;			// Pre-deletion list
	INodeTab             postDelList;			// Post-deletion list

	bool                 bRenameTriggers;
	bool                 bIncludeTriggerLinks;	// True if reference triggerlinks should be merged into the scene

	void AddItems(LinkList<NodeEntry>* list);
	void DeleteNodes();

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void BuildFinalList();

	void SelAll();
	void SelNone();
	void SelInvert();
	void SelChange();

	void DelNonMergedNodes();
	void UpdateNodeProps();
	void SetVisible();
	void CountNodes(LinkList<NodeEntry>* list, int& iSame, int& iNew);
	int  CountFaces(LinkList<NodeEntry>* nlist);
	int  CountFaces(INode* node);
	int  CountUniqueFaces(LinkList<NodeEntry>* flist, LinkList<NodeEntry>* list);

	void ProcMerge();
	void ClearDelLists();

	bool NodeExists(ULONG id,INode* root=NULL);
	bool NodeExists(INode* node,INode* root=NULL);

	void UpdateMatching();
	void CreateNonMergedDelList();

public:
	NodeMergeList(HINSTANCE hInstance,HWND hwndParent,
		          LinkList<NodeEntry>* srclist, LinkList<NodeEntry>* mergelist,
				  Interface* ip);
	~NodeMergeList();

	int  NumSelItems();
	bool GetItem(int i,char* name);
	void ProcDelLists();

	Link<NodeEntry>* FinalNodeExists(INode* node);

	inline LinkList<NodeEntry>* GetFinalList() { return &finalList; }
	inline void EnableTriggerRename()  { bRenameTriggers = true;  }
	inline void DisableTriggerRename() { bRenameTriggers = false; }

	inline void IncludeTriggers(bool bVal) { bIncludeTriggerLinks = bVal; }
};

#endif
