/*
	MaxScriptInt.cpp
	MAXScript internal interface functions
	4-15-03
*/

#include "MemDebug.h"
#include "MaxScriptInt.h"
#define NO_PREINCLUDES
#define SKIP_NEW_CHECKS
#include "FuncEnter.h"

extern Interface* gInterface;

Value* RunScriptCommand(TCHAR *command, INode* node, char* scriptName)
{ FUNC_ENTER("RunScriptCommand"); 
	Value * ret;
	three_typed_value_locals(StringStream* source, Parser* parser, Value* code);
	init_thread_locals();
	push_alloc_frame();

	StringStream* outstream = new StringStream;
	vl.source = new StringStream (command);
	//vl.parser = new Parser (thread_local(current_stdout));
	vl.parser = new Parser (outstream);

	try{
		vl.source->flush_whitespace();
		vl.code = vl.parser->compile_all(vl.source);
		vl.source->close();
		ret = vl.code->eval()->make_heap_permanent();
	}
	catch (...) {
		// Handle error here
		char* buf = outstream->content_string;
		char* strErr;

		if (!buf)
			buf = new char[256];
		else
			strErr = new char[strlen(buf)+256];

		if (node)
		{
			sprintf(strErr,"A MAXScript error occured in script: %s\nwhen being executed on node %s\nOutput Buffer:\n%s",(char*)scriptName,(char*)node->GetName(),buf);
			MessageBox(gInterface->GetMAXHWnd(),strErr,"DynUI MAXScript Exception",MB_ICONWARNING|MB_OK);
		}
	}
	pop_alloc_frame();
	pop_value_locals();
	return (ret) ? ret : &undefined;
}

bool   RunScriptStringResult(TCHAR *command, INode* node, char* scriptName)
{ FUNC_ENTER("RunScriptStringResult"); 
	Value* val = RunScriptCommand(command, node, scriptName);
	
	if (val)
	{
		try
		{
			return (val->to_bool()) ? true : false;
		}
		catch(...)
		{
			return false;
		}
	}

	return true;
}
