/*
	LOD Modifier
	aml
*/

#ifndef __LODMOD__
#define __LODMOD__

#include "max.h"
#include "iparamb2.h"
#include "../UI/PropList.h"
#include "../PropEdit/ConfigData.h"

#define vLODMOD_CLASS_ID       Class_ID(0x7b31309e, 0x2f865bb1)
#define vLODMODCLIENT_CLASS_ID Class_ID(0x7c550e9f, 0x16c331c2)

ClassDesc2* GetLODModClassDesc();
ClassDesc2* GetLODModClientClassDesc();

class LODMod: public Modifier
{
	HWND      hRollup;
	PropList* pLODList;
	int       focusID;
	int       numLODs;
	INodeTab  refLODs;		// Pointer to each node in the LOD List
	INodeTab  mainNodes;	// List of nodes that the modifier is currently applied to
							// (we maintain this list so that we can determine the new basenode(s)
	                        //  after cloning occurs through ReDir::Patch)

	static BOOL CALLBACK DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static void ChangeCB(PropList* pList, void* pData);
	static void FocusCB(PropList* pList, int id, void* pData);

public:
	LODMod();

	void AddLOD();
	void RemoveLOD();
	void RemoveLOD(int id);

	void StoreLODData();
	void ReadLODData();

	INode* GetNode();

	void SetPropsFromReferences();
	void UpdateInternalPropsFromReferences(INodeTab& nodeList);

	void SelectChildren();
	void SelectAll();

	inline int GetNumLODs() { return numLODs; }

	//CoreExport virtual Interval LocalValidity(TimeValue t);
	ChannelMask ChannelsUsed()    { return 0; }
	ChannelMask ChannelsChanged() { return 0; }

	bool ChangesSelType(){ return false;}

	// This is the method that is called when the modifier is needed to 
	// apply its effect to the object. Note that the INode* is always NULL
	// for object space modifiers.
	void ModifyObject(TimeValue t, ModContext &mc, ObjectState* os, INode *node) {}

	// Modifiers that place a dependency on topology should return TRUE
	// for this method. An example would be a modifier that stores a selection
	// set base on vertex indices.
	virtual BOOL DependOnTopology(ModContext &mc) {return FALSE;}

	// this can return:
	//   DEFORM_OBJ_CLASS_ID -- not really a class, but so what
	//   MAPPABLE_OBJ_CLASS_ID -- ditto
	//   TRIOBJ_CLASS_ID
	//   BEZIER_PATCH_OBJ_CLASS_ID
	virtual Class_ID InputType() { return Class_ID(TRIOBJ_CLASS_ID, 0); }

	IOResult SaveLocalData(ISave *isave, LocalModData *ld);
	IOResult LoadLocalData(ILoad *iload, LocalModData **pld);  

    RefResult NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, 
         PartID& partID,  RefMessage message);		

	CreateMouseCallBack* GetCreateMouseCallBack();

	int GetMAXLODLevels(LinkList<ConfigProp>& cprops);

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// --- Interhited virtual methods of Animatable
	void DeleteThis() { delete this; }
	void GetClassName(TSTR& s) { s = "LODMod"; }  
	virtual Class_ID ClassID() { return vLODMOD_CLASS_ID;}
	
	void BeginEditParams( IObjParam  *ip, ULONG flags,Animatable *prev);
	void EndEditParams( IObjParam *ip,ULONG flags,Animatable *next);

	// --- Interhited virtual methods of ReferenceTarget
	RefTargetHandle Clone(RemapDir& remap = NoRemap());

	// --- Interhited virtual methods of BaseObject
	TCHAR *GetObjectName() { return _T("LODMod");}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
};

class LODModClassDesc: public ClassDesc2
{
public:
	int          IsPublic() { return TRUE; }
	void*        Create(BOOL loading = FALSE) { return new LODMod; }
	const TCHAR* ClassName() { return _T("LODMod"); }
	SClass_ID    SuperClassID() { return OSM_CLASS_ID; }
	Class_ID     ClassID() { return vLODMOD_CLASS_ID; }
	const TCHAR* Category() { return _T(""); }
	const TCHAR* InternalName() { return _T("LODMod"); }
	HINSTANCE    HInstance() { return hInstance; }
};

//////////////////////////////////////////// LODMod client

class LODModClient: public Modifier
{
	HWND      hRollup;
	PropList* pLODList;

	static BOOL CALLBACK DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

public:
	LODModClient();

	void SelMaster();
	void SelAll();
	
	void   ReadLODData();
	INode* GetMasterNode();

	ChannelMask ChannelsUsed()    { return 0; }
	ChannelMask ChannelsChanged() { return 0; }

	bool ChangesSelType(){ return false;}

	// This is the method that is called when the modifier is needed to 
	// apply its effect to the object. Note that the INode* is always NULL
	// for object space modifiers.
	void ModifyObject(TimeValue t, ModContext &mc, ObjectState* os, INode *node) {}

	// Modifiers that place a dependency on topology should return TRUE
	// for this method. An example would be a modifier that stores a selection
	// set base on vertex indices.
	virtual BOOL DependOnTopology(ModContext &mc) {return FALSE;}

	// this can return:
	//   DEFORM_OBJ_CLASS_ID -- not really a class, but so what
	//   MAPPABLE_OBJ_CLASS_ID -- ditto
	//   TRIOBJ_CLASS_ID
	//   BEZIER_PATCH_OBJ_CLASS_ID
	virtual Class_ID InputType() { return Class_ID(TRIOBJ_CLASS_ID, 0); }

	IOResult SaveLocalData(ISave *isave, LocalModData *ld);
	IOResult LoadLocalData(ILoad *iload, LocalModData **pld);  

    RefResult NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, 
		PartID& partID,  RefMessage message) { return REF_SUCCEED; }

	CreateMouseCallBack* GetCreateMouseCallBack() { return NULL; }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// --- Interhited virtual methods of Animatable
	void DeleteThis() { delete this; }
	void GetClassName(TSTR& s) { s = "LODModClient"; }  
	virtual Class_ID ClassID() { return vLODMODCLIENT_CLASS_ID;}
	
	void BeginEditParams( IObjParam  *ip, ULONG flags,Animatable *prev);
	void EndEditParams( IObjParam *ip,ULONG flags,Animatable *next);

	// --- Interhited virtual methods of ReferenceTarget
	RefTargetHandle Clone(RemapDir& remap = NoRemap());

	// --- Interhited virtual methods of BaseObject
	TCHAR *GetObjectName() { return _T("LODModClient");}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
};

class LODModClientClassDesc: public ClassDesc2
{
public:
	int          IsPublic() { return TRUE; }
	void*        Create(BOOL loading = FALSE) { return new LODModClient; }
	const TCHAR* ClassName() { return _T("LODModClient"); }
	SClass_ID    SuperClassID() { return OSM_CLASS_ID; }
	Class_ID     ClassID() { return vLODMODCLIENT_CLASS_ID; }
	const TCHAR* Category() { return _T(""); }
	const TCHAR* InternalName() { return _T("LODModClient"); }
	HINSTANCE    HInstance() { return hInstance; }
};


#endif
