#ifndef __FUNCENTER__
#define __FUNCENTER__

#define DISABLE_USER_LODDIST_SUPPORT

//#define  ENABLE_MEMLEAK_CHECKS		// This will allow us to determine were every memory block is allocated from
//#define ENABLE_INTERNAL_MEMLEAK_CHECKS
#ifndef NO_PREINCLUDES
#include "maxscrpt/maxscrpt.h"
#include "maxscrpt/rollouts.h"
#include "core/defines.h"
#endif

#include "misc/llist.h"

#ifndef SKIP_NEW_CHECKS
#include "MemDebug.h"
#endif

#ifndef NO_BASEPREINCLUDES
#include <winsock2.h>
#include <windows.h>
#include <stdio.h>
#endif

#include "../../DebugLink/DebugLink.h"

// The SymbolTrace app will add an appropriate FUNC_ENTER macro to ALL functions in the project
// The implementation of the macro here ensures that the last executed function can be
// examined by the GetPluginState app

extern BOOL   gbDoMemChecks;
extern int    gbMemCheckFreq;
extern HANDLE ghTrackingThread;

#define FUNCENTER2(name, file, line)					\
	{													\
		if ((ghTrackingThread &&						\
            GetCurrentThread() == ghTrackingThread) ||  \
            !ghTrackingThread)	                        \
		{                                               \
			DebugState ds;								\
			strcpy(ds.lastFunction, name);				\
			strcpy(ds.lastFile, file);					\
			ds.lastLine = line;							\
			PostDebugState(&ds);						\
			dbgPrintf("Thread: 0x%x", ghTrackingThread);\
													    \
			if (gbDoMemChecks)							\
				if (rand() % gbMemCheckFreq == 1)		\
					_VerifyMemory(file,line);			\
		}                                               \
	}

#define FUNCENTER1(name, file, line)                      \
	{								                      \
		char buf[1024];                                   \
		sprintf(buf, "%s(%i): %s\n", file, line, name);   \
		OutputDebugString(buf);                           \
		FUNCENTER2(name, file, line);                     \
	}

#define FUNC_EXIT2(name, file, line) \
	{												    \
		if ((ghTrackingThread &&						\
            GetCurrentThread() == ghTrackingThread) ||  \
            !ghTrackingThread)	                        \
		{                                               \
			DebugState ds;								\
			strcpy(ds.lastFunction, name);				\
			strcpy(ds.lastFile, file);					\
			ds.lastLine = line;							\
			PostExitDebugState(&ds);					\
			dbgPrintf("Thread: 0x%x", ghTrackingThread);\
														\
			if (gbDoMemChecks)							\
				if (rand() % gbMemCheckFreq == 1)		\
					_VerifyMemory(file,line);			\
		}												\
	}


#define FUNC_EXIT(x) FUNC_EXIT2(x, __FILE__, __LINE__)

#ifdef DUMP_STACK_TO_CONSOLE
#define FUNC_ENTER(name) FUNCENTER1(name, __FILE__, __LINE__)
#else
#define FUNC_ENTER(name) FUNCENTER2(name, __FILE__, __LINE__)
#endif

#endif
