#include "FuncEnter.h"

#include <next.h>
#include "strip.h"
#include "striper.h"

class NxStripper: public INxStripper
{
public:	
	// From INxStripper
	void	Reset( void );
	void	AddFace( NxFace* face );
	bool	Stripify( void );
	void	GetMeshList( Tab< NxMesh * > &mesh_list );
	void	SetObject( NxObject* object );	

	Tab< NxMesh * >	m_Meshes;
	NxObject*		m_Object;
};

static	NxStripper	s_stripper;

INxStripper*	GetNxStripper( void )
{ FUNC_ENTER("GetNxStripper"); 
	return &s_stripper;
}

NxMesh::NxMesh( unsigned long mat_checksum )
	: m_MatChecksum( mat_checksum )
{ FUNC_ENTER("NxMesh::NxMesh"); 
	m_NumStripVerts = 0;
	m_VertStrip = NULL;
	m_NumFaces = 0;	
	m_Object;
}

NxMesh::~NxMesh( void )
{ FUNC_ENTER("NxMesh::~NxMesh"); 
	if( m_VertStrip )
	{
		delete [] m_VertStrip;
	}
}

void NxStripper::Reset( void )
{ FUNC_ENTER("NxStripper::Reset"); 
	int i;

	for( i = 0; i < m_Meshes.Count(); i++ )
	{
		//delete m_Meshes[i];
	}

	m_Meshes.ZeroCount();
}

void NxStripper::SetObject( NxObject* object )
{ FUNC_ENTER("NxStripper::SetObject"); 
	m_Object = object;
}

void NxStripper::AddFace( NxFace* face )
{ FUNC_ENTER("NxStripper::AddFace"); 
	int i;
	bool existed;

	existed = false;
	for( i = 0; i < m_Meshes.Count(); i++ )
	{
		if( m_Meshes[i]->m_MatChecksum == face->m_MatChecksum )
		{			
			assert( m_Meshes[i]->m_NumFaces < NxMesh::vMAX_FACES ); 

			m_Meshes[i]->m_Topology[m_Meshes[i]->m_NumFaces][0] = face->m_Vertex[0];
			m_Meshes[i]->m_Topology[m_Meshes[i]->m_NumFaces][1] = face->m_Vertex[1];
			m_Meshes[i]->m_Topology[m_Meshes[i]->m_NumFaces][2] = face->m_Vertex[2];

			m_Meshes[i]->m_NumFaces++;
			existed = true;
			break;
		}
	}

	// If the texture index is new, create a new mesh to represent these tri's
	if( !existed )
	{
		NxMesh* new_mesh;
		int new_index;

		new_mesh = new NxMesh( face->m_MatChecksum );
		new_mesh->m_Object =  m_Object;
		new_index = m_Meshes.Append( 1, &new_mesh );
		m_Meshes[new_index]->m_Topology[0][0] = face->m_Vertex[0];
		m_Meshes[new_index]->m_Topology[0][1] = face->m_Vertex[1];
		m_Meshes[new_index]->m_Topology[0][2] = face->m_Vertex[2];

		m_Meshes[new_index]->m_NumFaces++;	
	}
}

bool NxStripper::Stripify( void )
{ FUNC_ENTER("NxStripper::Stripify"); 	
	int i;

	// Create the topology for each mesh
	for( i = 0; i < m_Object->m_NumFaces; i++ )
	{
		AddFace( &m_Object->m_Faces[i] );
	}

	// At this point we should have one mesh per material (eventually for each texture)
	// so we can pass each mesh's topology to the stripper
	for( i = 0; i < m_Meshes.Count(); i++ )
	{
		udword j, k;
		int num_verts, count;
		uword* Refs;

		STRIPERCREATE sc;
		sc.DFaces			= (unsigned int *) m_Meshes[i]->m_Topology;//Topology;
		sc.NbFaces			= m_Meshes[i]->m_NumFaces;
		sc.AskForWords		= true;
		sc.ConnectAllStrips	= false;
		sc.OneSided			= false;
		sc.SGIAlgorithm		= true;

		Striper Strip;
		if( Strip.Init(sc) == false )
		{
			return false;
		}

		STRIPERRESULT sr;
		if( Strip.Compute(sr) == false )
		{
			return false;
		}

#ifdef DEBUG_STRIPS
		DebugPrint("Number of strips: %d\n", sr.NbStrips);
		Refs = (uword*)sr.StripRuns;
		for( j= 0 ; j < sr.NbStrips; j++ )
		{
			DebugPrint( "Strip %d:   ", j);
			udword NbRefs = sr.StripLengths[j];
			for( k = 0; k < NbRefs; k++ )
			{
				DebugPrint( "%d ", *Refs++);
			}
			DebugPrint( "\n");
		}
#endif
		num_verts = 0;
		// Count the number of verts needed to strip this mesh
		for( j = 0; j < sr.NbStrips; j++ )
		{
			num_verts += sr.StripLengths[j];
		}
		
		if( num_verts > 0 )
		{
			m_Meshes[i]->m_NumStripVerts = num_verts;
			m_Meshes[i]->m_VertStrip = new NxStripVert[num_verts];

			count = 0;

			Refs = (uword*) sr.StripRuns;
			// Now populate the strip vertex array with indices to those verts and their
			// ADC bits
			for( j = 0; j < sr.NbStrips; j++ )
			{
				udword NbRefs = sr.StripLengths[j];
				for( k = 0; k < NbRefs; k++ )
				{
					// The first two tris of a strip are the start of a new strip, rather
					// than a continuation of the last. So their ADC bits are off
					if( k < 2 )
					{
						m_Meshes[i]->m_VertStrip[count].m_ADC = vADC_OFF;
					}
					else
					{
						m_Meshes[i]->m_VertStrip[count].m_ADC = vADC_ON;
					}
					m_Meshes[i]->m_VertStrip[count].m_Index = *Refs++;
					count++;
				}				
			}
		}
	}

	return true;
}

void NxStripper::GetMeshList( Tab< NxMesh * > &mesh_list )
{ FUNC_ENTER("NxStripper::GetMeshList"); 
	mesh_list = m_Meshes;
}
