/*
	AnimTol.h
	AnimTol.ini File Format Structures
	4-10-01
*/

#ifndef __ANIMTOL__
#define __ANIMTOL__

#include "max.h"
#include "misc/llist.h"

#define vANITOL_ROTATION_TOKEN       "rotations"
#define vANITOL_TRANSLATION_TOKEN    "translations"

enum AniTolFileState
{
	vROTATION,
	vTRANSLATION,
};

struct TolRecord
{
	CStr  name;
	bool  bHasTran;
	bool  bHasRot;
	float valTran;
	float valRot;
	bool  bRotPreset;		// True if using a rotation preset (manual otherwise)
	bool  bTranPreset;		// True if using a translation preset (manual otherwise)
	CStr  rotPresetName;	// Rotation preset name
	CStr  tranPresetName;	// Translation preset name

	TolRecord()
	{
		bHasTran=false;
		bHasRot=false;
		valTran=0.0f;
		valRot=0.0f;
		bRotPreset=false;
		bTranPreset=false;
	}

	bool operator==(TolRecord& right)
	{
		if (name==right.name)
			return true;

		return false;
	}
};

struct GlobalTolRecord
{
	CStr                name;
	LinkList<TolRecord> DB;	

	bool operator==(GlobalTolRecord& right)
	{
		if (name==right.name)
			return true;

		return false;
	}
};

class AnimSubTolFile
{
public:
	LinkList<TolRecord> rotDB;
	LinkList<TolRecord> tranDB;

	AnimSubTolFile(char* Filename);
	AnimSubTolFile();
	~AnimSubTolFile();

	void Reset();
	bool Load(char* Filename);
	bool Load(FILE* fp);
	bool Save(char* Filename);
	bool Save(FILE* fp);
};

class TolData
{
public:
	LinkList<TolRecord> DB;

	void Reset();
	bool Load(char* Filename);
	bool Load(FILE* fp);
	bool Save(char* Filename);
	bool Save(FILE* fp);
};

class AnimTolFile
{
public:
	LinkList<GlobalTolRecord> DB;	// Rotation entries

	AnimTolFile(char* Filename);
	AnimTolFile();
	~AnimTolFile();

	void Reset();
	bool Load(char* Filename);
	bool Load(FILE* fp);
	bool Save(char* Filename);
	bool Save(FILE* fp);
};

#endif
