#include "FuncEnter.h"

/**********************************************************************
 *<
	FILE: DllEntry.cpp

	DESCRIPTION: Contains the Dll Entry stuff

	CREATED BY: 

	HISTORY: 

 *>	Copyright (c) 2000, All Rights Reserved.
 **********************************************************************/
#include "NExt.h"
#include "misc/BrandCheck.h"

//#define DISABLE_EDITABLE_MESH

extern ClassDesc2* GetNExtDesc( void );
extern ClassDesc* GetEditMeshModDesc( void );
extern ClassDesc2* GetNExtMatDesc( void );
extern ClassDesc* GetLinkObjClassDesc( void );
extern ClassDesc* GetLinkUIDesc( void );
extern ClassDesc* GetExportUIDesc( void );
extern ClassDesc* GetTriggerClassDesc( void );
extern ClassDesc2* GetTestPlugDesc( void );
extern ClassDesc2* GetRailToolDesc( void );
extern ClassDesc* GetNExtTextureDesc( void );
extern ClassDesc* GetPurgeMaterialsClassDesc( void );
extern ClassDesc* GetMultiDesc( void );
extern ClassDesc* GetHideTriggerClassDesc( void );
extern ClassDesc* GetPivotDesc( void );
//extern ClassDesc2* GetEditablePolyDesc( void );
extern ClassDesc2* GetMergeToolDesc( void );
extern ClassDesc2* GetFlagReassignerDesc( void );
extern ClassDesc2* GetNExtViewportTexDesc( void );
extern ClassDesc2* GetDebugToolDesc( void );
extern ClassDesc2* GetGapToolDesc( void );
extern ClassDesc2* GetScreenFXObjDesc( void );
extern ClassDesc2* GetPieceBrowserObjDesc( void );
extern ClassDesc* GetTriggerSnapDesc( void );
extern ClassDesc2* GetFindMapToolDesc( void );
extern ClassDesc2* GetAnimStoreClassDesc( void );
extern ClassDesc2* GetFaceFlaggerDesc( void );
extern ClassDesc2* GetCutsceneExporterDesc( void );
extern ClassDesc2* GetOverlapToolDesc( void );
extern ClassDesc* GetNExtAnimatedTextureDesc( void );
extern ClassDesc* GetNExtParticleDesc( void );
extern ClassDesc* GetNExtParticleBoxDesc( void );
extern ClassDesc* GetIPosCtrlDesc( void );
extern ClassDesc* GetIPoint3CtrlDesc( void );
extern ClassDesc* GetIColorCtrlDesc( void );
extern ClassDesc* GetLocalEulerCtrlDesc( void );
extern ClassDesc2* GetLODModClassDesc( void );
extern ClassDesc2* GetLODModClientClassDesc( void );
extern ClassDesc* GetMtlEditorDesc( void );

CRITICAL_SECTION gCriticalSection;

HINSTANCE hInstance;
int controlsInit = FALSE;
int enabled = FALSE;
int refCount = 0;

// This function is called by Windows when the DLL is loaded.  This 
// function may also be called many times during time critical operations
// like rendering.  Therefore developers need to be careful what they
// do inside this function.  In the code below, note how after the DLL is
// loaded the first time only a few statements are executed.

BOOL WINAPI DllMain(HINSTANCE hinstDLL,ULONG fdwReason,LPVOID lpvReserved)
{ FUNC_ENTER("DllMain"); 
	hInstance = hinstDLL;				// Hang on to this DLL's instance handle.

	if (!controlsInit) {
		controlsInit = TRUE;

		// See if the editable mesh is enabled
		enabled = GetSystemSetting(SYSSET_ENABLE_EDITABLEMESH);

		InitCustomControls(hInstance);	// Initialize MAX's custom controls
		InitCommonControls();			// Initialize Win95 controls

		// Register us as the editable tri object.
		if (enabled) {
#ifndef DISABLE_EDITABLE_MESH
			RegisterEditTriObjDesc(GetEditTriObjectDesc());	
			RegisterStaticEditTri (statob.GetEditTriOb ());
#endif

			// Register us as the editable poly object?
			// DISABLED: Until IFaceDataMgr is supported or workaround written  aml
			// IFaceDataMgr is supported in MAX 5
			//RegisterEditPolyObjDesc (GetEditablePolyDesc());
		}			
	}
			
	switch(fdwReason)
	{
	case DLL_PROCESS_ATTACH:
#ifdef __SHOW_WARNING__
		if (!VerifyAuthenticity())
		{
			char   userName[256];
			DWORD  bufSize = 255;
			GetUserName(userName, &bufSize);
			CStr strUserName = userName;
			strUserName.toLower();

			if (strUserName != CStr("adam"))
				MessageBox(GetCOREInterface()->GetMAXHWnd(), "WARNING!  You are using a BETA version of Next.gup.", "File Not Branded", MB_ICONWARNING);
		}
#endif

		refCount++;
		if (refCount==1)
			InitializeCriticalSection(&gCriticalSection);
		break;

	case DLL_PROCESS_DETACH:
		refCount--;
		if (refCount==0)
			DeleteCriticalSection(&gCriticalSection);
	}

	return (TRUE);
}

// This function returns a string that describes the DLL and where the user
// could purchase the DLL if they don't have it.
__declspec( dllexport ) const TCHAR* LibDescription()
{ FUNC_ENTER("LibDescription"); 
	return GetString(IDS_LIBDESCRIPTION);
}

// This function returns the number of plug-in classes this DLL
//TODO: Must change this number when adding a new class
__declspec( dllexport ) int LibNumberClasses()
{ FUNC_ENTER("LibNumberClasses"); 
#ifdef DISABLE_EDITABLE_MESH
	return 36;
#else
	return 37;
#endif
}

// This function returns the number of plug-in classes this DLL
__declspec( dllexport ) ClassDesc* LibClassDesc(int i)
{ FUNC_ENTER("LibClassDesc"); 
	switch(i) {
		//case 0: return GetMtlEditorDesc();
		case 0: return GetNExtDesc();
		case 1: return GetEditMeshModDesc();
		case 2: return GetNExtMatDesc();
		case 3: return GetLinkObjClassDesc();
		case 4: return GetLinkUIDesc();
		case 5: return GetTriggerClassDesc();
		case 6: return GetExportUIDesc();
		case 7: return GetTestPlugDesc();
		case 8: return GetNExtTextureDesc();
		case 9: return GetPurgeMaterialsClassDesc();
		case 10: return GetMultiDesc();
		case 11: return GetHideTriggerClassDesc();
		//case 13: return GetRailToolDesc();		// No longer applicable
		case 12: return GetPivotDesc();
		case 13: return GetMergeToolDesc();
		case 14: return GetFlagReassignerDesc();
		case 15: return GetNExtViewportTexDesc();
		case 16: return GetDebugToolDesc();
		case 17: return GetGapToolDesc();
		case 18: return GetScreenFXObjDesc();
		case 19: return GetPieceBrowserObjDesc();
		case 20: return GetTriggerSnapDesc();
		case 21: return GetFindMapToolDesc();
		case 22: return GetAnimStoreClassDesc();
		case 23: return GetFaceFlaggerDesc();
		case 24: return GetCutsceneExporterDesc();
		case 25: return GetOverlapToolDesc();
		case 26: return GetNExtAnimatedTextureDesc();
		case 27: return GetNExtParticleDesc();
		case 28: return GetNExtParticleBoxDesc();
		case 29: return GetIPosCtrlDesc();
		case 30: return GetIPoint3CtrlDesc();
		case 31: return GetIColorCtrlDesc();
		case 32: return GetLocalEulerCtrlDesc();
		case 33: return GetLODModClassDesc();
		case 34: return GetLODModClientClassDesc();
		case 35: return GetMtlEditorDesc();
#ifndef DISABLE_EDITABLE_MESH
		case 36: return GetEditTriObjectDesc();
#endif

		// DISABLED: Until IFaceDataMgr is supported or workaround written  aml
		//case 26: return GetEditablePolyDesc();		// IFaceDataMgr supported in MAX 5 on MNMesh
		default: return 0;
	}
}

// This function returns a pre-defined constant indicating the version of 
// the system under which it was compiled.  It is used to allow the system
// to catch obsolete DLLs.
__declspec( dllexport ) ULONG LibVersion()
{ FUNC_ENTER("LibVersion"); 
	return VERSION_3DSMAX;
}

TCHAR *GetString(int id)
{ FUNC_ENTER("GetString"); 
	static TCHAR buf[256];

	if (hInstance)
		return LoadString(hInstance, id, buf, sizeof(buf)) ? buf : NULL;
	return NULL;
}

Object *StaticObject::GetEditTriOb () { FUNC_ENTER("StaticObject::GetEditTriOb"); 
	if (!ob) ob = (Object *) GetEditTriObjDesc()->Create ();
	return ob;
}

static StaticObject statob;