/*
	ToolTip.cpp
	Adam Lippmann
	12-11-01
*/

#include "ToolTip.h"

#define TOOLTIP_NAME  "NToolTip"
#define BACKCOLOR     RGB(216,224,121)

ToolTip::ToolTip(HINSTANCE hInstance)
{
	hBrush=CreateSolidBrush(BACKCOLOR);

	wndClass.style=CS_HREDRAW|CS_VREDRAW;
	wndClass.lpfnWndProc=WndProc;
	wndClass.cbClsExtra=0;
	wndClass.cbWndExtra=0;
	wndClass.hInstance=hInstance;
	wndClass.hIcon=NULL;
	wndClass.hCursor=LoadCursor(NULL,IDC_ARROW);
	wndClass.hbrBackground=hBrush;
	wndClass.lpszMenuName=NULL;
	wndClass.lpszClassName=TOOLTIP_NAME;

	RegisterClass(&wndClass);

	// Switch to a more visually appealing font
	hFont=CreateFont(  15,					 // log height
					    8,		 		     // log width
						0,				     // Escapement
						0,				     // Orientation
						FW_THIN,		     // Font Light
						FALSE,			     // Italic
						FALSE,			     // Underline
						FALSE,				 // Strikeout
						ANSI_CHARSET,		 // Character Set
						OUT_DEFAULT_PRECIS,  // Output precision
						CLIP_DEFAULT_PRECIS, // Clipping precision
						DEFAULT_QUALITY,     // Output Quality
						FF_ROMAN,            // Pitch and family
						"MS Serif");

	this->hInstance=hInstance;
	hwnd=NULL;
	text=NULL;
}

ToolTip::~ToolTip()
{
	DeleteObject(hBrush);
	DestroyWindow(hwnd);

	DeleteObject(hFont);

	if (text)
		delete [] text;
}

LRESULT ToolTip::WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	PAINTSTRUCT ps;
	HDC hdc;
	
	RECT oldRect;
	RECT tmpRect;
	RECT rect;

	ToolTip* pToolTip=(ToolTip*)GetWindowLong(hwnd,GWL_USERDATA);
	char*    str;

	if (pToolTip)
		str = pToolTip->text;

	GetClientRect(hwnd,&rect);

	switch(msg)
	{
	case WM_CREATE:
		return TRUE;

	case WM_DESTROY:
		return TRUE;

	case WM_LBUTTONDOWN:
		DestroyWindow(hwnd);
		return TRUE;

	case WM_PAINT:
		{
			hdc=BeginPaint(hwnd,&ps);
			SetBkColor(hdc,BACKCOLOR);

			// Save previous rect to see if DrawText updated the display region
			oldRect=rect;
			SelectObject(hdc,pToolTip->hFont);
		
			//GetWindowRect(hwnd,&tmpRect);
			GetClientRect(hwnd,&tmpRect);

			/*
			// Resize the window to fit appropriately with the text
			if (oldRect.top    !=rect.top    ||
				oldRect.left   !=rect.left   ||
				oldRect.bottom !=rect.bottom ||
				oldRect.right  !=rect.right)
			{
				MoveWindow(hwnd,
						   tmpRect.left,tmpRect.top,
						   rect.right,rect.bottom,
						   TRUE);
			}
			*/

			// Draw the text in the correctly sized window
			DrawText(hdc,str,strlen(str),&tmpRect,DT_TOP|DT_LEFT|DT_WORDBREAK);

			EndPaint(hwnd,&ps);
		}
	}

	return DefWindowProc(hwnd,msg,wParam,lParam);
}

void ToolTip::CreateTip(char* str,int x,int y,int width,int height)
{
	// If another tooltip is being displayed, get rid of it
	if (hwnd!=NULL)
		DestroyWindow(hwnd);

	if (text)
		delete [] text;

	text = new char[strlen(str)+1];
	strcpy(text,str);

	hwnd=CreateWindow(TOOLTIP_NAME,
		              "",
				      //WS_BORDER|WS_POPUP,
					  WS_DLGFRAME|WS_POPUP,
				      x,y,
				      width,height,
				      NULL,
				      NULL,
				      hInstance,
				      NULL);

	HDC hdc = GetDC(hwnd);
	HDC tmpDC = CreateCompatibleDC(hdc);

	//SelectObject(tmpDC,hFont);

	GetClientRect(hwnd,&rect);

	DrawText(tmpDC,str,strlen(str),&rect,DT_TOP|DT_LEFT|DT_CALCRECT|DT_WORDBREAK);
	DeleteDC(tmpDC);

	ReleaseDC(hwnd,hdc);

	// Compensate for tooltip border
	rect.right+=6;
	rect.bottom+=6;

	DWORD Err=GetLastError();

	SetWindowLong(hwnd,GWL_USERDATA,(LONG)this);

	width  = rect.right-rect.left;
	height = rect.bottom-rect.top;

	// Make sure the tooltip is on top of everything else
	//SetWindowPos(hwnd,HWND_TOPMOST,x,y,rect.right-rect.left,rect.bottom-rect.top,SWP_NOMOVE|SWP_NOSIZE);
	SetWindowPos(hwnd,HWND_TOPMOST,x,y,rect.right,rect.bottom,SWP_NOMOVE|SWP_NOSIZE);

				MoveWindow(hwnd,
						   x,y,
						   rect.right,rect.bottom,
						   TRUE);


	ShowWindow(hwnd,SW_SHOW);
}

void ToolTip::Close()
{
	/*
	if (hwnd)
	{
		RECT winRect;
		GetWindowRect(hwnd,&winRect);
		DestroyWindow(hwnd);
		hwnd = NULL;
		InvalidateRect(NULL,&winRect,TRUE);
	}
	*/

	//if (!hwnd)
	//	DestroyWindow(hwnd);

	ShowWindow(hwnd,SW_HIDE);
}

BOOL ToolTip::IsClosed()
{
	if (!hwnd)
		return TRUE;

	return IsWindowVisible(hwnd);
}