/*
	MultiPropList.h
	Multi-Property List.  This is a property list that has categorical control.
	Visually it's a property list with a MultiList on top that lists out the categories and
	will update the property list to correspond to the selected category, it behaves like
	a standard property list though.  This works functionally the same, but categories are
	defined by /'s between levels for each property name
*/

#ifndef __MULTIPROPLIST__
#define __MULTIPROPLIST__

#include "PropList.h"
#include "MultiList.h"

#define MULTIPROPLIST_CLASSNAME "MultiPropList"

struct PropEntry
{
	CStr      category;
	PropList* proplist;

	int operator== (PropEntry& right)
	{
		return (category == right.category);
	}
};

class MultiPropList: public PropList, public UIControl
{
	// We'll really just maintain a lot of seperate property lists for the display
	MultiList*            mlist;
	LinkList<CStr>        names;			// Names of all properties including path info
	//LinkList< PropEntry > proplists;
	//PropList*             dispList;			// The property list currently being displayed

	HWND                  hwndMultiList;
	HWND                  hwndPropList;		// The window that the current property list is displayed in
	HFONT                 hfNormal;			// Font displayed when all elements are being displayed in list
	HFONT                 hfBold;			// Font displayed when additional elements exist in other categories

	// Creation parameters to be propagated to categorical property lists
	HINSTANCE             hInstance;
	HWND                  hwdParent;
	int                   x,y;
	int                   width, height;
	CStr                  DlgText;
	bool                  bExtCreateMethod;	// True if the extended constructor method was used
	int                   cols;

	LRESULT WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void AssignVisibility();
	void CategoryChange();
	void CategoryChangeNR();

	void BreakPathRoot(CStr& src, CStr& path, CStr& root);

public:
	CLASSNAME(MULTIPROPLIST_CLASSNAME)

	MultiPropList(HINSTANCE hInstance,HWND hwdParent=0,int x=0,int y=0,int width=300,int height=263,CStr DlgText="");
	MultiPropList(HINSTANCE hInstance,int cols);
	~MultiPropList();

	void          BuildNameList();

	void          BuildControlUI();
	void          BuildUI();
	void          DestroyUI();
};

#endif
