/*
	ModalDlg.h
	Creates a modal dialog
	aml - 4-2-01
*/

#ifndef __MODALDLG_H__
#define __MODALDLG_H__

#include <windows.h>

class ModalDlgWindow
{
	static BOOL CALLBACK RedirectDlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
	{
		if (msg==WM_INITDIALOG)
		{
			SetWindowLong(hwnd,GWL_USERDATA,(LONG)lParam);
			ModalDlgWindow* pthis = (ModalDlgWindow*)lParam;
			pthis->hwnd = hwnd;
		}

		ModalDlgWindow* thisclass=(ModalDlgWindow*)GetWindowLong(hwnd,GWL_USERDATA);

		if (thisclass)
			return thisclass->DlgProc(hwnd,msg,wParam,lParam);

		return FALSE;
	}

	LPCSTR    lpTemplate;
	HWND      hWndParent;

protected:
	HINSTANCE hInstance;
	HWND      hwnd;

	inline virtual BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
	{
		return FALSE;
	}

public:
	ModalDlgWindow(HINSTANCE hInstance,
		           LPCTSTR   lpTemplate,
				   HWND      hWndParent)
	{
		this->hInstance=hInstance;
		this->lpTemplate=lpTemplate;
		this->hWndParent=hWndParent;

		//DialogBoxParam(hInstance,lpTemplate,hWndParent,RedirectDlgProc,(LPARAM)this);
	}

	~ModalDlgWindow()
	{
		EndDialog(hwnd,0);
		SetWindowLong(hwnd,GWL_USERDATA,NULL);
	}

	inline int Show() 
	{ 
		return DialogBoxParam(hInstance,lpTemplate,hWndParent,RedirectDlgProc,(LPARAM)this);
	}

	inline void Hide() { ShowWindow(hwnd,SW_HIDE); }
	inline HWND hWnd() { return hwnd; }
};

#endif
