/*
	ColorPopup.h
	Color popup control for manipulating a group of colors
*/

#ifndef __COLORPOPUP__
#define __COLORPOPUP__

#include "UIControl.h"
#include "max.h"
#define CLASSNAME_COLORPOPUP  "ColorPopup"

class PropList;

class ColorPopup: public UIControl
{
	HWND      hwndButton;
	PropList* plist;
	int       numColors;
	CStr      value;
	int       min,max;			// Limits on number of colors

	void Init();

	LRESULT WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	static void PropChangeCB(PropList* plist,void* pData);
	static void PropApplyCB(PropList* plist,void* pData);

public:
	CLASSNAME(CLASSNAME_COLORPOPUP)

	ColorPopup(HINSTANCE hInstance);
	ColorPopup(HINSTANCE hInstance, HWND hwnd);
	~ColorPopup();

	void BuildControlUI();
	void ProcButton();

	void SetLimits(int min,int max);

	CStr GetValue();
	void SetValue(CStr val);
};

#endif
