/*
	TriggerUI.h
	This file contains the UI and assignment system
	for Trigger Objects
	2-13-01
*/

#ifndef __TRIGGERUI__
#define __TRIGGERUI__

#include "../PropEdit/ScriptIniParser.h"
#include "../PropEdit/PropTagParser.h"
#include "../PropEdit/PropBufGen.h"
#include "../PropEdit/ConfigData.h"
#include "../Link/LinkMan.h"
#include "TriggerLayout.h"

class Trigger;

struct TriggerUIData
{
	bool  bLinkLast;		// Link the last trigger to the next created trigger
	bool  bAssignProps;		// Property values will be assigned to new objects
	bool  bShowNames;		// True if names should be shown
};

struct ExtTriggerData
{
	char     name[256];
	COLORREF color;
};

//class TriggerUI: public PropTagParser, public PropBufGen, public TriggerLayout
class TriggerUI: public PropTagParser, public TriggerLayout
{
	// Rollouts
	HWND          hwndUI;		// Main User Interface for trigger creation (w/ mini prop editor)

	IColorSwatch* IColor;		// Color Control defining the color all future trigger objects should be created as
	ICustEdit*    IEdit;

	PropList*     propList;		// Property list used for the mini property editor
	Interface*    ip;			// MAX Interface pointer
	INode*        contNode;		// node containing the trigger
	INode*        lastNode;		// The last selected node to link to

	CStr          propBuf;		// Current property buffer to acquire settings from
								// if this has 0 length, they are retrieved from scripts.ini

	CStr          strClass;		// Object Class name
	CStr          strType;		// Object Type name
	DWORD         flags;		// Object flags
	CStr          strCmds;		// Unrecognized commands
	CStr          strCluster;	// Cluster object name (if TrickObject)
	
	LinkList<ConfigProgram> programs;   // The MAXScript update scripts for the Class/Type
	LinkList<ConfigProp> props;

	static void ChangeCB(PropList* plist,void* pData);		// Property list change callback

	static BOOL CALLBACK DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);
	void   UpdateClassSel(bool bUpdateChunk=true);
	void   UpdateTypeSel(bool bUpdateChunk=true);
	void   UpdateTriggerSettings();
	void   UpdateChunk();
	void   UpdateExtData();
	void   GetExtData();

	CStr   GetClass();
	CStr   GetType();

protected:
	bool  bLinkLast;	// The last trigger created will be linked to this new trigger
	bool  bShowNames;	// Names of the trigger class and type will be displayed in viewport
	bool  bAssignProps;	// Property values will be assigned to new objects


   void BeginEditParams(IObjParam *ip, ULONG flags, Animatable *prev);
   void EndEditParams(IObjParam *ip, ULONG flags, Animatable *next);

   void TriggerCreated(RefMakerHandle rm);

public:
	void TriggerLink(BOOL endOfChain);

	static void DestroyRetainedData();

	TriggerUI(Interface* ip);
	~TriggerUI();
};

#endif
