/*
	PropTagParser.h
	This class includes functionality to parse extended
	property tags into property lists

	2-13-01
*/

#ifndef __PROPERTYTAGPARSER__
#define __PROPERTYTAGPARSER__

#include "../UI/PropList.h"
#include "../PropEdit/ConfigData.h"

class PropTagParser
{
public:
	PropTagParser();
	~PropTagParser();

	void BuildPropList(PropList* plist,LinkList<ConfigProp>* cprops);
	bool ParsePropTags(char* buf,CStr name,CStr& strDesc,CStr& strDefault);

	bool ParseExtendedTags(PropList* plist,
		                   char* loc,
		                   CStr strType,CStr strName,
						   CStr strDesc,CStr strDefault=CStr(""));// Parses tags specific to the propery editor not AutoDuck

	bool ParseScriptTags(PropList* plist,CStr Filename,CStr Keyword);
};

#endif
