/*
	NodeRename.cpp
	Node Renaming Dialog
	1-28-01
*/

#include "NodeRename.h"
#include "Resource.h"

NodeRenameDlg::NodeRenameDlg(HINSTANCE hInstance,HWND hwndParent) :
	MSDlgWindow(hInstance,MAKEINTRESOURCE(IDD_NODERENAME),hwndParent)
{
	IEdit=GetICustEdit(GetDlgItem(hwnd,IDC_EDITNODENAME));
}

NodeRenameDlg::~NodeRenameDlg()
{
	ReleaseICustEdit(IEdit);
}

BOOL NodeRenameDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_ACTIVATE:
		if (LOWORD(wParam)==WA_INACTIVE)
			EnableAccelerators();
		else
			DisableAccelerators();
		
		return TRUE;

	case WM_CUSTEDIT_ENTER:
		Hide();
		if (fpOKCB)
			fpOKCB(this,pOKData);

		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
			Hide();
			if (fpOKCB)
				fpOKCB(this,pOKData);

			return TRUE;

		case IDCANCEL:
			Hide();
			return TRUE;
		}
		return TRUE;

	case WM_CLOSE:
		Hide();
		return TRUE;
	}

	return FALSE;
}

void NodeRenameDlg::RegOKCB(void(*Func)(NodeRenameDlg*,void*),void* pData)
{
	fpOKCB=Func;
	pOKData=pData;
}

CStr NodeRenameDlg::GetNodeName()
{
	char buf[256];
	IEdit->GetText(buf,255);

	return CStr(buf);
}

void NodeRenameDlg::SetNodeName(CStr name)
{
	IEdit->SetText((char*)name);
}
