/*
	LODBrowser.h
	LOD Browser popup window
	6-7-01
*/

#ifndef __LODBROWSER__
#define __LODBROWSER__

#include "../UI/MSWindow.h"
#include "../Export/Export.h"
#include "max.h"

class PropList;
class PropEditor;

class LODBrowser: public MSDlgWindow
{
	Interface*  ip;
	PropList*   plist;
	int         numLODs;
	INode*      nodeMaster;
	PropEditor* pe;
	bool        bListUpdateLock;
	HMENU       hPopupMenu;				// The popup menu when you right click
	HMENU       hPopupSubMenu;			// The actual menu in the popup menu containing the selections
	bool        bLockShow;

	LinkList<CStr> lastLODlist;			// List containing all the last settings of the LOD list

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	static void ListUpdate(PropList* plist,void* pdata);

	INode* GetNodeMaster();
	void   ReadLODData();
	void   StoreLODData();
	void   SelMaster();

	void UpdateLODDynUI(CStr& propBuffer);
	void RemoveLevels(CStr& propBuffer);

	static void SelChange(void *param, NotifyInfo *info);

	static LRESULT SubPropProc(PropList* plist,HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam,void* pData);

public:
	enum
	{
		LODTYPE_MASTER,
		LODTYPE_SLAVE,
		LODTYPE_NONE,
	};

	LODBrowser(HINSTANCE hInstance,HWND hwndParent,Interface* ip,PropEditor* pe);
	~LODBrowser();

	void AddLOD();
	void RemoveLOD(int id);
	void Show();
	void Hide();
	void SelChildren();

	bool IsActive();

	static bool   UpdateLODs(LinkList<ConfigProp>* list,PropList* plist,INode* nodeApply);
	static int    GetNumLODLevels(INode* node);
	static void   GetLODLevels(INode* node, NxLODLevel* levels);
	static int    GetLODType(INode* node);
	static INode* GetLODMaster(INode* node);

	inline HWND GetHWND() { return hwnd; }
};

#endif
