/*
	ConfigData.cpp

	Functions to parse configuration data (property, etc.) into lists
*/

#include "ConfigData.h"
#include "PropBufGen.h"
#include "ParseFuncs.h"

//CStr ParseScriptProps(LinkList<ConfigClass>* cclist,CStr fileBuffer)
//{
//
//}

bool GetProgram(CStr& lineBuf,LinkList<ConfigProgram>* list)
{
	if (!list)
		return false;

	CStr lcLineBuf=lineBuf;
	lcLineBuf.toLower();

	ConfigProgram cprog;

	int   pos = Instr(lineBuf,"// @program |");

	if (pos==-1)
		return false;

	CStr buf;
	pos+=14;
	buf = GetRemainLinePartial(lineBuf,&pos);

	char val[512];
	GetOption(buf,val,'|',0);
	StripToken(val);
	cprog.filename = val;

	GetOption(buf,val,'|',1);

	if (val)
	{
		StripToken(val);
		cprog.scriptContext = val;
	}

	list->AddToTail(&cprog);

	return true;
}

CStr GetCluster(CStr& lineBuf)
{
	CStr lcLineBuf=lineBuf;
	lcLineBuf.toLower();
	
	int TrickObjPos=Instr(lcLineBuf,"trickobject");
	int ClusterPos=Instr(lcLineBuf,"cluster");
	int EqPos=Instr(lineBuf,"=");

	if (TrickObjPos>-1         &&
		ClusterPos>-1          &&
		EqPos>-1               &&
		ClusterPos>TrickObjPos &&
		EqPos>TrickObjPos)
	{
		return StripLeft(lineBuf.Substr(EqPos+1,lineBuf.Length()));
	}

	return CStr("");
}

bool HasAutoDuck(char* str)
{
	if (Instr(str,"// @")!=-1)
		return true;

	return false;
}

void AttachExtendedData(LinkList<ConfigProp>* cplist,CStr& buf)
{
	CStr strAutoDuck=buf;
	int  buflen=strAutoDuck.Length();

	Link<ConfigProp>* curNode=cplist->GetHead();

	while(curNode)
	{
		// Build up lines in the buffer that relate to this particular property
		int pos=0;

		while(pos<buflen)
		{
			CStr strTemp=GetRemainLinePartial(strAutoDuck,&pos);
			CStr strSearch;
			
			for(int i=0;i<5;i++)
			{
				switch(i)
				{
				case 0:
					strSearch=CStr("// @nextparm | ")+curNode->data.name;
					break;
				case 1:
					strSearch=CStr("// @nextdesc | ")+curNode->data.name;
					break;
				case 2:
					strSearch=CStr("// @nextdef | ")+curNode->data.name;
					break;
				case 3:
					strSearch=CStr("// @nextint | ")+curNode->data.name;
					break;
				case 4:
					strSearch=CStr("// @nextintdef | ")+curNode->data.name;
					break;
				}

				if (Instr(strTemp,strSearch)!=-1)
					curNode->data.extdata+=strTemp+CStr("\r\n");
			}
		}

		curNode=curNode->next;
	}
}

CStr ParseConfigProps(LinkList<ConfigProp>* cplist,DWORD* flags,CStr& propBuffer,CStr* unkBuf,CStr* clusterBuf,LinkList<ConfigProgram>* programs,
					  LinkList<ConfigScript>* scriptList)
{
	int   len=propBuffer.Length();
	int   lastpos=0,origpos=0,pos=0,pos2;
	CStr  scriptBuffer;
	CStr  strCmds;
	CStr  strCmdsAD;
	CStr  strName;
	CStr  strValue;
	CStr  lineBuf;
	CStr  stripLineBuf;
	CStr  word;
	CStr  strCluster;
	char  token[512];
	char  eol[]="\r\n";

	if (unkBuf)
		*unkBuf="";

	if (clusterBuf)
		*clusterBuf="";

	if (flags)
		*flags=0;

	if (programs)
		programs->Clear();

	if (cplist)
		cplist->Clear();

	if (scriptList)
		scriptList->Clear();

	while(pos<len)
	{
		origpos=pos;
		lineBuf=GetRemainLinePartial(propBuffer,&pos);

		// Check flags
		// Flags can now only be accepted if they are the only line contents
		stripLineBuf=StripLeft(lineBuf);
		
		if (flags)
		{
			if (stripLineBuf==CStr("CreatedAtStart"))
			{
				(*flags)|=CCLASS_CREATEDATSTART;
				continue;
			}
			if (stripLineBuf==CStr("AbsentInNetGames"))
			{
				(*flags)|=CCLASS_ABSENTINNETGAMES;
				continue;
			}
			if (stripLineBuf==CStr("TrickObject"))
			{
				(*flags)|=CCLASS_TRICKOBJECT;
				continue;
			}
			if (stripLineBuf==CStr("Occluder"))
			{
				(*flags)|=CCLASS_OCCLUDER;
				continue;
			}
		}

		// Check default properties
		// If there is one (and only one) = and only 2 or 3 words
		// It's a default parameter, otherwise, it's a command string
		CStr leftEq;
		int  EqPos=Instr(lineBuf,"=");

		if (EqPos>0)
			leftEq=Left(lineBuf,EqPos-1);
		
		// This will force lines with x=y to x = y while not changiing x = y to x  =  y
		lineBuf=ReplaceStr(lineBuf," = ","=");
		lineBuf=ReplaceStr(lineBuf,"="," = ");
		//int words=NumWords(lineBuf);
		//if (CountChar(lineBuf,'=')==1 && (words==2 || words==3))

		if (CountChar(lineBuf,'=')==1 && NumWords(leftEq)==1)
		{
			pos2=Instr(lineBuf,"=");

			if (pos2!=-1)
			{
				// Get property name (left of ='s)
				strName=Left(lineBuf,pos2);
				strcpy(token,strName);
				StripToken(token);
				strName=token;

				// Get property value (right of ='s)
				strValue=lineBuf.Substr(pos2+1,lineBuf.Length());
				strcpy(token,strValue);
				StripToken(token);
				strValue=token;

				// If the value is blank it may have been dropped through multiple lines
				// or it may just not equal anything (error condition).

				// unfortunately this means we also have to handle nesting of brackets
				// and potential syntax errors
				if (IsBlank(strValue))
				{
					int oldpos=pos;
					int nstart=GetNestStart(propBuffer,&pos);

					if (nstart==-1)
						pos=oldpos;
					else
					{
						strValue=GetGroup(propBuffer,&pos);
						strValue=OneLineConvert(strValue);
						pos++;

						if (strValue==CStr(""))
							pos=oldpos;
					}
				}

				// Don't add Class and Type they're added elsewhere
				if (strName!=CStr("Class") &&
					strName!=CStr("class") &&
					strName!=CStr("Type")  &&
					strName!=CStr("type"))
				{
					if (cplist)
					{
						// Add default parameter
						ConfigProp cprop;

						cprop.name =strName;
						cprop.value=strValue;
						cplist->Add(&cprop);
					}
				}
			}
		}
		else
		{
			lastpos=pos;
			pos=origpos;
			if (GetToken(propBuffer,&pos,token," \n\t"))
			{
				StripToken(token);
				word=CStr(token);

				// Check script buffer
				if (word==CStr("script"))
				{
					// Extract the script
					word=GetRemainLineExact(propBuffer,&pos);

					while(word!=CStr("endscript") && pos<propBuffer.Length())
					{
						scriptBuffer+=word;
						scriptBuffer+=CStr(eol);

						word=GetRemainLineExact(propBuffer,&pos);
					}
				}
				else if (word==CStr("altscript"))
				{
					ConfigScript cscript;

					//GetToken(propBuffer,&pos,token," ");
					//StripToken(token);
					//cscript.name     = token;
					//cscript.filename = GetRemainLineExact(propBuffer,&pos);
					cscript.name = GetRemainLineExact(propBuffer,&pos);
					
					word = GetRemainLineExact(propBuffer,&pos);

					while(word!=CStr("endscript") && pos<propBuffer.Length())
					{
						cscript.buffer += word;
						cscript.buffer += CStr(eol);

						word = GetRemainLineExact(propBuffer,&pos);
					}

					if (scriptList)
						scriptList->AddUnique(&cscript);
				}
				else
				{
					// Check Unknown commands
					// Line must represent command
					// Readvance position and add it to the command buffer
					pos=lastpos;

					// Check for @program lines
					if (!GetProgram(lineBuf,programs))
					{
						// Check for TrickObject Cluster= lines
						if (clusterBuf)
						{
							CStr cluster;

							if (lineBuf.Length()>0)
							{
								cluster=GetCluster(lineBuf);

								if (cluster.Length()>0)
								{
									if (flags)
										(*flags)|=CCLASS_TRICKOBJECT;

									*clusterBuf=cluster;
								}
								else
								{
									if (HasAutoDuck(lineBuf))
										strCmdsAD+=lineBuf+CStr(eol);
									else
										strCmds+=lineBuf+CStr(eol);
								}
							}

						}
						else
							if (lineBuf.Length()>0)
							{
								if (HasAutoDuck(lineBuf))
									strCmdsAD+=lineBuf+CStr(eol);
								else
									strCmds+=lineBuf+CStr(eol);
							}
					}
				}
			}
			else
			{
				if (cplist)
					AttachExtendedData(cplist,strCmdsAD);

				if (unkBuf)
					*unkBuf=strCmds;

				return scriptBuffer;
			}
		}
	}

	if (cplist)
		AttachExtendedData(cplist,strCmdsAD);

	if (unkBuf)
		*unkBuf=strCmds;

	return scriptBuffer;
}

void ParseReqScripts(LinkList<CStr>* list,CStr& propBuffer)
{
	int pos = 0;
	int len = propBuffer.Length();

	char token[512];
	CStr word;

	while(pos<len)
	{
		if (GetToken(propBuffer,&pos,token," \n\t"))
		{
			StripToken(token);
			word = token;

			if (word == CStr("altscript"))
			{
				GetToken(propBuffer,&pos,token," ");		// Skip the script name
			
				CStr filename = GetRemainLineExact(propBuffer,&pos);
				list->Add(&filename);
			}
		}
	}
}

// Use this as opposed to MAX's GetUserPropString to get a value that may contain spaces
CStr GetPropValue(INode* node, CStr propName)
{
	CStr propBuffer;
	LinkList<ConfigProp> cprops;

	node->GetUserPropBuffer(propBuffer);
	ParseConfigProps(&cprops,NULL,propBuffer);
	
	Link<ConfigProp>* curnode=cprops.GetHead();

	while(curnode)
	{
		if (curnode->data.name==propName)
			return curnode->data.value;

		curnode=curnode->next;
	}

	return CStr("");
}

// Breaks an array (fmt [ 1 2 3 4 ]) or (fmt [ 1, 2, dsasdf, 5 ]), etc. into it's components
void ParseArray(LinkList<CStr>* list,CStr value)
{
	list->Clear();

	CStr nameRun;
	bool bStart=false;
	bool bInRun=false;

	for(int i=0;i<value.Length();i++)
	{
		if (value[i]=='[')
		{
			bStart=true;
			continue;
		}

		if (bStart)
		{
			if (value[i]==']')
			{
				// Add final element if in run
				if (bInRun)
				{
					list->AddToTail(&nameRun);
					nameRun="";
					bInRun=false;
				}
				break;
			}

			if (value[i]==' ' || value[i]==',')
			{
				if (bInRun)
				{
					list->AddToTail(&nameRun);
					nameRun="";
					bInRun=false;
				}
			}
			else
			{
				char tmpStr[2];
				tmpStr[0]=value[i];
				tmpStr[1]=0;

				nameRun+=tmpStr;
				bInRun=true;
			}
		}
	}
}

CStr GetClassName(CStr propBuffer)
{
	CStr propCopy=propBuffer;
	propCopy.toLower();

	int pos=Instr(propCopy,"class");

	if (pos!=-1)
	{
		pos=Instr(propCopy,"=",pos);
		pos++;
		
		return StripLeft(GetRemainLinePartial(propBuffer,&pos));
	}

	return CStr("");
}

CStr GetTypeName(CStr propBuffer)
{
	CStr propCopy=propBuffer;
	propCopy.toLower();

	int pos=Instr(propCopy,"type");

	if (pos!=-1)
	{
		pos=Instr(propCopy,"=",pos);
		if (pos == -1)
			return CStr("");
		
		pos++;
		
		return StripLeft(GetRemainLinePartial(propBuffer,&pos));
	}

	return CStr("");	
}

bool RemovePropBufProp(INode* node, CStr propName)
{
	CStr propBuffer;
	bool bFoundProp = false;
	node->GetUserPropBuffer(propBuffer);

	LinkList<CStr> listLines;

	PropBufGen::BuildList(&listLines,propBuffer);

	Link<CStr>* curline = listLines.GetHead();
	Link<CStr>* nextline;

	while(curline)
	{
		nextline = curline->next;

		int pos = Instr(curline->data,propName);

		if (pos != -1)
		{
			// See if the next non space character is an equal sign
			for(int i=pos+propName.Length();i<curline->data.Length();i++)
			{
				if (curline->data[i] != ' ')
				{
					if (curline->data[i] == '=')
					{
						// We've found a line containing the property (remove it)
						bFoundProp = true;
						listLines.Remove(curline);
					}

					// This is not a valid property definition (next line)
					break;
				}
			}
		}

		curline = nextline;
	}

	// We've scanned through the buffer removing all lines containing the given property
	// reassemble the buffer and exit
	propBuffer = PropBufGen::BuildBufCRLF(&listLines);
	node->SetUserPropBuffer(propBuffer);

	return bFoundProp;
}

/*
CStr ParseConfigProps(LinkList<ConfigProp>* cplist,DWORD* flags,CStr propBuffer)
{
	int   len=propBuffer.Length();
	int   pos=0,pos2;
	CStr  word,word2;
	CStr  scriptBuffer;
	char  token[512];
	char  eol[]="\r\n";

	*flags=0;
	cplist->Clear();

	while(GetToken(propBuffer,&pos,token," \n\t"))
	{
		StripToken(token);
		word=CStr(token);

		// Scan ahead for '=' token
		pos2=pos;
		GetToken(propBuffer,&pos2,token," \n\t");
		StripToken(token);

		if (token[0]=='=')
		{
			ConfigProp cprop;

			// Extract property
			pos=pos2;
			word2=GetRemainLinePartial(propBuffer,&pos);

			// Don't add Class and Type they're added elsewhere
			if (word!=CStr("Class") &&
				word!=CStr("class") &&
				word!=CStr("Type")  &&
				word!=CStr("type"))
			{
				cprop.name =word;
				cprop.value=word2;
				cplist->Add(&cprop);
			}

			continue;
		}

		if (word==CStr("script"))
		{
			// Extract the script
			word=GetRemainLineExact(propBuffer,&pos);

			while(word!=CStr("endscript"))
			{
				scriptBuffer+=word;
				scriptBuffer+=CStr(eol);

				word=GetRemainLineExact(propBuffer,&pos);
			}

			break;
		}

		if (word==CStr("CreatedAtStart"))
			(*flags)|=CCLASS_CREATEDATSTART;

		if (word==CStr("AbsentInNetGames"))
			(*flags)|=CCLASS_ABSENTINNETGAMES;

		if (word==CStr("TrickObject"))
			(*flags)|=CCLASS_TRICKOBJECT;
	}

	return scriptBuffer;
}
*/

