/*
	AddPropDlg.h
	Add User Property Dialog
	1-24-01
*/

#ifndef __ADDPROPDLG__
#define __ADDPROPDLG__

#include "max.h"
#include "../UI/MSWindow.h"
#include "../UI/PropList.h"

class AddPropDlg: public MSDlgWindow
{
	void (*fpOkCB)(AddPropDlg*,void*);			// Callback called when OK button pressed
	void* pOkCBData;							// Callback retained data

	int   iUserData;
	CStr  strUserData;

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	bool CorrectText();							// Removes invalid characters from text

public:
	AddPropDlg(HINSTANCE hInstance,HWND hwndParent);
	~AddPropDlg();

	void SetOKCB(void(*func)(AddPropDlg*,void*),void* pData);
	CStr     GetProp();
	CStr     GetValue();
	CStr     GetDesc();
	PropType GetType();

	void     SetTitle(CStr str);
	void     SetProp(CStr str);
	void     SetValue(CStr str);
	void     SetDesc(CStr str);
	void     SetType(PropType type);
	
	inline int  GetIntUserData()          { return iUserData; }
	inline void SetIntUserData(int data)  { iUserData=data;   }

	inline CStr GetStrUserData()          { return strUserData; }
	inline void SetStrUserData(CStr str)  { strUserData=str;   }
};

#endif
