#ifndef __EXPORT_SKELETON_H__
#define __EXPORT_SKELETON_H__

#include <next.h>
#include <export/export.h>

// This class should be used so that the animation and skin code
// have the same indexing system to get bone information.
class CSkeletonData
{
	bool bIgnoreLeafs;	// True if export should ignore leaf nodes
						// Added so we could get cams to export as 1 node skeletons

    enum
    {
        vMAX_NODES = 256
    };

public:
    CSkeletonData( INode* pNode, bool bIgnoreLeafs=true );
    int				GetBoneIndex( INode* pNode );
	INode*			GetBone( int index );
	int				GetCount();
    INode*			GetRootBone( INode* pNode );

public:
	// For export...
    unsigned int    GetChecksum();
	unsigned int	GetBoneName( int index );
	unsigned int	GetParentName( int index );
	unsigned int	GetFlipName( int index );
    int				Write( FILE* pFile );

protected:
    void			recursive_add_node( INode* pNode );
    void			print_name_table();
	void			print_debug_file();

protected:
    int				m_numNodes;
    INode*			mp_nodes[vMAX_NODES];
};

#endif // __EXPORT_SKELETON_H__