/**********************************************************************
 *<
	FILE: DllEntry.cpp

	DESCRIPTION: Contains the Dll Entry stuff

	CREATED BY: 

	HISTORY: 

 *>	Copyright (c) 2000, All Rights Reserved.
 **********************************************************************/
#include "NExt.h"

extern ClassDesc2* GetNExtDesc( void );
extern ClassDesc* GetEditMeshModDesc( void );
extern ClassDesc2* GetNExtMatDesc( void );
extern ClassDesc* GetLinkObjClassDesc( void );
extern ClassDesc* GetLinkUIDesc( void );
extern ClassDesc* GetExportUIDesc( void );
extern ClassDesc* GetTriggerClassDesc( void );
extern ClassDesc2* GetTestPlugDesc( void );
extern ClassDesc2* GetRailToolDesc( void );
extern ClassDesc* GetNExtTextureDesc( void );
extern ClassDesc* GetPurgeMaterialsClassDesc( void );
extern ClassDesc* GetMultiDesc( void );
extern ClassDesc* GetHideTriggerClassDesc( void );
extern ClassDesc* GetPivotDesc( void );
extern ClassDesc2* GetEditablePolyDesc( void );
extern ClassDesc2* GetMergeToolDesc( void );
extern ClassDesc2* GetFlagReassignerDesc( void );
extern ClassDesc2* GetNExtViewportTexDesc( void );
extern ClassDesc2* GetDebugToolDesc( void );
extern ClassDesc2* GetGapToolDesc( void );
extern ClassDesc2* GetScreenFXObjDesc( void );

CRITICAL_SECTION gCriticalSection;

HINSTANCE hInstance;
int controlsInit = FALSE;
int enabled = FALSE;
int refCount = 0;

// This function is called by Windows when the DLL is loaded.  This 
// function may also be called many times during time critical operations
// like rendering.  Therefore developers need to be careful what they
// do inside this function.  In the code below, note how after the DLL is
// loaded the first time only a few statements are executed.

BOOL WINAPI DllMain(HINSTANCE hinstDLL,ULONG fdwReason,LPVOID lpvReserved)
{
	hInstance = hinstDLL;				// Hang on to this DLL's instance handle.

	if (!controlsInit) {
		controlsInit = TRUE;

		// See if the editable mesh is enabled
		enabled = GetSystemSetting(SYSSET_ENABLE_EDITABLEMESH);

		InitCustomControls(hInstance);	// Initialize MAX's custom controls
		InitCommonControls();			// Initialize Win95 controls

		// Register us as the editable tri object.
		if (enabled) {
			RegisterEditTriObjDesc(GetEditTriObjectDesc());	
			RegisterStaticEditTri (statob.GetEditTriOb ());

			// Register us as the editable poly object?
			// DISABLED: Until IFaceDataMgr is supported or workaround written  aml
			//RegisterEditPolyObjDesc (GetEditablePolyDesc());
		}			
	}
			
	switch(fdwReason)
	{
	case DLL_PROCESS_ATTACH:
		refCount++;
		if (refCount==1)
			InitializeCriticalSection(&gCriticalSection);
		break;

	case DLL_PROCESS_DETACH:
		refCount--;
		if (refCount==0)
			DeleteCriticalSection(&gCriticalSection);
	}

	return (TRUE);
}

// This function returns a string that describes the DLL and where the user
// could purchase the DLL if they don't have it.
__declspec( dllexport ) const TCHAR* LibDescription()
{
	return GetString(IDS_LIBDESCRIPTION);
}

// This function returns the number of plug-in classes this DLL
//TODO: Must change this number when adding a new class
__declspec( dllexport ) int LibNumberClasses()
{
	return 21;
}

// This function returns the number of plug-in classes this DLL
__declspec( dllexport ) ClassDesc* LibClassDesc(int i)
{
	switch(i) {
		case 0: return GetNExtDesc();
		case 1: return GetEditTriObjectDesc();
		case 2: return GetEditMeshModDesc();
		case 3: return GetNExtMatDesc();
		case 4: return GetLinkObjClassDesc();
		case 5: return GetLinkUIDesc();
		case 6: return GetTriggerClassDesc();
		case 7: return GetExportUIDesc();
		case 8: return GetTestPlugDesc();
		case 9: return GetNExtTextureDesc();
		case 10: return GetPurgeMaterialsClassDesc();
		case 11: return GetMultiDesc();
		case 12: return GetHideTriggerClassDesc();
		case 13: return GetRailToolDesc();
		case 14: return GetPivotDesc();
		case 15: return GetMergeToolDesc();
		case 16: return GetFlagReassignerDesc();
		case 17: return GetNExtViewportTexDesc();
		case 18: return GetDebugToolDesc();
		case 19: return GetGapToolDesc();
		case 20: return GetScreenFXObjDesc();

			// DISABLED: Until IFaceDataMgr is supported or workaround written  aml
			//case 15: return GetEditablePolyDesc();
			
		default: return 0;
	}
}

// This function returns a pre-defined constant indicating the version of 
// the system under which it was compiled.  It is used to allow the system
// to catch obsolete DLLs.
__declspec( dllexport ) ULONG LibVersion()
{
	return VERSION_3DSMAX;
}

TCHAR *GetString(int id)
{
	static TCHAR buf[256];

	if (hInstance)
		return LoadString(hInstance, id, buf, sizeof(buf)) ? buf : NULL;
	return NULL;
}

Object *StaticObject::GetEditTriOb () {
	if (!ob) ob = (Object *) GetEditTriObjDesc()->Create ();
	return ob;
}

static StaticObject statob;