/*
	DebugTool.cpp
	Debugging plugin for Max
	6-17-01
*/

#include "Next.h"
#include "DebugTool.h"
#include "Resource.h"
#include "Appdata.h"
#include "../Wibble/Wibble.h"
#include "modstack.h"

extern Interface* gInterface;

static DebugToolClassDesc theDebugToolDesc;
ClassDesc2* GetDebugToolDesc() { return &theDebugToolDesc; }

void PurgeObjAnimData(INode* root=NULL);
void PurgeWibbleData(INode* root=NULL);
void PurgeWibbleDataSel();
void SelWibbleNodes(INode* root=NULL);
void SaveSelection();
void LoadSelection();
void PurgeAllData(INode* root=NULL);
void PurgeVertColorsChannel(INode* root=NULL,int channel=0);
void PurgeVertColorsSel();
void FixVertColorsSel();

DebugTool::DebugTool()
{

}

DebugTool::~DebugTool()
{

}

BOOL __stdcall DebugTool::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_CREATE:
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_PURGE:
			PurgeObjAnimData();
			MessageBox(gInterface->GetMAXHWnd(),"The object animation data has been purged from the scene","Purge Obj Anim Data",MB_ICONINFORMATION|MB_OK);
			return TRUE;

		case IDC_PURGEALL:
			PurgeAllData();
			return TRUE;


		case IDC_PURGEVERTCOLORS:
			PurgeVertColorsSel();
			return TRUE;

		case IDC_PURGEWIBBLE:
			PurgeWibbleData();
			return TRUE;

		case IDC_PURGEWIBBLESEL:
			PurgeWibbleDataSel();
			return TRUE;

		case IDC_FIXVERTCOL:
			FixVertColorsSel();
			return TRUE;

		case IDC_SELWIBBLE:
			gInterface->ClearNodeSelection();
			SelWibbleNodes();
			return TRUE;

		case IDC_SAVESEL:
			SaveSelection();
			return TRUE;

		case IDC_LOADSEL:
			gInterface->ClearNodeSelection();
			LoadSelection();
			return TRUE;
		}
		break;
	}

	return FALSE;
}

void DebugTool::BeginEditParams(Interface* ip,IUtil* iu)
{
	this->ip = ip;
	this->iu = iu;

	hwnd = ip->AddRollupPage(hInstance,MAKEINTRESOURCE(IDD_DEBUG),DlgProc,"Debug Tool");
	SelectionSetChanged(ip,iu);
}

void DebugTool::EndEditParams(Interface* ip, IUtil* iu)
{
	ip->DeleteRollupPage(hwnd);
}

void DebugTool::SelectionSetChanged(Interface* ip, IUtil* iu)
{
	int nSelNodes = ip->GetSelNodeCount();

	if (nSelNodes>1 || nSelNodes==0)
		return;

	INode* node = ip->GetSelNode(0);
	Object* obj = node->EvalWorldState(0).obj;

	if (obj->CanConvertToType(triObjectClassID))
	{
		TriObject* triObj = (TriObject*)obj->ConvertToType(0,triObjectClassID);

		Mesh& mesh = triObj->GetMesh();


		UVVert* colors = mesh.mapVerts(0);
		TVFace* faces  = mesh.mapFaces(0);

		//int			curVCChan;	// current map channel to use for colors (default = 0)
		//VertColor *	curVCArray;	// possible external color array (default = NULL)
		//TVFace	  * curVCFace;	// possible external face array (default = NULL)

		// Verify that only one face is selected
		if (mesh.faceSel.NumberSet() != 1)
			return;

		// Find the first selected bit
		int selFace;

		for(int i=0;i<mesh.numFaces;i++)
		{
			if (mesh.faceSel[i])
			{
				selFace = i;
				break;
			}
		}

		// Now that we have the selected face, display it's color data in the window
		char buf[256];
		int index;

		sprintf(buf,"%i",selFace);
		SetDlgItemText(hwnd,IDC_FACEID,buf);

		index = faces[selFace].t[0];

		if (index < mesh.numCVerts)
		{
			sprintf(buf,"%f (%f)",colors[index].x,colors[index].x*255.0f);
			SetDlgItemText(hwnd,IDC_VERTR0,buf);

			sprintf(buf,"%f (%f)",colors[index].y,colors[index].y*255.0f);
			SetDlgItemText(hwnd,IDC_VERTG0,buf);

			sprintf(buf,"%f (%f)",colors[index].z,colors[index].z*255.0f);
			SetDlgItemText(hwnd,IDC_VERTB0,buf);
		}

		index = faces[selFace].t[1];
		if (index < mesh.numCVerts)
		{
			sprintf(buf,"%f (%f)",colors[index].x,colors[index].x*255.0f);
			SetDlgItemText(hwnd,IDC_VERTR1,buf);
			
			sprintf(buf,"%f (%f)",colors[index].y,colors[index].y*255.0f);
			SetDlgItemText(hwnd,IDC_VERTG1,buf);
			
			sprintf(buf,"%f (%f)",colors[index].z,colors[index].z*255.0f);
			SetDlgItemText(hwnd,IDC_VERTB1,buf);
		}

		index = faces[selFace].t[2];
		if (index < mesh.numCVerts)
		{
			sprintf(buf,"%f (%f)",colors[index].x,colors[index].x*255.0f);
			SetDlgItemText(hwnd,IDC_VERTR2,buf);
		
			sprintf(buf,"%f (%f)",colors[index].y,colors[index].y*255.0f);
			SetDlgItemText(hwnd,IDC_VERTG2,buf);
		
			sprintf(buf,"%f (%f)",colors[index].z,colors[index].z*255.0f);
			SetDlgItemText(hwnd,IDC_VERTB2,buf);
		}

		// Find the first selected bit
		int selVert;
		int curFace = 0;

		for(i=0;i<mesh.numVerts;i++)
		{
			if (mesh.vertSel[i])
			{
				selVert = i;
				break;
			}
		}

	BOOL init=FALSE;

	TVFace *cf = mesh.mapFaces(0);
	UVVert *cv = mesh.mapVerts(0);
	Color col;

	for (i=0; i<mesh.getNumFaces(); i++) {
		DWORD *tt = cf[i].t;
		DWORD *vv = mesh.faces[i].v;
		for (int j=0; j<3; j++) {
			if (!mesh.vertSel[vv[j]]) continue;
				col = cv[tt[j]];

			sprintf(buf,"%i",vv[j]);
			SetDlgItemText(hwnd,IDC_VERTID,buf);
		}
	}

	sprintf(buf,"%f (%f)",col.r,col.r*255.0f);
	SetDlgItemText(hwnd,IDC_VR,buf);

	sprintf(buf,"%f (%f)",col.g,col.g*255.0f);
	SetDlgItemText(hwnd,IDC_VG,buf);

	sprintf(buf,"%f (%f)",col.b,col.b*255.0f);
	SetDlgItemText(hwnd,IDC_VB,buf);

	/*
		if (selVert < mesh.numCVerts)
		{
			sprintf(buf,"%f (%f)",colors[selVert].x,colors[selVert].x*255.0f);
			SetDlgItemText(hwnd,IDC_VR,buf);
		
			sprintf(buf,"%f (%f)",colors[selVert].y,colors[selVert].y*255.0f);
			SetDlgItemText(hwnd,IDC_VG,buf);
		
			sprintf(buf,"%f (%f)",colors[selVert].z,colors[selVert].z*255.0f);
			SetDlgItemText(hwnd,IDC_VB,buf);
		}
	*/
	}
}

void PurgeObjAnimData(INode* root)
{
	if (!root)
	{
		root = gInterface->GetRootNode();
		ReferenceTarget *scene = gInterface->GetScenePointer();

		scene->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_OBJECT_EXPORT_OBJSETTINGS_ID);
		scene->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_OBJECT_EXPORT_SETTINGS_ID);
		scene->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_OBJECT_EXPORT_ID);
		scene->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_OBJECT_SELECTED_ID);
		scene->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_OBJECT_EXPORTFLAGGED);
	}

	int nKids = root->NumberOfChildren();

	for(int i=0;i<nKids;i++)
	{
		INode* child = root->GetChildNode(i);
		PurgeObjAnimData(child);
	}

	if (root == gInterface->GetRootNode())
		return;

	// Purge the data
	root->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_OBJECT_EXPORT_OBJSETTINGS_ID);
	root->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_OBJECT_EXPORT_SETTINGS_ID);
	root->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_OBJECT_EXPORT_ID);
	root->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_OBJECT_SELECTED_ID);
	root->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_OBJECT_EXPORTFLAGGED);
}

void PurgeAllData(INode* root)
{
	CStr name;
	if (root)
		name = root->GetName();

	if (!root)
	{
		root = gInterface->GetRootNode();
		ReferenceTarget *scene = gInterface->GetScenePointer();

		Object* obj = root->EvalWorldState(0).obj;

		if (obj && obj->SuperClassID() == GEN_DERIVOB_CLASS_ID)
		{
			IDerivedObject* dobj = (IDerivedObject*)obj;
			Object* objref = dobj->GetObjRef();
		}

		if (obj && obj->CanConvertToType(triObjectClassID))
		{
			TriObject* triobj = (TriObject*)obj->ConvertToType(0,triObjectClassID);
			Mesh& mesh = triobj->GetMesh();

			mesh.freeAllVData();

			mesh.InvalidateTopologyCache();
			mesh.InvalidateGeomCache();

			if (triobj != obj)
				triobj->DeleteThis();
		}
	}

	//Object* objref = root->GetObjectRef();

	int nKids = root->NumberOfChildren();

	for(int i=0;i<nKids;i++)
	{
		INode* child = root->GetChildNode(i);
		PurgeWibbleData(child);
	}

	if (root == gInterface->GetRootNode())
	{
		MessageBox(gInterface->GetMAXHWnd(),"Wibble Channel has been purged.","Purge Wibble Channel",MB_ICONINFORMATION|MB_OK);
		return;
	}

	// Purge the data
	Object* obj;

	obj = root->EvalWorldState(0).obj;

	if (obj && obj->CanConvertToType(triObjectClassID))
	{
		TriObject* triobj = (TriObject*)obj->ConvertToType(0,triObjectClassID);
		Mesh& mesh = triobj->GetMesh();

		mesh.freeAllVData();

		mesh.InvalidateTopologyCache();
		mesh.InvalidateGeomCache();

		if (triobj != obj)
			triobj->DeleteThis();
	}

	SClass_ID scid = obj->SuperClassID();
	Class_ID cid = obj->ClassID();

	obj = root->GetObjectRef();

	if (obj && obj->SuperClassID() == GEN_DERIVOB_CLASS_ID)
	{
		IDerivedObject* dobj = (IDerivedObject*)obj;

		while(obj)
		{
			if (obj && obj->SuperClassID() == GEN_DERIVOB_CLASS_ID)
			{
				if (obj && obj->CanConvertToType(triObjectClassID))
				{
					TriObject* triobj = (TriObject*)obj->ConvertToType(0,triObjectClassID);
					Mesh& mesh = triobj->GetMesh();

					mesh.freeAllVData();

					mesh.InvalidateTopologyCache();
					mesh.InvalidateGeomCache();

					if (triobj != obj)
						triobj->DeleteThis();
				}

				// Get down to the base object
				IDerivedObject* dobj = (IDerivedObject*)obj;
				obj = dobj->GetObjRef();
			}
			else
				break;
		}
	}
}

void PurgeVertColorsSel()
{
	int numNodes = gInterface->GetSelNodeCount();

	for(int i=0;i<numNodes;i++)
	{
		INode* node = gInterface->GetSelNode(i);

		// Clear out the color per vertex data stored in the mesh
		Object* obj = node->EvalWorldState(0).obj;

		if (obj->CanConvertToType(triObjectClassID))
		{
			TriObject* triObj = (TriObject*)obj->ConvertToType(0,triObjectClassID);
			Mesh* mesh = &triObj->mesh;

			// Purge vertex color channel
			PurgeVertColorsChannel(node, mesh->curVCChan);
			mesh->setNumVertCol(0);
			mesh->setNumVCFaces(0);
		}
	}
}

void FixVertColorsSel()
{
	int numNodes = gInterface->GetSelNodeCount();

	for(int i=0;i<numNodes;i++)
	{
		INode* node = gInterface->GetSelNode(i);

		// Clear out the color per vertex data stored in the mesh
		Object* obj = node->EvalWorldState(0).obj;

		if (obj->CanConvertToType(triObjectClassID))
		{
			TriObject* triObj = (TriObject*)obj->ConvertToType(0,triObjectClassID);
			Mesh* mesh = &triObj->mesh;

			// Purge vertex color channel
			//PurgeVertColorsChannel(node, mesh->curVCChan);

			//mesh->setNumVertCol(mesh->numFaces * 3, TRUE);

			int nColorVerts = mesh->getNumVertCol();

			for(int i=0; i < mesh->numFaces; i++)
			{
				TVFace* face = &mesh->vcFaceData[i];

				for(int j=0; j < 3; j++)
				{
					if (face->t[j] > nColorVerts ||
						face->t[j] < 0)
						face->t[j] = 0;
				}
			}

			//mesh->setNumVertCol(0);
			//mesh->setNumVCFaces(0);
		}
	}
}

void PurgeVertColorsChannel(INode* root, int channel)
{
	CStr name;
	if (root)
		name = root->GetName();

	if (!root)
	{
		root = gInterface->GetRootNode();
		ReferenceTarget *scene = gInterface->GetScenePointer();

		Object* obj = root->EvalWorldState(0).obj;

		if (obj && obj->SuperClassID() == GEN_DERIVOB_CLASS_ID)
		{
			IDerivedObject* dobj = (IDerivedObject*)obj;
			Object* objref = dobj->GetObjRef();
		}

		if (obj && obj->CanConvertToType(triObjectClassID))
		{
			TriObject* triobj = (TriObject*)obj->ConvertToType(0,triObjectClassID);
			Mesh& mesh = triobj->GetMesh();

			mesh.setNumMapVerts( 0, 0);
			mesh.setMapSupport( 0, FALSE );
			mesh.freeMapVerts( 0 );
			mesh.freeMapFaces( 0 );

			mesh.InvalidateTopologyCache();
			mesh.InvalidateGeomCache();

			if (triobj != obj)
				triobj->DeleteThis();
		}
	}

	//Object* objref = root->GetObjectRef();

	int nKids = root->NumberOfChildren();

	for(int i=0;i<nKids;i++)
	{
		INode* child = root->GetChildNode(i);
		PurgeWibbleData(child);
	}

	if (root == gInterface->GetRootNode())
	{
		MessageBox(gInterface->GetMAXHWnd(),"Wibble Channel has been purged.","Purge Wibble Channel",MB_ICONINFORMATION|MB_OK);
		return;
	}

	// Purge the data
	Object* obj;

	obj = root->EvalWorldState(0).obj;

	if (obj && obj->CanConvertToType(triObjectClassID))
	{
		TriObject* triobj = (TriObject*)obj->ConvertToType(0,triObjectClassID);
		Mesh& mesh = triobj->GetMesh();
		
		mesh.setNumMapVerts( channel, 0);
		mesh.setMapSupport( channel, FALSE );
		mesh.freeMapVerts( channel );
		mesh.freeMapFaces( channel );

		mesh.InvalidateTopologyCache();
		mesh.InvalidateGeomCache();

		if (triobj != obj)
			triobj->DeleteThis();
	}

	SClass_ID scid = obj->SuperClassID();
	Class_ID cid = obj->ClassID();

	obj = root->GetObjectRef();

	if (obj && obj->SuperClassID() == GEN_DERIVOB_CLASS_ID)
	{
		IDerivedObject* dobj = (IDerivedObject*)obj;

		while(obj)
		{
			if (obj && obj->SuperClassID() == GEN_DERIVOB_CLASS_ID)
			{
				if (obj && obj->CanConvertToType(triObjectClassID))
				{
					TriObject* triobj = (TriObject*)obj->ConvertToType(0,triObjectClassID);
					Mesh& mesh = triobj->GetMesh();
					
					mesh.setNumMapVerts( channel, 0);
					mesh.setMapSupport( channel, FALSE );
					mesh.freeMapVerts( channel );
					mesh.freeMapFaces( channel );

					mesh.InvalidateTopologyCache();
					mesh.InvalidateGeomCache();

					if (triobj != obj)
						triobj->DeleteThis();
				}

				// Get down to the base object
				IDerivedObject* dobj = (IDerivedObject*)obj;
				obj = dobj->GetObjRef();
			}
			else
				break;
		}
	}
}

void PurgeWibbleData(INode* root)
{
	CStr name;
	if (root)
		name = root->GetName();

	if (!root)
	{
		root = gInterface->GetRootNode();
		ReferenceTarget *scene = gInterface->GetScenePointer();

		Object* obj = root->EvalWorldState(0).obj;

		if (obj && obj->SuperClassID() == GEN_DERIVOB_CLASS_ID)
		{
			IDerivedObject* dobj = (IDerivedObject*)obj;
			Object* objref = dobj->GetObjRef();
		}

		if (obj && obj->CanConvertToType(triObjectClassID))
		{
			TriObject* triobj = (TriObject*)obj->ConvertToType(0,triObjectClassID);
			Mesh& mesh = triobj->GetMesh();

			mesh.setNumMapVerts( vWIBBLE_INDEX_CHANNEL, 0);
			mesh.setNumMapVerts( vWIBBLE_OFFSET_CHANNEL, 0);

			mesh.setMapSupport( vWIBBLE_INDEX_CHANNEL, FALSE );
			mesh.setMapSupport( vWIBBLE_OFFSET_CHANNEL, FALSE );

			mesh.InvalidateTopologyCache();
			mesh.InvalidateGeomCache();

			if (triobj != obj)
				triobj->DeleteThis();
		}
	}

	//Object* objref = root->GetObjectRef();

	int nKids = root->NumberOfChildren();

	for(int i=0;i<nKids;i++)
	{
		INode* child = root->GetChildNode(i);
		PurgeWibbleData(child);
	}

	if (root == gInterface->GetRootNode())
	{
		MessageBox(gInterface->GetMAXHWnd(),"Wibble Channel has been purged.","Purge Wibble Channel",MB_ICONINFORMATION|MB_OK);
		return;
	}

	// Purge the data
	Object* obj;

	obj = root->EvalWorldState(0).obj;

	if (obj && obj->CanConvertToType(triObjectClassID))
	{
		TriObject* triobj = (TriObject*)obj->ConvertToType(0,triObjectClassID);
		Mesh& mesh = triobj->GetMesh();
		
		mesh.setNumMapVerts( vWIBBLE_INDEX_CHANNEL, 0);
		mesh.setNumMapVerts( vWIBBLE_OFFSET_CHANNEL, 0);

		mesh.setMapSupport( vWIBBLE_INDEX_CHANNEL, FALSE );
		mesh.setMapSupport( vWIBBLE_OFFSET_CHANNEL, FALSE );

		mesh.InvalidateTopologyCache();
		mesh.InvalidateGeomCache();

		if (triobj != obj)
			triobj->DeleteThis();
	}

	SClass_ID scid = obj->SuperClassID();
	Class_ID cid = obj->ClassID();

	obj = root->GetObjectRef();

	if (obj && obj->SuperClassID() == GEN_DERIVOB_CLASS_ID)
	{
		IDerivedObject* dobj = (IDerivedObject*)obj;

		while(obj)
		{
			if (obj && obj->SuperClassID() == GEN_DERIVOB_CLASS_ID)
			{
				if (obj && obj->CanConvertToType(triObjectClassID))
				{
					TriObject* triobj = (TriObject*)obj->ConvertToType(0,triObjectClassID);
					Mesh& mesh = triobj->GetMesh();
					
					mesh.setNumMapVerts( vWIBBLE_INDEX_CHANNEL, 0);
					mesh.setNumMapVerts( vWIBBLE_OFFSET_CHANNEL, 0);

					mesh.setMapSupport( vWIBBLE_INDEX_CHANNEL, FALSE );
					mesh.setMapSupport( vWIBBLE_OFFSET_CHANNEL, FALSE );

					mesh.InvalidateTopologyCache();
					mesh.InvalidateGeomCache();

					if (triobj != obj)
						triobj->DeleteThis();
				}

				// Get down to the base object
				IDerivedObject* dobj = (IDerivedObject*)obj;
				obj = dobj->GetObjRef();
			}
			else
				break;
		}
	}
}

void PurgeWibbleDataSel()
{
	int nNodes = gInterface->GetSelNodeCount();
	
	for(int i=0;i<nNodes;i++)
	{
		INode* node = gInterface->GetSelNode(i);

		//Object* obj = node->EvalWorldState(0).obj;

		CStr name = CStr("ClearSel: ") + node->GetName() + CStr("\n");
		OutputDebugString(name);

		PurgeWibbleData(node);
	}

	MessageBox(gInterface->GetMAXHWnd(),"The current selections wibble data has been purged.","Purge Wibble Data",MB_ICONINFORMATION|MB_OK);
}

void SelWibbleNodes(INode* root)
{
	if (!root)
	{
		root = gInterface->GetRootNode();
		ReferenceTarget *scene = gInterface->GetScenePointer();

		Object* obj = root->EvalWorldState(0).obj;

		if (obj && obj->CanConvertToType(triObjectClassID))
		{
			TriObject* triobj = (TriObject*)obj->ConvertToType(0,triObjectClassID);
			Mesh& mesh = triobj->GetMesh();

			if (mesh.mapSupport( vWIBBLE_INDEX_CHANNEL ) ||
				mesh.mapSupport( vWIBBLE_OFFSET_CHANNEL ))
			{
				gInterface->SelectNode(root,0);
			}

			if (triobj != obj)
				triobj->DeleteThis();
		}
	}

	int nKids = root->NumberOfChildren();

	for(int i=0;i<nKids;i++)
	{
		INode* child = root->GetChildNode(i);
		SelWibbleNodes(child);
	}

	if (root == gInterface->GetRootNode())
	{
		gInterface->ForceCompleteRedraw();
		return;
	}

	// Purge the data
	Object* obj = root->EvalWorldState(0).obj;

	if (obj && obj->CanConvertToType(triObjectClassID))
	{
		TriObject* triobj = (TriObject*)obj->ConvertToType(0,triObjectClassID);
		Mesh& mesh = triobj->GetMesh();

		if (mesh.mapSupport( vWIBBLE_INDEX_CHANNEL ) ||
			mesh.mapSupport( vWIBBLE_OFFSET_CHANNEL ))
		{
			gInterface->SelectNode(root,0);
		}

		if (triobj != obj)
			triobj->DeleteThis();
	}
}

void SaveSelection()
{
	FILE* fp = fopen("c:\\savedsel.txt","w");

	if (!fp)
	{
		MessageBox(gInterface->GetMAXHWnd(),"Failed!","SaveSelection",MB_ICONWARNING|MB_OK);
		return;
	}

	for(int i=0;i<gInterface->GetSelNodeCount();i++)
	{
		INode* node = gInterface->GetSelNode(i);
		CStr name = node->GetName();

		fprintf(fp,"%s\n",(char*)name);
	}

	fclose(fp);
}

void LoadSelection()
{
	FILE* fp = fopen("c:\\savedsel.txt","r");

	if (!fp)
	{
		MessageBox(gInterface->GetMAXHWnd(),"Failed!","SaveSelection",MB_ICONWARNING|MB_OK);
		return;
	}

	while(!feof(fp))
	{
		char buf[512];
		fgets(buf,511,fp);

		int slen = strlen(buf);
		buf[slen-1] = 0;

		INode* node = gInterface->GetINodeByName(buf);

		if (node)
		{
			gInterface->SelectNode(node,0);
		}
	}

	fclose(fp);
	gInterface->ForceCompleteRedraw();
}
