typedef unsigned char Uint8;
typedef unsigned short Uint16;
typedef unsigned long Uint32;
typedef char Sint8;
typedef short Sint16;
typedef long Sint32;

struct RGBA
{
	Uint8 r, g, b, a;
};


struct PNGInfo
{
	int				mWidth, mHeight;
	int				mPaletteFormat;
	int				mPaletteBpp;
	int				mNumPaletteEntries;
	int				mNumUsedPaletteEntries;

	char *			mpTexelData;
	char *			mpRawPaletteData;

	int				mBpp;

	RGBA *			mpOutPaletteData;
	
	// used to indicate transparency of each palette entry
	// 1 for true transparency, 0 otherwise.
	char *			mpTransTab;

	// Index of transparency key color in palette
	// Used when source PNG has no transparency info encoded,
	// index of first color where RGBA = (0,0,0)
	Uint8			mTransIndex;

	bool			mUseGrayScaleTransKeying;
};


struct CharInfo
{
	int				mX, mY, mW, mH;
	// a negative value indicates a special icon imbedded in the font
	int				mAscii;	
};


struct FontInfo
{	
	// y position of baseline
	int				mBaseLine;
	// max height of a single character
	int				mMaxHeight;
	// position of highest, lowest pixel in font
	int				mHighestPixel, mLowestPixel;
	int				mNumChars;
	
	// dimensions of outputted buffer
	int				mOutW;
	int				mOutH;
	int				mOutUsedH;

	Uint8 *			mpOutBuf;
	
	// including leading character
	CharInfo		mCharTab[256];
};


// A table of these structures is outputted into the texture data
// section of the FNT file
struct OutCharInfo
{
	// pixel offsets
	Uint16 x, y, w, h;
};


// a table of these is outputted at the beginning of the FNT file, before the texture data section
struct ExtraCharInfo
{
	Sint16 baseline;
	Sint16 ascii;
};


void SaveToFile(char *file);
void LoadAsciiTable(char *file);
int FindDimsNextCharacter(int line);
int ScanForNextOccupiedLine(int line);
bool ScanVerticalLine(int lineNum, int *pTopVal, int *pBottomVal);
void BuildOutputPalette();
bool read_png( char *file_name, png_structp* in_png_ptr, png_infop* in_info_ptr );
bool load_png( char* path, PNGInfo *pInfo);
void Assert(int condition, char *pMessage, ...);

