// MakeVag.cpp : KSH 17 Jan 2001
//
// For each wav in the current directory, this will call aiff2vag on all those wav's that
// either don't have a corresponding vag file, or who are newer than their vag file.

#include "stdafx.h"
#include "stdio.h"
#include "string.h"
#include "stdlib.h"
#include "conio.h"
#include "process.h"
#include "time.h"
#include "sys/types.h"
#include "sys/stat.h"

void Assert(bool Condition, char *pMessage)
{
	if (!Condition)
	{
		printf("MakeVag assertion failed:\n%s",pMessage);
		exit(1);
	}
}

#define MAXFILENAMECHARS 200

int main(int argc, char* argv[])
{
	// Generate a listing of all the wav files and pipe it into wavs.txt (in the current directory)
	// /b means just list the filenames with no other info.
	system("dir *.wav /b >wavs.txt");

	// Open wavs.txt for parsing.
	FILE *listifp=fopen("wavs.txt","r");
	Assert(listifp!=NULL,"Could not open wavs.txt");

    // Check each of the files listed.
    while (true)
    {
        // Wav file name buffer.
        char pWavNameBuf[MAXFILENAMECHARS+1];

        // Load each character into the buffer until end-of-line or end-of-file.
        int i=0;
        while (true)
        {
            Assert(i<=MAXFILENAMECHARS,"Too many chars in filename.");
			char ch=fgetc(listifp);

            // Check if end-of-file or end-of-line.
            if (ch==EOF || ch=='\n')
            {
                // Terminate the current string.
                pWavNameBuf[i]=0;
                break;
            }

			pWavNameBuf[i]=ch;
            ++i;
        }

		// If got a file name ...
        if (pWavNameBuf[0])
		{
			// Derive the .vag filename.
	        char pVagNameBuf[MAXFILENAMECHARS+1];
			strcpy(pVagNameBuf,pWavNameBuf);
			// Convert to lower case so that strstr works (it's case sensitive)
			for (unsigned int i=0; i<strlen(pVagNameBuf); ++i)
			{
				pVagNameBuf[i]=tolower(pVagNameBuf[i]);
			}
			// Find the wav extension and change it to vag.
			char *pExt=strstr(pVagNameBuf,".wav");
			Assert(pExt!=NULL,"No '.wav' found in filename");
			pExt[1]='v'; pExt[2]='a'; pExt[3]='g';

			// Get file info for the vag.
			struct stat VagStatBuf;
			int ReturnCode=stat(pVagNameBuf,&VagStatBuf);

			if (ReturnCode==-1)
			{
				// The Vag file does not exist so compile the source file.
				printf("Converting new wav file %s\n",pWavNameBuf);
				char pBuf[1000];
				sprintf(pBuf,"aiff2vag -e -l %s",pWavNameBuf);
				system(pBuf);
			}
			else
			{
				Assert(ReturnCode==0,"Unexpected ReturnCode when running stat on vag filename");

				// The vag file does exist.
				// Get the wav file info to see if it is newer than the vag.
				struct stat WavStatBuf;
				ReturnCode=stat(pWavNameBuf,&WavStatBuf);
				Assert(ReturnCode==0,"Unexpected ReturnCode when running stat on wav filename");

				if (WavStatBuf.st_mtime>VagStatBuf.st_mtime)
				{
					// The wav file is newer than the vag, so process the wav.
					printf("%s has changed, creating new vag.\n",pWavNameBuf);
					char pBuf[1000];
					sprintf(pBuf,"aiff2vag -e -l %s",pWavNameBuf);
					system(pBuf);
				}
			}
		}
        else
			// No filename, so must have finished the list of filenames.
            break;
    }
	
	fclose (listifp);

	// Delete the temporary file wavs.txt
	system("del wavs.txt");
	return 0;
}
