/*
	WorldStructs.cpp
	Init and misc data for standard world structures/classes

	aml - 9-29-03
*/

#include "stdafx.h"
#include "WorldStructs.h"

NxObject::NxObject()
{
	m_NumVerts = 0;
	m_Verts = NULL;
	m_NumFaces = 0;
	m_Faces = NULL;
	strcpy(m_Name, "Default");
	m_BoundingBox.Init();
	m_Flags = 0;
	m_NumUVSets = 0;
	m_SkeletonChecksum = 0;

	m_NumMaxVerts = 0;
	m_MaxVerts    = NULL;

	m_LODVersion   = NxLODLevel::vVERSION_NUMBER;
	m_LODMaster.m_NumLODLevels = 0;
	m_LODMaster.m_LODLevels    = NULL;

	m_Version = NxObject::vVERSION_NUMBER;

	m_ParentCRC = 0;
	m_NumChildren = 0;
	m_ChildCRCs = NULL;

	m_LODLevels = 0;
	m_LODinfo   = NULL;

	m_NumUVChannels = 0;
	m_UVChannels = NULL;	

	m_Checksum = 0;

	m_NumCASData = 0;
	mp_CASData   = NULL;
}

NxObject::~NxObject()
{
	if( m_Verts )
	{
		delete [] m_Verts;
	}

	if( m_Faces )
	{
		delete [] m_Faces;
	}	

	if ( (m_LODFlags & mMASTER) && m_LODMaster.m_LODLevels )
	{
		delete [] m_LODMaster.m_LODLevels;
	}

	if ( m_ChildCRCs )
	{
		delete [] m_ChildCRCs;
	}

	if ( m_LODinfo )
	{
		delete [] m_LODinfo;
	}

	if ( m_MaxVerts )
	{
		delete [] m_MaxVerts;
	}

	if ( m_UVChannels )
	{
		delete [] m_UVChannels;
	}
}

// NxBoundingBox
void NxBoundingBox::Init()
{
	m_Min[0] = 0.0f;
	m_Min[1] = 0.0f;
	m_Min[2] = 0.0f;

	m_Max[0] = 0.0f;
	m_Max[1] = 0.0f;
	m_Max[2] = 0.0f;
}

void NxBoundingBox::Set(const float min[3], const float max[3])
{
	m_Min[0] = min[0];
	m_Min[1] = min[1];
	m_Min[2] = min[2];

	m_Max[0] = max[0];
	m_Max[1] = max[1];
	m_Max[2] = max[2];
}

void NxBoundingBox::AddPoint(const float point[3])
{
	// Adjust min/max points
	if (point[0] < m_Min[0])
		m_Min[0] = point[0];
	if (point[1] < m_Min[1])
		m_Min[1] = point[1];
	if (point[2] < m_Min[2])
		m_Min[2] = point[2];

	if (point[0] > m_Max[0])
		m_Max[0] = point[0];
	if (point[1] > m_Max[1])
		m_Max[1] = point[1];
	if (point[2] > m_Max[2])
		m_Max[2] = point[2];
}

// NxFace
NxFace::NxFace( void )
{
	m_PassFlags = 0;
	m_MatChecksum = 0;
	m_Vertex[0] = 0;
	m_Vertex[1] = 0;
	m_Vertex[2] = 0;
	m_Normal.x = 0;
	m_Normal.y = 0;
	m_Normal.z = 0;
	m_FaceFlags = 0;
	m_MinFaceFlags = 0;
	m_Index = 0;
	m_Pass = 0;
	m_LightmapChecksum = 0;
	m_LightmapUV[0].u = 0;
	m_LightmapUV[0].v = 0;
	m_LightmapUV[1] = m_LightmapUV[0];
	m_LightmapUV[2] = m_LightmapUV[0];
}

// NxVertex
NxVertex::NxVertex( void )
{
	int i;

	m_Pos.x = 0;
	m_Pos.y = 0;
	m_Pos.z = 0;
	m_Normal.x = 0;
	m_Normal.y = 0;
	m_Normal.z = 0;
	
	for( i = 0; i < vMAX_MATERIAL_PASSES; i++ )
	{
		m_TexCoord[i].x = 0;
		m_TexCoord[i].y = 0;
		m_TexCoord[i].z = 0;
	}
	m_Color[0] = 0;	// r
	m_Color[1] = 0;	// g
	m_Color[2] = 0; // b
	m_Color[3] = 0; // a
	m_WibbleIndex = 0;
	m_WibbleOffset = 0;
	m_Pass = 0;
	m_FaceIndex = 0;
	m_Weighted = false;

	for( i = 0; i < vMAX_WEIGHTS_PER_VERTEX; i++ )
	{
		m_Weight[i] = 0;
		m_WeightedIndex[i] = 0;
	}
}


// NxLODLevel
NxLODLevel::NxLODLevel( void )
{
	m_Distance = 0.0f;
	m_ObjectCRC = 0;
}
