/*
	UVChannel.h
	UV Channel Data
*/

#ifndef __UVCHANNEL__
#define __UVCHANNEL__

struct TVFace
{
	unsigned long t[3];	// Indicies into vert table
};

struct UVChannel
{
	UVVert* verts;		// Vertex list for the channel
	TVFace* faces;		// Face list for the channel

	int     nVerts;		// Number of verts in this copied channel
	int     nFaces;		// Number of faces in this copied channel

	inline void setVerts(int num)
	{
		verts = new UVVert[num];
		nVerts = num;
	}

	inline void setFaces(int num)
	{
		faces  = new TVFace[num];
		nFaces = num;
	}

	UVChannel()
	{
		verts  = NULL;
		faces  = NULL;
		nVerts = 0;
		nFaces = 0;
	}

	~UVChannel()
	{
		if (verts)
			delete [] verts;

		if (faces)
			delete [] faces;
	}
};

#endif
