/*
	UIControl.h
	A class for building custom Windows controls
	From now on all PE (and other control) classes will derive from UIControl

    aml 4-25-01
*/

#ifndef __UICONTROL__
#define __UICONTROL__

#include <windows.h>

#define CLASS               REGClassName()
#define REGISTERCLASS(x,h)  x::Register(x::REGClassName(),h)
#define CLASSNAME(x)        inline static char* REGClassName() { return x; } \
                            char* GetClassName() { return x; }

class UIControl
{
	const char* className;

protected:
	HINSTANCE hInstance;			// Application hInstance
	HWND      hwnd;					// The handle for this control

	virtual LRESULT WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	virtual void    BuildControlUI()=0;
	
	virtual HWND    GetFocusWindow();

	static LRESULT CALLBACK RedirectWndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

public:
	UIControl(HINSTANCE hInstance,const char* className);
	UIControl(HINSTANCE hInstacne, HWND hwnd,const char* className);
	~UIControl();

	void Attach(HWND hwnd);
	void SetFocus() { ::SetFocus(GetFocusWindow()); }

	static void  Register(const char* className, HINSTANCE hInstance);
	static void  UnRegister(const char* className, HINSTANCE hInstance);
};

#endif
