/*
	UIControl.cpp
	A class for building custom Windows controls
	From now on all PE (and other control) classes will derive from UIControl

    aml 4-25-01
*/

#include "stdafx.h"
#include "UIControl.h"
#include <assert.h>

UIControl::UIControl(HINSTANCE hInstance, const char* className)
{
	this->className = className;
	this->hInstance = hInstance;
	hwnd      = NULL;
	Register(className, hInstance);
}

UIControl::UIControl(HINSTANCE hInstance,HWND hwnd, const char* className)
{
	this->className = className;
	this->hInstance = hInstance;	
	Attach(hwnd);
}

UIControl::~UIControl()
{
	DestroyWindow(hwnd);
}

void UIControl::Register(const char* className, HINSTANCE hInstance)
{
	WNDCLASS wndclass;
	ZeroMemory(&wndclass,sizeof(WNDCLASS));

	wndclass.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndclass.lpfnWndProc   = RedirectWndProc;
	wndclass.cbClsExtra    = 0;
	wndclass.cbWndExtra    = 0;
	wndclass.hInstance     = hInstance;
	wndclass.hIcon         = NULL;
	wndclass.hCursor       = LoadCursor(NULL,IDC_ARROW);
	wndclass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName  = NULL;
	wndclass.lpszClassName = className;

	assert(className!=NULL);

	RegisterClass(&wndclass);
}

void UIControl::UnRegister(const char* className, HINSTANCE hInstance)
{
	UnregisterClass(className,hInstance);
}

void UIControl::Attach(HWND hwnd)
{
	SetWindowLong(hwnd, GWL_USERDATA, (LONG)this);
	Register(className, hInstance);
	this->hwnd = hwnd;
	BuildControlUI();
}

LRESULT CALLBACK UIControl::RedirectWndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	UIControl* thisclass=(UIControl*)GetWindowLong(hwnd,GWL_USERDATA);

	switch(msg)
	{
	case WM_CREATE:
		{
			SetWindowLong(hwnd, GWL_USERDATA, (LONG)((CREATESTRUCT*)lParam)->lpCreateParams);
			thisclass = (UIControl*)((CREATESTRUCT*)lParam)->lpCreateParams;

			if (thisclass)
				thisclass->Attach(hwnd);
		}
		break;
	}

	if (thisclass)
		return thisclass->WndProc(hwnd,msg,wParam,lParam);

	return DefWindowProc(hwnd,msg,wParam,lParam);
}

LRESULT UIControl::WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_SETFOCUS:
		::SetFocus(GetFocusWindow());
		return 0;
	}

	return DefWindowProc(hwnd,msg,wParam,lParam);
}

void UIControl::BuildControlUI()
{
	
}

HWND UIControl::GetFocusWindow()
{
	return hwnd;
}
