/*
	LevelEditor.cpp
	aml - 9-5-03
*/

#include "stdafx.h"
#include "resource.h"
#include "../InterMaxLink/InterMaxLink.h"	// Exports for InterMaxLink.dll for InterCommunication with 3DSMAX
#include "../InterMax/DataNotifyCodes.h"	// InterMax.gup message notification codes for IPC with 3DSMAX
#include "../Max5/Next/InterLink/InterLinkCodes.h"
#include "MSWindow.h"
#include "LevelEditorDlg.h"
#include "RenderWindow.h"
#include <commctrl.h>
#include <stdio.h>
#include "ObjectIO.h"
#include "WorldDB.h"

#define WINDOW_IDENTITY  "InterLinkClassMAXServerWindow"	// This is the name of the top-level window that gets created
															// by the MAX plugin for facilitating simple 2-way communication
															// between the two applications.  For simplicity, we'll just
															// send any messages directly between applications

WorldDB   worldDB;				// Maintains the world database throughout the LevelEditor

HGLRC     hglrc;				// Main OpenGL Rendering context
HINSTANCE ghInstance;

int nVerts = 0, nFaces = 0;
imlVert* verts = NULL;
imlFace* faces = NULL;

NxObject* pRenderObj = NULL;

BOOL CALLBACK EnumWindowsFindInterLink(HWND hwnd, LPARAM lParam)
{
	char buf[256];
	GetWindowText(hwnd, buf, 256);

	if (strcmp(buf, WINDOW_IDENTITY) == 0)
	{
		HWND* phwnd = (HWND*)lParam;
		*phwnd = hwnd;
		return FALSE;
	}

	return TRUE;
}

HWND FindInterLinkWindow()
{
	HWND hwndInterMaxLink = NULL;
	EnumChildWindows(NULL, EnumWindowsFindInterLink, (LPARAM)&hwndInterMaxLink);

	return hwndInterMaxLink;
}

int NotifyIML(void* pData, DWORD id, DWORD size, int arg1, int arg2)
{
	switch(id)
	{
	case 0:
		imlBlockAck();
		return 0;

	//case NOTIFYDATA_NEWGEOM:
	case NOTIFYDATA_NEWMTL:
		{
			//ReadMaterial(
		}
		break;

	case NOTIFYDATA_NEWOBJ:
		{
			if (pRenderObj)
				delete pRenderObj;

			pRenderObj = ReadObject(pData);

			//char buf[256];
			//sprintf(buf, "Acquired '%s'.\n", pRenderObj->m_Name);
			//sprintf(buf, "Got update\n");
			//OutputDebugString(buf);
			imlBlockAck();

			/* OLD Geom only test
			unsigned char* pPos = (unsigned char*)pData;
			nVerts = *((int*)pPos);
			pPos += sizeof(int);

			if (verts)
				free(verts);

			verts = (imlVert*)malloc(sizeof(imlVert) * nVerts);
			memcpy(verts, pPos, sizeof(imlVert) * nVerts);
			pPos += (sizeof(imlVert) * nVerts);

			nFaces = *((int*)pPos);
			pPos += sizeof(int);

			if (faces)
				free(faces);

			faces = (imlFace*)malloc(sizeof(imlFace) * nFaces);
			memcpy(faces, pPos, sizeof(imlFace) * nFaces);
			pPos += (sizeof(imlFace) * nFaces);

			imlBlockAck();
			*/
		}
		break;
	}

	return 0;
}

void InitIML()
{
	imlRegisterClient("LevelEditor", NotifyIML);
}

int WINAPI WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
                   LPTSTR    lpCmdLine,
                   int       nCmdShow)
{
	MSG msg;
	HACCEL hAccelTable;

	ghInstance = hInstance;

	InitCommonControls();

	// Initialize MAX Shared Communications system
	HWND hwndInterLink = FindInterLinkWindow();

	if (!hwndInterLink)
	{
		MessageBox(NULL, "Failed to locate the MAX communications plugin", "InterMaxLink Not Running?", MB_ICONSTOP|MB_OK);
		return 0;
	}

	InitIML();

	REGISTERCLASS(RenderWindow, hInstance);
	LevelEditorDlg* pMainDlg = new LevelEditorDlg(hInstance, hwndInterLink);

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_LEVELEDITOR);

	pMainDlg->MSDlgWindow::Show();

	// Main message loop:
	while(1)
	{
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			if (msg.message == WM_QUIT)
			{
				imlUnlockSection(0,0);
				imlUnregisterClient();
				delete pMainDlg;
				return 0;
			}

			if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		else
		{
			// UpdateGL and IML
			static int cnt = 0;
			cnt++;

			//if (cnt > 10000)
			{
				pMainDlg->Update();
				cnt = 0;
			}

			imlUpdate();
		}
	}

	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	imlUnlockSection(0,0);
	imlUnregisterClient();
	delete pMainDlg;

	return (int) msg.wParam;
}
