/*
	MainGUP.cpp
	Definition for the InterMax global utility plugin
*/

#include "MainGUP.h"
#include "max.h"

#include "iparamm2.h"
#include "guplib.h"
#include "..\InterMaxLink\InterMaxLink.h"
#include "DataNotifyCodes.h"

Interface* gInterface = NULL;

class InterMax: public GUP
{
	UINT timerID;

	static void CALLBACK TimerProc(HWND hwnd, UINT msg, UINT id, DWORD time);
	static void DataNotify(void* pData, DWORD id, DWORD size, int arg1, int arg2);

public:
	DWORD Start();
	void  Stop();
};

void* MainGUPDesc::Create(BOOL loading)
{
	return new InterMax();
}

void InterMax::TimerProc(HWND hwnd, UINT msg, UINT id, DWORD time)
{
	imlUpdate();

	int nNodes = gInterface->GetSelNodeCount();

	if (nNodes < 1)
		return;

	// Take the first selected object and post it's geom data to connected clients
	INode* node = gInterface->GetSelNode(0);

	Object* obj = node->EvalWorldState(0).obj;

	if (obj->CanConvertToType(triObjectClassID))
	{
		unsigned char* pMem = (unsigned char*)imlLockSection();

		if (pMem)
		{
			unsigned char* pPos = pMem;
			int size = 0;
			int i;

			TriObject* triObj = (TriObject*)obj->ConvertToType(0, triObjectClassID);
			Mesh& mesh = triObj->GetMesh();

			// Copy mesh data to shared memory
			*((int*)pPos) = mesh.numVerts;
			pPos += sizeof(int);
			size += sizeof(int);

			// Copy verts
			for(i = 0; i < mesh.numVerts; i++)
			{
				imlVert vert;
				vert.x = mesh.verts[i].x;
				vert.y = mesh.verts[i].y;
				vert.z = mesh.verts[i].z;

				*((imlVert*)pPos) = vert;
				pPos += sizeof(imlVert);
				size += sizeof(imlVert);
			}

			*((int*)pPos) = mesh.numFaces;
			pPos += sizeof(int);
			size += sizeof(int);

			// Copy faces
			for(i = 0; i < mesh.numFaces; i++)
			{
				imlFace face;
				face.v[0] = mesh.faces[i].v[0];
				face.v[1] = mesh.faces[i].v[1];
				face.v[2] = mesh.faces[i].v[2];

				*((imlFace*)pPos) = face;
				pPos += sizeof(imlFace);
				size += sizeof(imlFace);
			}

			//pMem = mesh.numVerts

			if (triObj != obj)
				triObj->DeleteThis();

			imlUnlockSection(NOTIFYDATA_NEWGEOM, size);
		}
	}
	
	//(*(int*)pMem) = nNodes;
}

void InterMax::DataNotify(void* pData, DWORD id, DWORD size, int arg1, int arg2)
{
	switch(id)
	{
	case NOTIFYDATA_NEWGEOMBUILD:
		{
			// New geomtry should be constructed in MAX
			TriObject* triObj = CreateNewTriObject();
			int i;
			Point3  pt;
			imlVert vertIML;
			imlFace faceIML;

			unsigned char* pPos = (unsigned char*)pData;

			int nVerts = *((int*)pPos);
			pPos += sizeof(int);

			triObj->mesh.setNumVerts(nVerts);

			for(i = 0; i < nVerts; i++)
			{
				vertIML = *((imlVert*)pPos);
				pPos += sizeof(imlVert);

				pt.x = vertIML.x;
				pt.y = vertIML.y;
				pt.z = vertIML.z;

				triObj->mesh.setVert(i, pt);
			}

			int nFaces = *((int*)pPos);
			pPos += sizeof(int);

			triObj->mesh.setNumFaces(nFaces);

			for(i = 0; i < nFaces; i++)
			{
				faceIML = *((imlFace*)pPos);
				pPos += sizeof(imlFace);

				triObj->mesh.faces[i].setVerts(faceIML.v[0],
								               faceIML.v[1],
											   faceIML.v[2]);

				triObj->mesh.faces[i].setEdgeVisFlags(1,1,1);
				triObj->mesh.faces[i].setSmGroup(0);
			}

			INode* newNode = gInterface->CreateObjectNode(triObj);
			//newNode->SetName("NewNode");
			
			imlBlockAck();
		}
		break;
	}
}

DWORD InterMax::Start()
{
	gInterface = GetCOREInterface();

	// Register with IML
	imlRegisterClient("MAX", DataNotify);

	MessageBox(gInterface->GetMAXHWnd(), "InterMax Initialized!", "Init", MB_OK);
	timerID = SetTimer(NULL, 0, 500, TimerProc);

	return GUPRESULT_KEEP;
}

void InterMax::Stop()
{

}
