/*
	GetPlugState.cpp
	This app will connect to the plugin and display the last
	successfully executed function and location

	aml - 8-14-03
*/

#include <windows.h>
#include "resource.h"
#include <stdio.h>
#include <direct.h>
#include "../DebugLink/DebugLink.h"

HWND ghwnd;

bool Update(HWND hwnd);

BOOL CALLBACK DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
	case WM_INITDIALOG:

		return TRUE;

	case WM_CLOSE:
		ghwnd = NULL;
		PostQuitMessage(0);
		return TRUE;

	case WM_TIMER:
		if (IsDlgButtonChecked(hwnd, IDC_PERIODIC) == BST_CHECKED)
		{
			if (!Update(hwnd))
			{
				CheckDlgButton(hwnd, IDC_PERIODIC, BST_UNCHECKED);
				MessageBox(hwnd, "Symbolic Debug Mode is not currently enabled in the plugin", "Symbols Disabled", MB_ICONWARNING|MB_OK);
				return false;
			}
		}

		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_UPDATE:
			Update(hwnd);
			return TRUE;

		case IDC_UPDATETIME:
			{
				switch(HIWORD(wParam))
				{
				case EN_CHANGE:
					{
						char buf[256];
						GetDlgItemText(hwnd, IDC_UPDATETIME, buf, 256);
						KillTimer(hwnd, 0);
						SetTimer(hwnd, 0, atoi(buf), NULL);
					}
					return TRUE;
				}
			}
			return TRUE;

		case IDC_DUMPLOG:
			{
				if (!DumpLog(NULL))
				{
					MessageBox(hwnd, "FAILED! to dump log file", "Log Dump Failed", MB_ICONSTOP|MB_OK);
					return TRUE;
				}
				
				MessageBox(hwnd, "SUCCESS!  Log file has been dumped (c:\\DebugLink.log)", "Log Dumped", MB_ICONINFORMATION|MB_OK);
			}
			return TRUE;
		}
	}

	return FALSE;
}

void UpdateState(DebugState dbgState)
{
	Update(ghwnd);	
}

void UpdateMsg(char* msg)
{
	if (ghwnd)
	{
		if (IsDlgButtonChecked(ghwnd, IDC_DISPMSGS) == BST_CHECKED)
		{
			MessageBox(ghwnd, msg, "Debug Message", MB_ICONINFORMATION|MB_OK);
		}
	}
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmd, int nShow)
{
	MSG msg;

	/*
	char maxPath[1024];

	GetPrivateProfileString("GetPlugState",
		                    "MAXPATH",
							"c:\\3dsmax5",
							maxPath,
							1024,
							"GetPlugState.ini");

	_chdir(maxPath);
	*/

	HWND hwnd = CreateDialog(hInstance,
		                     MAKEINTRESOURCE(IDD_MAIN),
							 NULL,
							 DlgProc);

	ghwnd = hwnd;

	CheckDlgButton(hwnd, IDC_REJECTUNKNOWN, BST_CHECKED);
	SetTimer(hwnd, 0, 500, NULL);
	SetDlgItemText(hwnd, IDC_UPDATETIME, "500");

	ShowWindow(hwnd, SW_SHOW);

	// Initalize DebugLink callbacks
	/*
	if (!SetUpdateStateCB(UpdateState))
	{
		MessageBox(hwnd, "Failed to connect to DebugLink.dll.  It appears to be in use by another Debug app?", "Failed to connect UpdateState", MB_ICONWARNING|MB_OK);
		PostQuitMessage(0);
	}

	if (!SetUpdateMsgCB(UpdateMsg))
	{
		MessageBox(hwnd, "Failed to connect to DebugLink.dll.  It appears to be in use by another Debug app?", "Failed to connect UpdateMsg", MB_ICONWARNING|MB_OK);
		PostQuitMessage(0);
	}
	*/

	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	// Deinitalize DebugLink callbacks
	//SetUpdateStateCB(NULL);
	//SetUpdateMsgCB(NULL);

	return 0;
}

bool Update(HWND hwnd)
{
	DebugState state;

	if (!IsDebugInit())
		return false;

	state = GetDebugState();

	if(strcmp(state.lastFile, "<Unknown File>") == 0 &&
	   IsDlgButtonChecked(hwnd, IDC_REJECTUNKNOWN) == BST_CHECKED)
	{
		return true;
	}

	if(strstr(state.lastFunction, "Timer"))
		return true;

	SetDlgItemText(hwnd, IDC_LASTFUNC, state.lastFunction);
	SetDlgItemText(hwnd, IDC_LASTSOURCE, state.lastFile);
	
	char line[256];
	_itoa(state.lastLine, line, 10);
	
	SetDlgItemText(hwnd, IDC_LASTLINE, line);
	return true;
}
