/******
dyngrpsample.c
GameSpy Query & Reporting SDK 
  
Copyright 2000 GameSpy Industries, Inc

18002 Skypark Circle
Irvine, CA 92614
(949)798-4200
Fax(949)798-4299
******

 This source file demonstrates how to host a "dynamic" group room, and 
 can be used to create group rooms for testing purposes.
 Note that you will need to "gameid" that corresponds to your gamename.
 You can either ask us for that number, or go to:
 http://developer.gamespy.com/tools/servers.asp
 ..and look at the gameid column when you have a server running.

 Please see the GameSpy Query & Reporting SDK documentation for more 
 information

******/


/********
INCLUDES
********/
#if defined(applec) || defined(THINK_C) || defined(__MWERKS__) && !defined(__KATANA__)
	#include ":::nonport.h"
#else
	#include "../../nonport.h"
#endif

#ifdef _MACOS
	#include "::gqueryreporting.h"
#else
	#include "../gqueryreporting.h"
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#if defined(_WIN32) && !defined(UNDER_CE)
#include <conio.h>
#endif

/********
DEFINES
********/
#define GAMEID 0 //the gameid for gmtest
#define BASE_PORT 26900

#ifdef _WIN32_WCE
void RetailOutputA(CHAR *tszErr, ...);
#define printf RetailOutputA
#endif

#ifdef __KATANA__
void NUMsg(char *in_format, ...);
#define printf NUMsg
#endif

/********
GLOBAL VARS
********/
int groupid = 0;

/*************
basic_callback
sends a (sample) response to the basic query 
includes the following keys:
\gamename\
\groupid\
\gameid\
\hostname\
\maxplayers\
\password\
*************/
static void basic_callback(char *outbuf, int maxlen, void *userdata)
{
	sprintf(outbuf, "\\gamename\\%s\\groupid\\%d\\gameid\\%d\\password\\0\\hostname\\%s\\maxplayers\\100",
			"group",groupid, GAMEID, "Test group server");
	printf("Basic callback, sent: %s\n\n",outbuf);
}

/************
info_callback
(not used for dynamic group rooms)
************/
static void info_callback(char *outbuf, int maxlen, void *userdata)
{
	outbuf[0] = 0;
}

/***************
rules_callback
(not used for dynamic group rooms)
****************/
static void rules_callback(char *outbuf, int maxlen, void *userdata)
{
	outbuf[0] = 0;
}

/***************
players_callback
(not used for dynamic group rooms)
***************/
static void players_callback(char *outbuf, int maxlen, void *userdata)
{
	outbuf[0] = 0;
}

/*******
 DoGameStuff
Simulate whatever else a game server does 
********/
void DoGameStuff(void)
{
	msleep(10);
}

/*******
 DoGameStuff
The GroupID needs to be globally unique. The easiest way to do this is based on the
IP and QueryPort of the dynamic host. Note that the below method for getting the IP
is not really reliable -- you should use the value returned by the IRC server USRIP
method.
********/
int GenerateGroupID()
{
	struct hostent *hent;
	char name[256];
	SocketStartUp();
	gethostname(name, 256);
	hent = gethostbyname(name);
	return *(unsigned int *)hent->h_addr_list[0] ^ BASE_PORT;	
}

/*******************
 main
Simulates a main program loop
First, initializes the Q&R items, then enters a main loop
*****************/
#ifdef __KATANA__
int test_main(int argc, char **argp)
#else
int main(int argc, char **argp)
#endif
{
	char secret_key[9];
	//set the secret key, in a semi-obfuscated manner
	secret_key[0] = 'H';
	secret_key[1] = 'A';
	secret_key[2] = '6';
	secret_key[3] = 'z';
	secret_key[4] = 'k';
	secret_key[5] = 'S';
	secret_key[6] = '\0';

	groupid = GenerateGroupID();
	//call qr_init with the query port number and gamename, default IP address, and no user data
	if (qr_init(NULL,NULL,BASE_PORT,"group", secret_key, basic_callback, 
		info_callback, rules_callback, players_callback, NULL) != 0)
	{
		printf("Error starting query sockets\n");
		return -1;
	}


	printf("Press any key to quit\n");
#if defined(_WIN32) && !defined(UNDER_CE)
	while (!_kbhit())
#else
	while (1)
#endif
	{
		DoGameStuff();
		//check for / process incoming queries
		qr_process_queries(NULL);

	}
	qr_send_statechanged(NULL);
	qr_shutdown(NULL);

	return 0;

}
