var GAMEID = 706;

var PS_GENERAL_CATEGORY		=	0;

var debug = new ActiveXObject("Statsmaster.DebugLog");
var it = new ActiveXObject("Statsmaster.IndexedTable");
var ps = new ActiveXObject("Statsmaster.KVPersistStorage");
var fileSystem = new ActiveXObject("Scripting.FileSystemObject");
var WinHttpReq = new ActiveXObject("WinHttp.WinHttpRequest.5");
var plookup = new ActiveXObject("Statsmaster.PlayerInfoLookup");
var pastGames = new ActiveXObject("Statsmaster.PastGameResults");

var MAX_GAMES_CREDITED = 500;

var LOG_SUCCESS 	= 0;
var LOG_ERROR 		= 1;
var LOG_WARNING 	= 2;
var LOG_INFORMATION = 4;

var CAT_GENERAL				= 0
// Column enumeration
var COL_NUM_GAMES     		= 0;
var COL_RATING				= 1;
var COL_RATING_NICK			= 2;
var COL_BEST_SCORE			= 3;

// These column numbers are relative to the gametype column offsets above
var COL_HIGH_SCORE  		= 0;	
var COL_HIGH_COMBO  		= 1;
var COL_HIGH_SCORE_NICK		= 2;
var COL_HIGH_COMBO_NICK		= 3;

//				 Load_NJ	 Load_NY	 Load_FL	 Load_SD	 Load_HI	 Load_VC	Load_SJ	   Load_RU	   Load_SE	   Load_VN	  Load_HN	  Load_SC2	 
var map_crcs = [ 0xf6c822d4, 0x7276630a, 0xd7720de9, 0xee1c63cf, 0x399bd4e8, 0xd0f0229, 0x9a44ec8, 0x9db7727c, 0x991b5359, 0x73be7e94, 0xa7ff414b, 0x8ca30405];
//					  nettrickattack	netgraffiti netscorechallenge	netcombomambo	netslap		netking		netgoalattack netctf	  netfirefight
var gametype_crcs = [ 0x30c2ffa3,		0x5e2ea50c, 0x1498240a, 		0xc50affd0,		0xf9d5d933, 0x6ef8fda0, 0xec200eaa,   0x6c5ff266, 0xbff33600 ];

function RankPlayer(pid)
{
	var highScore, bestScore;
	var total_players, num_worse, pct;
	var cat;

	var filename = "thug/web/" + pid + ".txt";
    //var file = fileSystem.CreateTextFile( filename, true);

	// Rating begins with experience in terms of number of games played.
	rating = it.GetIntValue(GAMEID, pid, CAT_GENERAL, COL_NUM_GAMES, 0);
	//file.Write( "Num Games: " + rating + "\n" );
	if( rating > MAX_GAMES_CREDITED )
	{
		rating = MAX_GAMES_CREDITED;
	}

	// Now factor in high scores on all levels, relative to other high scores
	bestScore = it.GetIntValue(GAMEID, pid, CAT_GENERAL, COL_BEST_SCORE, 0 );
	for( j = 0; j < map_crcs.length; j++ )
	{
		cat = j + 1;
		highScore = it.GetIntValue(GAMEID, pid, cat, COL_HIGH_SCORE, 0);
		if( highScore == 0 )
		{
			continue;
		}

		// If they beat their global high score, use this nickname as their ratings nick name
		if( highScore > bestScore )
		{
			index = it.GetIntValue(GAMEID, pid, cat, COL_HIGH_SCORE_NICK, -1 );
			if( index != -1 )
			{
				it.SetIntValue(GAMEID, pid, CAT_GENERAL, COL_RATING_NICK, index );
			}
		}
		total_players = it.GetRowCountWhere(GAMEID, "( catagoryid = " + cat + " ) AND ( c0 > 0 )" );
		if( total_players == 0 )
		{
			continue;
		}
		
		//file.Write( "-- Level : " + j + "\n" );
		//file.Write( "High Score: " + highScore + "\n" );
		//file.Write( "Total Players: " + total_players + "\n" );
		
		num_worse = it.GetRowCountWhere(GAMEID, "( catagoryid = " + cat + " ) AND ( c0 < " + highScore + " ) AND ( c0 > 0 )" );
		//file.Write( "NumWorse: " + num_worse + "\n" );

		total_players = total_players - 1;
		if( total_players == 0 )
		{
			pct = 100.0;
		}
		else
		{
			pct = 100.0 * ( num_worse / total_players );
		}

		//file.Write( "Percentile: " + pct + "\n" );
		
		if( pct > 100.0 )
		{
			pct = 100.0;
		}
		rating += pct;
	}
		
	//file.Write( "--- Combo Trick Attack --- \n" );
	// Finally, factor in best combos on all levels, relative to other best combos
	// First, trick attack
	for( j = 0; j < map_crcs.length; j++ )
	{
		cat = j + 1;
		highCombo = it.GetIntValue(GAMEID, pid, cat, COL_HIGH_COMBO, 0);
		if( highCombo == 0 )
		{
			continue;
		}
		total_players = it.GetRowCountWhere(GAMEID, "( catagoryid = " + cat + " ) AND ( c1 > 0 )" );
		if( total_players == 0 )
		{
			continue;
		}
		

		//file.Write( "-- Level : " + j + "\n" );
		//file.Write( "High Combo: " + highCombo + "\n" );
		//file.Write( "Total Players: " + total_players + "\n" );
		
		num_worse = it.GetRowCountWhere(GAMEID, "( catagoryid = " + cat + " ) AND ( c1 < " + highCombo + " ) AND ( c1 > 0 )" );
		//file.Write( "NumWorse: " + num_worse + "\n" );
		
		total_players = total_players - 1;
		if( total_players == 0 )
		{
			pct = 100;
		}
		else
		{
			pct = 100 * ( num_worse / total_players );
		}

		//file.Write( "Percentile: " + pct + "\n" );
		if( pct > 100.0 )
		{
			pct = 100.0;
		}
		rating += pct;
	}
		
	it.SetIntValue(GAMEID, pid, CAT_GENERAL, COL_RATING, rating );
    
	var kv = ps.LoadRecord(GAMEID, pid, PS_GENERAL_CATEGORY, 2 );
	kv.SetIntValue( "Rating", rating );
	ps.SaveRecord(GAMEID, pid, PS_GENERAL_CATEGORY, 2, kv );

	//file.Close();
}

function CalculateRanking()
{
	var pid, row, index, name, score, count;
	//debug.LogString(GAMEID, LOG_INFORMATION, "Generated rankings");
	
	count = it.GetRowCountWhere( GAMEID, "catagoryid = " + CAT_GENERAL + " AND c0 > 0" );
	var rows = it.GetRows2( GAMEID, "profileid", "", "catagoryid = " + CAT_GENERAL + " AND c0 > 0", count, 0 );
	for( row = rows.lbound(2) ; row <= rows.ubound(2) ; row++)
	{
		pid = rows.getItem( 0, row );
		RankPlayer( pid );
	}

	var filename = "thug/web/ratings.tmp";
    var file = fileSystem.CreateTextFile( filename, true);

	var rows = it.GetRows( GAMEID, CAT_GENERAL, "profileid, c1", "c1 desc", 50, 0 );
	var row, index, name, score, rating;
	
	for(row = rows.lbound(2) ; row <= rows.ubound(2) ; row++)
	{		
		pid = rows.getItem( 0, row );
		rating = it.GetIntValue(GAMEID, pid, CAT_GENERAL, COL_RATING, 0 );
		score = it.GetIntValue(GAMEID, pid, CAT_GENERAL, COL_BEST_SCORE, 0 );
		index = it.GetIntValue(GAMEID, pid, CAT_GENERAL, COL_RATING_NICK, -1 );
		if( index != -1 )
		{
			name = st.GetString( index );
			if( name != "" )
			{
				file.Write( score + ":" + rating + ":" + name + "\n" );
			}
		}
	}
	file.Close();

	var out_filename = "thug/web/ratings.txt";
    fileSystem.CopyFile( filename, out_filename, true );
}
